/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.freemarker.editor;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentExtension3;
import org.eclipse.jface.text.IDocumentPartitioner;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.TypedRegion;
import org.eclipse.jface.text.rules.FastPartitioner;
import org.eclipse.ui.editors.text.FileDocumentProvider;
import org.jboss.ide.eclipse.freemarker.editor.partitions.PartitionScanner;
import org.jboss.ide.eclipse.freemarker.editor.partitions.PartitionType;
import org.jboss.ide.eclipse.freemarker.lang.SyntaxMode;

public class DocumentProvider
extends FileDocumentProvider {
    public static final String FTL_PARTITIONING = "org.jboss.ide.eclipse.freemarker.partitioning";

    protected IDocument createDocument(Object element) throws CoreException {
        IDocument document = super.createDocument(element);
        if (document != null) {
            FastPartitioner partitioner = new FastPartitioner(new PartitionScanner(), PartitionType.PARTITION_TYPES){

                public ITypedRegion getPartition(int offset, boolean preferOpenPartitions) {
                    ITypedRegion region = this.getPartition(offset);
                    if (preferOpenPartitions && region.getOffset() == offset && !region.getType().equals("__dftl_partition_content_type")) {
                        if (offset > 0 && (region = this.getPartition(offset - 1)).getType().equals(PartitionType.DIRECTIVE_START.name())) {
                            return region;
                        }
                        return new TypedRegion(offset, 0, "__dftl_partition_content_type");
                    }
                    return region;
                }
            };
            if (document instanceof IDocumentExtension3) {
                IDocumentExtension3 docExt3 = (IDocumentExtension3)document;
                docExt3.setDocumentPartitioner(FTL_PARTITIONING, (IDocumentPartitioner)partitioner);
                partitioner.connect(document);
            } else {
                document.setDocumentPartitioner((IDocumentPartitioner)partitioner);
                partitioner.connect(document);
            }
        }
        return document;
    }

    public static SyntaxMode findMode(IDocument document) {
        int docLength = document.getLength();
        if (docLength >= 2) {
            try {
                int s = 0;
                int i = 0;
                while (i < docLength && s < 3) {
                    char ch = document.getChar(i);
                    switch (ch) {
                        case '<': {
                            s = 1;
                            break;
                        }
                        case '[': {
                            s = 2;
                            break;
                        }
                        case '#': {
                            if (s == 1) {
                                s = 3;
                                break;
                            }
                            if (s == 2) {
                                s = 4;
                                break;
                            }
                            s = 0;
                            break;
                        }
                        default: {
                            s = 0;
                        }
                    }
                    ++i;
                }
                if (s == 3) {
                    return SyntaxMode.ANGLE;
                }
                if (s == 4) {
                    return SyntaxMode.SQUARE;
                }
                return SyntaxMode.getDefault();
            }
            catch (BadLocationException badLocationException) {
                return SyntaxMode.getDefault();
            }
        }
        return SyntaxMode.getDefault();
    }
}

