/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.freemarker.editor;

import java.util.HashMap;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.CompletionProposal;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.templates.Template;
import org.eclipse.jface.text.templates.TemplateCompletionProcessor;
import org.eclipse.jface.text.templates.TemplateContextType;
import org.eclipse.swt.graphics.Image;
import org.jboss.ide.eclipse.freemarker.Plugin;
import org.jboss.ide.eclipse.freemarker.configuration.ConfigurationManager;
import org.jboss.ide.eclipse.freemarker.configuration.ContextValue;
import org.jboss.ide.eclipse.freemarker.editor.Editor;
import org.jboss.ide.eclipse.freemarker.model.CompletionDirective;
import org.jboss.ide.eclipse.freemarker.model.CompletionInterpolation;
import org.jboss.ide.eclipse.freemarker.model.CompletionMacroInstance;
import org.jboss.ide.eclipse.freemarker.model.Item;
import org.jboss.ide.eclipse.freemarker.model.MacroInstance;

public class CompletionProcessor
extends TemplateCompletionProcessor
implements IContentAssistProcessor {
    private Editor editor;
    private static final ICompletionProposal[] NO_COMPLETIONS = new ICompletionProposal[0];

    public CompletionProcessor(Editor editor) {
        this.editor = editor;
    }

    public ICompletionProposal[] computeCompletionProposals(ITextViewer viewer, int offset) {
        HashMap context = new HashMap();
        ContextValue[] values = ConfigurationManager.getInstance(this.editor.getProject()).getContextValues((IResource)this.editor.getFile(), true);
        int i = 0;
        while (i < values.length) {
            context.put(values[i].name, values[i].objClass);
            ++i;
        }
        try {
            char c2;
            char c;
            int topOffset = viewer.getDocument().getLineInformationOfOffset(offset).getOffset();
            int i2 = offset - 1;
            while (i2 >= 0) {
                c = this.editor.getDocument().getChar(i2);
                if (c == '>' || c == ']') break;
                if ((c == '<' || c == '[') && this.editor.getDocument().getLength() > i2 + 1) {
                    c2 = this.editor.getDocument().getChar(i2 + 1);
                    if (c2 == '#') {
                        CompletionDirective completionDirective = new CompletionDirective(this.editor.getItemSet(), i2, offset - i2, (ISourceViewer)viewer, (IResource)this.editor.getFile());
                        return completionDirective.getCompletionProposals(offset, context);
                    }
                    if (c2 == '@') {
                        CompletionMacroInstance completionMacroInstance = new CompletionMacroInstance(this.editor.getItemSet(), this.editor.getDocument().get(i2, offset - i2), i2, (IResource)this.editor.getFile());
                        return completionMacroInstance.getCompletionProposals(offset, context);
                    }
                    if (c2 != '/') break;
                    if (this.editor.getDocument().getLength() < i2 + 3 || this.editor.getDocument().getChar(i2 + 2) == ' ' || this.editor.getDocument().getChar(i2 + 2) == '\r' || this.editor.getDocument().getChar(i2 + 2) == '\n') {
                        Item stackItem = this.editor.getItemSet().getPreviousStartItem(offset);
                        StringBuilder value = new StringBuilder();
                        if (stackItem != null && stackItem instanceof MacroInstance) {
                            value.append('@');
                        } else {
                            value.append('#');
                        }
                        String name = null;
                        if (stackItem != null) {
                            name = stackItem.getFirstToken();
                        }
                        if (name != null) {
                            value.append(name);
                        }
                        if (c == '<') {
                            value.append('>');
                        } else {
                            value.append(']');
                        }
                        CompletionProposal completionProposal = new CompletionProposal(value.toString(), offset, 0, offset + value.toString().length());
                        return new ICompletionProposal[]{completionProposal};
                    }
                }
                --i2;
            }
            i2 = offset - 1;
            while (i2 >= topOffset) {
                c = this.editor.getDocument().getChar(i2);
                if (c != '\n') {
                    if (c == '$' && this.editor.getDocument().getLength() > i2 + 1 && (c2 = this.editor.getDocument().getChar(i2 + 1)) == '{') {
                        int j = offset;
                        while (this.editor.getDocument().getLength() > j) {
                            char c3 = this.editor.getDocument().getChar(j);
                            if (Character.isWhitespace(c3) || c3 == '(' || c3 == '.' || c3 == ')' || c3 == '}' || c3 == '?') break;
                            ++j;
                        }
                        CompletionInterpolation interpolation = new CompletionInterpolation(this.editor.getItemSet(), this.editor.getDocument().get(i2, j - i2), i2, (IResource)this.editor.getFile());
                        interpolation.setParentItem(this.editor.getItemSet().getPreviousStartItem(offset));
                        return interpolation.getCompletionProposals(offset, context);
                    }
                    --i2;
                    continue;
                }
                break;
            }
        }
        catch (BadLocationException e) {
            Plugin.log(e);
        }
        return NO_COMPLETIONS;
    }

    protected TemplateContextType getContextType(ITextViewer viewer, IRegion region) {
        return null;
    }

    protected Image getImage(Template template) {
        return null;
    }

    protected Template[] getTemplates(String contextTypeId) {
        return null;
    }

    public char[] getCompletionProposalAutoActivationCharacters() {
        return new char[]{'.', '$', '#', '@', '/', '?', '{'};
    }
}

