/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.browsersim.browser;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.CloseWindowListener;
import org.eclipse.swt.browser.OpenWindowListener;
import org.eclipse.swt.browser.VisibilityWindowListener;
import org.eclipse.swt.browser.WindowEvent;
import org.eclipse.swt.widgets.Composite;
import org.jboss.tools.browsersim.browser.ExtendedCloseWindowListener;
import org.jboss.tools.browsersim.browser.ExtendedOpenWindowListener;
import org.jboss.tools.browsersim.browser.ExtendedVisibilityWindowListener;
import org.jboss.tools.browsersim.browser.ExtendedWindowEvent;
import org.jboss.tools.browsersim.browser.IBrowser;

public abstract class BrowserSimBrowser
extends Browser
implements IBrowser {
    private Map<ExtendedCloseWindowListener, CloseWindowListener> closeWindowListenerMap = new HashMap<ExtendedCloseWindowListener, CloseWindowListener>();
    private Map<ExtendedOpenWindowListener, OpenWindowListener> openWindowListenerMap = new HashMap<ExtendedOpenWindowListener, OpenWindowListener>();
    private Map<ExtendedVisibilityWindowListener, VisibilityWindowListener> visibilityWindowListenerMap = new HashMap<ExtendedVisibilityWindowListener, VisibilityWindowListener>();

    public BrowserSimBrowser(Composite parent, int style) {
        super(parent, style);
    }

    @Override
    public abstract void setUserAgent(String var1);

    protected void checkSubclass() {
    }

    @Override
    public void addCloseWindowListener(final ExtendedCloseWindowListener extendedListener) {
        CloseWindowListener listener = new CloseWindowListener(){

            public void close(WindowEvent event) {
                ExtendedWindowEvent extendedEvent = new ExtendedWindowEvent(event);
                extendedListener.close(extendedEvent);
                if (extendedEvent.browser instanceof Browser) {
                    event.browser = (Browser)extendedEvent.browser;
                }
            }
        };
        this.addCloseWindowListener(listener);
        this.closeWindowListenerMap.put(extendedListener, listener);
    }

    @Override
    public void removeCloseWindowListener(ExtendedCloseWindowListener extendedListener) {
        CloseWindowListener listener = this.closeWindowListenerMap.remove(extendedListener);
        if (listener != null) {
            this.removeCloseWindowListener(listener);
        }
    }

    @Override
    public void addOpenWindowListener(final ExtendedOpenWindowListener extendedListener) {
        OpenWindowListener listener = new OpenWindowListener(){

            public void open(WindowEvent event) {
                ExtendedWindowEvent extendedEvent = new ExtendedWindowEvent(event);
                extendedListener.open(extendedEvent);
                if (extendedEvent.browser instanceof Browser) {
                    event.browser = (Browser)extendedEvent.browser;
                }
            }
        };
        this.addOpenWindowListener(listener);
        this.openWindowListenerMap.put(extendedListener, listener);
    }

    @Override
    public void removeOpenWindowListener(ExtendedOpenWindowListener extendedListener) {
        OpenWindowListener listener = this.openWindowListenerMap.remove(extendedListener);
        if (listener != null) {
            this.removeOpenWindowListener(listener);
        }
    }

    @Override
    public void addVisibilityWindowListener(final ExtendedVisibilityWindowListener extendedListener) {
        VisibilityWindowListener listener = new VisibilityWindowListener(){

            public void show(WindowEvent event) {
                ExtendedWindowEvent extendedEvent = new ExtendedWindowEvent(event);
                extendedListener.show(extendedEvent);
            }

            public void hide(WindowEvent event) {
                ExtendedWindowEvent extendedEvent = new ExtendedWindowEvent(event);
                extendedListener.hide(extendedEvent);
            }
        };
        this.addVisibilityWindowListener(listener);
        this.visibilityWindowListenerMap.put(extendedListener, listener);
    }

    @Override
    public void removeVisibilityWindowListener(ExtendedVisibilityWindowListener extendedListener) {
        VisibilityWindowListener listener = this.visibilityWindowListenerMap.remove(extendedListener);
        if (listener != null) {
            this.removeVisibilityWindowListener(listener);
        }
    }
}

