/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.livereload.core.internal.server.jetty;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import javax.servlet.AsyncEvent;
import javax.servlet.AsyncListener;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.WriteListener;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.jboss.tools.livereload.core.internal.util.HttpUtils;
import org.jboss.tools.livereload.core.internal.util.Logger;
import org.jboss.tools.livereload.core.internal.util.ScriptInjectionUtils;

public class LiveReloadScriptInjectionFilter
implements Filter {
    private final String scriptContent;

    public LiveReloadScriptInjectionFilter(int livereloadPort) {
        this.scriptContent = "<script>document.write('<script src=\"http://' + location.host.split(':')[0]+ ':" + livereloadPort + "/livereload.js\"></'+ 'script>')</script>";
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        HttpServletResponse httpResponse = (HttpServletResponse)response;
        String acceptedContentTypes = httpRequest.getHeader("Accept");
        Logger.trace("Processing request {} {}", httpRequest.getMethod(), httpRequest.getRequestURI());
        if (!"/livereload".equals(httpRequest.getRequestURI()) && HttpUtils.isHtmlContentType(acceptedContentTypes)) {
            ModifiableHttpServletResponse responseWrapper = new ModifiableHttpServletResponse(httpResponse);
            chain.doFilter(request, (ServletResponse)responseWrapper);
            this.terminate(httpRequest, responseWrapper);
        } else {
            HttpServletResponseWrapper responseWrapper = new HttpServletResponseWrapper(httpResponse);
            chain.doFilter(request, response);
            this.terminate(httpRequest, responseWrapper);
        }
    }

    private void terminate(final HttpServletRequest httpRequest, final HttpServletResponseWrapper responseWrapper) throws IOException {
        if (httpRequest.isAsyncSupported() && httpRequest.isAsyncStarted()) {
            httpRequest.getAsyncContext().addListener(new AsyncListener(){

                public void onTimeout(AsyncEvent event) throws IOException {
                    Logger.error("Proxied request timed out");
                    LiveReloadScriptInjectionFilter.this.doTerminate(httpRequest, responseWrapper);
                }

                public void onStartAsync(AsyncEvent event) throws IOException {
                    Logger.debug("Proxied request async mode started");
                }

                public void onError(AsyncEvent event) throws IOException {
                    Logger.error("Proxied request failed", event.getThrowable());
                    LiveReloadScriptInjectionFilter.this.doTerminate(httpRequest, responseWrapper);
                }

                public void onComplete(AsyncEvent event) throws IOException {
                    Logger.debug("Proxied request completed");
                    LiveReloadScriptInjectionFilter.this.doTerminate(httpRequest, responseWrapper);
                }
            });
            if (!httpRequest.isAsyncStarted()) {
                this.doTerminate(httpRequest, responseWrapper);
            }
        } else {
            this.doTerminate(httpRequest, responseWrapper);
        }
    }

    private void doTerminate(HttpServletRequest httpRequest, HttpServletResponseWrapper responseWrapper) throws IOException {
        if (responseWrapper instanceof ModifiableHttpServletResponse) {
            this.doTerminate(httpRequest, (ModifiableHttpServletResponse)responseWrapper);
        } else {
            responseWrapper.flushBuffer();
        }
    }

    private void doTerminate(HttpServletRequest httpRequest, ModifiableHttpServletResponse responseWrapper) throws IOException {
        String returnedContentType = responseWrapper.getHeader("Content-Type");
        Logger.trace(" response type: {}", returnedContentType);
        if (HttpUtils.isHtmlContentType(returnedContentType)) {
            Logger.debug("Injecting livereload.js <script> in response for {} ({})", httpRequest.getRequestURI(), returnedContentType);
            InputStream responseStream = responseWrapper.getResponseAsStream();
            char[] modifiedResponseContent = ScriptInjectionUtils.injectContent(responseStream, this.scriptContent);
            Charset charset = HttpUtils.getContentCharSet(returnedContentType, "UTF-8");
            responseWrapper.terminate(modifiedResponseContent, charset);
        } else {
            Logger.trace("*Not* injecting livereload.js <script> in response for {} ({})", httpRequest.getRequestURI(), returnedContentType);
            responseWrapper.terminate();
        }
    }

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void destroy() {
    }

    public class ByteArrayServletOutputStream
    extends ServletOutputStream {
        private ByteArrayOutputStream outputStream = new ByteArrayOutputStream();

        public void write(int b) throws IOException {
            this.write(new byte[]{(byte)b});
        }

        public void write(byte[] b, int off, int len) throws IOException {
            this.outputStream.write(b, off, len);
        }

        public void write(byte[] b) throws IOException {
            this.outputStream.write(b);
        }

        public synchronized byte[] toByteArray() {
            return this.outputStream.toByteArray();
        }

        public boolean isReady() {
            return true;
        }

        public void setWriteListener(WriteListener writeListener) {
        }
    }

    public class ModifiableHttpServletResponse
    extends HttpServletResponseWrapper {
        private ByteArrayServletOutputStream responseOutputStream;

        public ModifiableHttpServletResponse(HttpServletResponse response) {
            super(response);
            this.responseOutputStream = new ByteArrayServletOutputStream();
        }

        public ServletOutputStream getOutputStream() throws IOException {
            return this.responseOutputStream;
        }

        public InputStream getResponseAsStream() throws IOException {
            byte[] byteArray = this.responseOutputStream.toByteArray();
            this.responseOutputStream.close();
            String characterEncoding = this.getCharacterEncoding();
            return IOUtils.toInputStream((String)new String(byteArray, characterEncoding), (String)characterEncoding);
        }

        public void terminate(char[] responseContent, Charset charset) throws IOException {
            CharBuffer charBuffer = CharBuffer.wrap(responseContent);
            ByteBuffer byteBuffer = charset.encode(charBuffer);
            ((HttpServletResponse)this.getResponse()).setHeader("Content-length", Integer.toString(byteBuffer.array().length));
            this.getResponse().getOutputStream().write(byteBuffer.array());
        }

        public void terminate() throws IOException {
            byte[] responseContent = this.responseOutputStream.toByteArray();
            this.responseOutputStream.close();
            IOUtils.write((byte[])responseContent, (OutputStream)this.getResponse().getOutputStream());
            this.getResponse().getOutputStream().flush();
            this.getResponse().getOutputStream().close();
        }
    }
}

