/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.livereload.core.internal.server.jetty;

import java.net.URI;
import java.net.URISyntaxException;
import javax.servlet.http.HttpServletRequest;
import org.eclipse.jetty.proxy.ProxyServlet;
import org.jboss.tools.livereload.core.internal.util.Logger;
import org.jboss.tools.livereload.core.internal.util.URIUtils;

public class ApplicationsProxyServlet
extends ProxyServlet {
    private static final long serialVersionUID = -743475231540209788L;
    private final String proxyHost;
    private final int proxyPort;
    private final int targetPort;
    private final String targetHost;

    public ApplicationsProxyServlet(String proxyHost, int proxyPort, String targetHost, int targetPort) {
        this.proxyHost = proxyHost;
        this.proxyPort = proxyPort;
        this.targetHost = targetHost;
        this.targetPort = targetPort;
    }

    protected URI rewriteURI(HttpServletRequest request) {
        try {
            URI requestURI = new URI(request.getRequestURI());
            URI originalURI = new URI(request.getScheme(), requestURI.getUserInfo(), request.getServerName(), request.getLocalPort(), requestURI.getPath(), request.getQueryString(), requestURI.getFragment());
            String proxiedURI = URIUtils.convert(originalURI).toHost(this.targetHost).toPort(this.targetPort);
            return new URI(proxiedURI);
        }
        catch (URISyntaxException e) {
            Logger.error("Failed to parse the requested URI", e);
            return null;
        }
    }

    public String filterResponseHeader(HttpServletRequest request, String headerName, String headerValue) {
        if ("Location".equals(headerName)) {
            try {
                return URIUtils.convert(headerValue).toHost(this.proxyHost).toPort(this.proxyPort);
            }
            catch (URISyntaxException e) {
                Logger.error("Failed to rewrite the 'Location' response header value '" + headerValue + "'", e);
            }
        }
        return super.filterResponseHeader(request, headerName, headerValue);
    }
}

