/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.central.internal.browser;

import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.widgets.Composite;
import org.jboss.tools.central.JBossCentralActivator;
import org.jboss.tools.usage.event.UsageEventType;
import org.jboss.tools.usage.event.UsageReporter;

public class VersionedBrowser
extends Browser {
    private String name;
    private String version;
    private static boolean usageReported = false;

    public VersionedBrowser(Composite parent, int style) {
        super(parent, style);
        if (System.getProperty("os.name", "generic").toLowerCase().indexOf("win") >= 0) {
            this.setUrl(this.getUrl());
        }
        String browserScript = "var ua = navigator.userAgent,tem,M=ua.match(/(opera|chrome|safari|firefox|msie|trident(?=\\/))\\/?\\s*(\\d+)/i) || [];if(/trident/i.test(M[1])){tem=/\\brv[ :]+(\\d+)/g.exec(ua) || [];return 'IE '+ '_' + (tem[1]||'');}var rv = ua.match(/rv:(\\d{1,2}[.]\\d{1,2})/i);if(rv != null) {return 'Mozilla' + '_' + rv[1];}M=M[2]? [M[1], M[2]]: [navigator.appName, navigator.appVersion, '-?'];if((tem=ua.match(/version\\/(\\d+)/i))!=null) {M.splice(1,1,tem[1]);}return M[0] + '_' + M[1];";
        String result = (String)this.evaluate(browserScript);
        this.name = result.substring(0, result.indexOf("_"));
        this.version = result.substring(result.indexOf("_") + 1);
        if (!usageReported) {
            UsageEventType eventType = JBossCentralActivator.getDefault().getUsedBrowserEventType();
            UsageReporter.getInstance().trackEvent(eventType.event(result));
            usageReported = true;
        }
    }

    public String getBrowserName() {
        return this.name;
    }

    public String getBrowserVersion() {
        return this.version;
    }

    public boolean isHTML5supported() {
        double browserVersion = Double.parseDouble(this.version);
        return !("Mozilla".equals(this.name) && browserVersion < 10.0) && (!"IE".equals(this.name) || !(browserVersion < 10.0));
    }

    protected void checkSubclass() {
    }

    public String toString() {
        return String.valueOf(((Object)((Object)this)).getClass().getSimpleName()) + ": " + this.name + " v" + this.version;
    }
}

