/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.aesh.core.internal.io;

import org.jboss.tools.aesh.core.internal.ansi.Command;
import org.jboss.tools.aesh.core.internal.ansi.CommandFactory;
import org.jboss.tools.aesh.core.internal.ansi.DefaultCommandFactory;
import org.jboss.tools.aesh.core.internal.io.AeshInputOutputHandler;
import org.jboss.tools.aesh.core.internal.io.AeshOutputFilter;

public class CommandFilter
implements AeshOutputFilter {
    private static final char ESCAPE_CHAR = '\u001b';
    private static final char CURSOR_SAVE = '7';
    private static final char CURSOR_RESTORE = '8';
    private static final char LEFT_BRACKET = '[';
    private static final String CURSOR_SAVE_SEQUENCE = new String(new char[]{'\u001b', '[', 's'});
    private static final String CURSOR_RESTORE_SEQUENCE = new String(new char[]{'\u001b', '[', 'u'});
    private CommandFactory commandFactory = DefaultCommandFactory.INSTANCE;
    private AeshInputOutputHandler handler = null;

    public CommandFilter(AeshInputOutputHandler handler) {
        this.handler = handler;
    }

    @Override
    public void filterOutput(String output) {
        int controlSequenceStart;
        int index = 0;
        block0: while ((controlSequenceStart = output.indexOf(27, index)) != -1) {
            this.handler.handleOutput(output.substring(index, controlSequenceStart));
            char next = output.charAt(controlSequenceStart + 1);
            if (next == '7') {
                this.handler.handleCommand(this.commandFactory.create(CURSOR_SAVE_SEQUENCE));
                index = controlSequenceStart + 2;
                continue;
            }
            if (next == '8') {
                this.handler.handleCommand(this.commandFactory.create(CURSOR_RESTORE_SEQUENCE));
                index = controlSequenceStart + 2;
                continue;
            }
            if (next == '[') {
                int controlSequenceEnd = controlSequenceStart + 3;
                while (true) {
                    Command command;
                    if ((command = this.commandFactory.create(output.substring(controlSequenceStart, controlSequenceEnd))) != null) {
                        this.handler.handleCommand(command);
                        index = controlSequenceEnd;
                        continue block0;
                    }
                    ++controlSequenceEnd;
                }
            }
            throw new RuntimeException("Unknown ANSI command sequence");
        }
        this.handler.handleOutput(output.substring(index));
    }

    void setCommandFactory(CommandFactory commandFactory) {
        this.commandFactory = commandFactory;
    }

    CommandFactory getCommandFactory() {
        return this.commandFactory;
    }
}

