/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.feedhenry.ui.internal.util;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.util.Collections;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.egit.core.op.AddToIndexOperation;
import org.eclipse.egit.core.op.CommitOperation;
import org.eclipse.egit.core.op.ConnectProviderOperation;
import org.eclipse.egit.core.project.RepositoryMapping;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.InitCommand;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.api.errors.JGitInternalException;
import org.eclipse.jgit.lib.Config;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.StoredConfig;
import org.eclipse.jgit.lib.UserConfig;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.transport.RemoteConfig;
import org.eclipse.jgit.transport.URIish;
import org.eclipse.osgi.util.NLS;
import org.eclipse.team.core.RepositoryProvider;

public final class GitUtil {
    private static final String EGIT_TEAM_PROVIDER_ID = "org.eclipse.egit.core.GitProvider";

    public static boolean isGitEnabled(IProject project) {
        RepositoryProvider provider = RepositoryProvider.getProvider((IProject)project);
        return provider != null && EGIT_TEAM_PROVIDER_ID.equals(provider.getID());
    }

    public static void addRemoteConfig(String remoteName, URIish uri, Repository repository) throws URISyntaxException, MalformedURLException, IOException {
        StoredConfig config = repository.getConfig();
        RemoteConfig remoteConfig = new RemoteConfig((Config)config, remoteName);
        remoteConfig.addURI(uri);
        remoteConfig.update((Config)config);
        config.save();
    }

    public static Repository getRepository(IProject project) {
        if (project == null) {
            return null;
        }
        RepositoryMapping repositoryMapping = RepositoryMapping.getMapping((IProject)project);
        if (repositoryMapping == null) {
            return null;
        }
        return repositoryMapping.getRepository();
    }

    public static Repository share(IProject project, IProgressMonitor monitor) throws CoreException {
        Repository repository = GitUtil.createRepository(project, monitor);
        GitUtil.connect(project, repository.getDirectory(), monitor);
        GitUtil.addToRepository(project, repository, monitor);
        GitUtil.commit(project, "Initial commit from JBoss Tools", repository, monitor);
        return repository;
    }

    public static Repository createRepository(IProject project, IProgressMonitor monitor) throws CoreException {
        try {
            InitCommand init = Git.init();
            init.setBare(false).setDirectory(project.getLocation().toFile());
            Git git = init.call();
            return git.getRepository();
        }
        catch (GitAPIException | JGitInternalException e) {
            throw new CoreException((IStatus)new Status(4, "org.jboss.tools.feedhenry.ui", NLS.bind((String)"Could not initialize a git repository at {0}: {1}", (Object)GitUtil.getRepositoryPathFor(project), (Object)e.getMessage()), e));
        }
    }

    public static File getRepositoryPathFor(IProject project) {
        return new File(project.getLocationURI().getPath(), ".git");
    }

    private static void connect(IProject project, File repositoryFolder, IProgressMonitor monitor) throws CoreException {
        new ConnectProviderOperation(project, repositoryFolder).execute(monitor);
    }

    public static void addToRepository(IProject project, Repository repository, IProgressMonitor monitor) throws CoreException {
        AddToIndexOperation add = new AddToIndexOperation(Collections.singletonList(project));
        add.execute(monitor);
    }

    private static RevCommit commit(IProject project, String commitMessage, Repository repository, IProgressMonitor monitor) throws CoreException {
        UserConfig userConfig = GitUtil.getUserConfig(repository);
        CommitOperation op = new CommitOperation(null, null, null, GitUtil.getFormattedUser(userConfig.getAuthorName(), userConfig.getAuthorEmail()), GitUtil.getFormattedUser(userConfig.getCommitterName(), userConfig.getCommitterEmail()), commitMessage);
        op.setCommitAll(true);
        op.setRepository(repository);
        op.execute(monitor);
        return op.getCommit();
    }

    private static UserConfig getUserConfig(Repository repository) throws CoreException {
        Assert.isNotNull((Object)repository, (String)"Could not get user configuration. No repository provided.");
        if (repository.getConfig() == null) {
            throw new CoreException((IStatus)new Status(4, "org.jboss.tools.feedhenry.ui", NLS.bind((String)"no user configuration (author, committer) are present in repository \"{0}\"", (Object)repository.toString())));
        }
        return (UserConfig)repository.getConfig().get(UserConfig.KEY);
    }

    private static String getFormattedUser(String name, String email) {
        return name + " <" + email + '>';
    }
}

