/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.feedhenry.ui.cordova.internal.wizards;

import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.thym.core.HybridCore;
import org.eclipse.thym.core.HybridProject;
import org.jboss.tools.feedhenry.ui.cordova.internal.preferences.FHPreferences;
import org.jboss.tools.feedhenry.ui.internal.FHAppLabelProvider;
import org.jboss.tools.feedhenry.ui.internal.FHApplicationContentProvider;
import org.jboss.tools.feedhenry.ui.internal.FHErrorHandler;
import org.jboss.tools.feedhenry.ui.model.FeedHenry;
import org.jboss.tools.feedhenry.ui.model.FeedHenryException;
import org.jboss.tools.feedhenry.ui.model.FeedHenryProject;

public class FHProjectSelectionPage
extends WizardPage {
    private TableViewer projectList;
    private ComboViewer localProject;
    private Text remoteName;
    private Button useDefaultAppName;
    private Text appName;
    private final IStructuredSelection initialSelection;

    protected FHProjectSelectionPage(IStructuredSelection selection) {
        super("FeedHenry Project Selection Page");
        this.setTitle("Create FeedHenry Application");
        this.setDescription("Create a new Application on FeedHenry platform");
        this.initialSelection = selection;
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite workArea = new Composite(parent, 0);
        this.setControl((Control)workArea);
        GridLayoutFactory.fillDefaults().numColumns(2).applyTo(workArea);
        GridDataFactory.fillDefaults().indent(10, 5).grab(true, true).align(4, 4).applyTo((Control)workArea);
        Label localProjectLabel = new Label(workArea, 0);
        localProjectLabel.setText("Source project:");
        GridDataFactory.fillDefaults().applyTo((Control)localProjectLabel);
        Combo projectCombo = new Combo(workArea, 12);
        GridDataFactory.fillDefaults().grab(true, false).align(4, 4).applyTo((Control)projectCombo);
        this.localProject = new ComboViewer(projectCombo);
        this.localProject.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.localProject.setInput((Object)HybridCore.getHybridProjects());
        this.localProject.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                if (element instanceof HybridProject) {
                    return ((HybridProject)element).getProject().getName();
                }
                return super.getText(element);
            }
        });
        Label projectLabel = new Label(workArea, 0);
        projectLabel.setText("Select FeedHenry project: ");
        GridDataFactory.fillDefaults().span(2, 1).grab(true, false).align(1, 4).applyTo((Control)projectLabel);
        this.projectList = new TableViewer(workArea, 65540);
        this.projectList.setLabelProvider((IBaseLabelProvider)new FHAppLabelProvider());
        this.projectList.setContentProvider((IContentProvider)new FHApplicationContentProvider());
        GridDataFactory.fillDefaults().span(2, 1).grab(true, false).align(4, 0x1000000).hint(-1, 100).applyTo((Control)this.projectList.getTable());
        Group appNameGrp = new Group(workArea, 0);
        appNameGrp.setText("Application name");
        GridDataFactory.fillDefaults().span(2, 1).grab(true, false).align(4, 4).applyTo((Control)appNameGrp);
        GridLayoutFactory.fillDefaults().numColumns(3).applyTo((Composite)appNameGrp);
        this.useDefaultAppName = new Button((Composite)appNameGrp, 32);
        this.useDefaultAppName.setText("Use project name");
        this.useDefaultAppName.setSelection(true);
        GridDataFactory.fillDefaults().span(3, 1).applyTo((Control)this.useDefaultAppName);
        new Label((Composite)appNameGrp, 0);
        final Label appNameLabel = new Label((Composite)appNameGrp, 0);
        appNameLabel.setText("Application name:");
        GridDataFactory.fillDefaults().applyTo((Control)appNameLabel);
        appNameLabel.setEnabled(false);
        this.appName = new Text((Composite)appNameGrp, 2052);
        this.appName.setEnabled(false);
        this.useDefaultAppName.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                boolean enabled = !FHProjectSelectionPage.this.useDefaultAppName.getSelection();
                FHProjectSelectionPage.this.appName.setEnabled(enabled);
                appNameLabel.setEnabled(enabled);
            }
        });
        GridDataFactory.fillDefaults().grab(true, false).align(4, 4).applyTo((Control)this.appName);
        Label remoteLabel = new Label(workArea, 0);
        remoteLabel.setText("Git remote name:");
        GridDataFactory.fillDefaults().applyTo((Control)remoteLabel);
        this.remoteName = new Text(workArea, 2052);
        this.remoteName.setText("feedhenry");
        GridDataFactory.fillDefaults().grab(true, false).align(4, 4).applyTo((Control)this.remoteName);
        this.registerListeners();
        this.selectProjectFromSelection();
        Dialog.applyDialogFont((Control)workArea);
        this.setPageComplete(false);
    }

    public void setVisible(boolean visible) {
        if (visible) {
            this.getControl().getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    FHProjectSelectionPage.this.retrieveProjects();
                }
            });
        }
        super.setVisible(visible);
    }

    private void registerListeners() {
        ISelectionChangedListener validateListener = new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                FHProjectSelectionPage.this.setPageComplete(FHProjectSelectionPage.this.isValid());
            }
        };
        this.projectList.addSelectionChangedListener(validateListener);
        this.localProject.addSelectionChangedListener(validateListener);
        this.remoteName.addListener(24, new Listener(){

            public void handleEvent(Event event) {
                FHProjectSelectionPage.this.setPageComplete(FHProjectSelectionPage.this.isValid());
            }
        });
    }

    private boolean isValid() {
        if (this.localProject.getSelection().isEmpty()) {
            this.setErrorMessage("Please specify a project");
            return false;
        }
        if (this.projectList.getSelection().isEmpty()) {
            this.setErrorMessage("Please specify a FeedHenry project");
            return false;
        }
        if (!this.useDefaultAppName.getSelection() && this.appName.getText().isEmpty()) {
            this.setErrorMessage("Please specify an application name");
            return false;
        }
        if (this.remoteName.getText() == null || this.remoteName.getText().isEmpty()) {
            this.setErrorMessage("Please specify a Git remote name for FeedHenry repository");
            return false;
        }
        this.setErrorMessage(null);
        return true;
    }

    private void retrieveProjects() {
        block2: {
            try {
                this.getContainer().run(false, true, new IRunnableWithProgress(){

                    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                        FeedHenry fh = new FeedHenry();
                        FHPreferences prefs = FHPreferences.getPreferences();
                        String feedHenryURL = prefs.getFeedHenryURL();
                        if (feedHenryURL == null || feedHenryURL.isEmpty()) {
                            CoreException ce = new CoreException((IStatus)new Status(4, "org.jboss.tools.feedhenry.ui", 10, "FeedHenry URL preference is empty. Specify FeedHenry URL on preferences.", null));
                            throw new InvocationTargetException(ce);
                        }
                        try {
                            if (monitor.isCanceled()) {
                                throw new OperationCanceledException();
                            }
                            FHProjectSelectionPage.this.projectList.setInput(fh.setFeedHenryURL(new URL(feedHenryURL)).setAPIKey(prefs.getUserAPIKey()).listProjects(monitor));
                        }
                        catch (MalformedURLException e) {
                            CoreException ce = new CoreException((IStatus)new Status(4, "org.jboss.tools.feedhenry.ui", 10, NLS.bind((String)"{0} is not a valid URL", (Object)feedHenryURL), (Throwable)e));
                            throw new InvocationTargetException(ce);
                        }
                        catch (FeedHenryException e) {
                            CoreException ce = new CoreException((IStatus)new Status(4, "org.jboss.tools.feedhenry.ui", e.getCode(), e.getMessage(), (Throwable)e));
                            throw new InvocationTargetException(ce);
                        }
                    }
                });
            }
            catch (InterruptedException | InvocationTargetException e) {
                if (!FHErrorHandler.handle(e)) break block2;
                this.retrieveProjects();
            }
        }
    }

    private void selectProjectFromSelection() {
        if (this.initialSelection != null && !this.initialSelection.isEmpty()) {
            for (Object object : this.initialSelection) {
                IProject project;
                HybridProject hp;
                if (!(object instanceof IResource) || (hp = HybridProject.getHybridProject((IProject)(project = ((IResource)object).getProject()))) == null) continue;
                this.localProject.setSelection((ISelection)new StructuredSelection((Object)hp));
            }
        }
    }

    HybridProject getHybridProject() {
        IStructuredSelection selection = (IStructuredSelection)this.localProject.getSelection();
        if (selection.isEmpty()) {
            return null;
        }
        return (HybridProject)selection.getFirstElement();
    }

    FeedHenryProject getFeedHenryProject() {
        IStructuredSelection selection = (IStructuredSelection)this.projectList.getSelection();
        if (selection.isEmpty()) {
            return null;
        }
        return (FeedHenryProject)selection.getFirstElement();
    }

    String getApplicationName() {
        if (this.useDefaultAppName.getSelection()) {
            return this.getHybridProject().getAppName();
        }
        return this.appName.getText();
    }

    String getRemoteName() {
        return this.remoteName.getText();
    }
}

