/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.docker.ui.wizards;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.ValidationStatusProvider;
import org.eclipse.core.databinding.beans.BeanProperties;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.list.WritableList;
import org.eclipse.core.databinding.observable.set.IObservableSet;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.IValueChangeListener;
import org.eclipse.core.databinding.observable.value.ValueChangeEvent;
import org.eclipse.core.databinding.property.value.IValueProperty;
import org.eclipse.core.databinding.validation.MultiValidator;
import org.eclipse.core.databinding.validation.ValidationStatus;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.jface.databinding.swt.WidgetProperties;
import org.eclipse.jface.databinding.viewers.ObservableListContentProvider;
import org.eclipse.jface.databinding.viewers.ViewerSupport;
import org.eclipse.jface.databinding.viewers.ViewersObservables;
import org.eclipse.jface.databinding.wizard.WizardPageSupport;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.fieldassist.ComboContentAdapter;
import org.eclipse.jface.fieldassist.ContentProposal;
import org.eclipse.jface.fieldassist.ContentProposalAdapter;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.fieldassist.IContentProposal;
import org.eclipse.jface.fieldassist.IContentProposalProvider;
import org.eclipse.jface.fieldassist.IControlContentAdapter;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.linuxtools.docker.core.DockerException;
import org.eclipse.linuxtools.docker.core.IDockerConnection;
import org.eclipse.linuxtools.docker.core.IDockerContainer;
import org.eclipse.linuxtools.docker.core.IDockerImage;
import org.eclipse.linuxtools.docker.core.IDockerImageInfo;
import org.eclipse.linuxtools.docker.core.IDockerProgressHandler;
import org.eclipse.linuxtools.docker.ui.Activator;
import org.eclipse.linuxtools.docker.ui.wizards.ImageSearch;
import org.eclipse.linuxtools.internal.docker.ui.SWTImagesFactory;
import org.eclipse.linuxtools.internal.docker.ui.commands.CommandUtils;
import org.eclipse.linuxtools.internal.docker.ui.jobs.FindImageInfoRunnable;
import org.eclipse.linuxtools.internal.docker.ui.views.DVMessages;
import org.eclipse.linuxtools.internal.docker.ui.views.ImagePullProgressHandler;
import org.eclipse.linuxtools.internal.docker.ui.wizards.ContainerLinkDialog;
import org.eclipse.linuxtools.internal.docker.ui.wizards.ContainerPortDialog;
import org.eclipse.linuxtools.internal.docker.ui.wizards.ImageRunSelectionModel;
import org.eclipse.linuxtools.internal.docker.ui.wizards.WizardMessages;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class ImageRunSelectionPage
extends WizardPage {
    private static final int INDENT = 30;
    private static final String ERROR_PULLING_IMAGE = "ImagePullError.msg";
    private final DataBindingContext dbc = new DataBindingContext();
    private final ImageRunSelectionModel model;
    private final ILaunchConfiguration lastLaunchConfiguration;
    private static final int COLUMNS = 3;

    public ImageRunSelectionPage(IDockerImage selectedImage, ILaunchConfiguration lastLaunchConfiguration) {
        super("ImageSelectionPage", WizardMessages.getString("ImageSelectionPage.title"), SWTImagesFactory.DESC_BANNER_REPOSITORY);
        this.setMessage(WizardMessages.getString("ImageSelectionPage.runImage"));
        this.setPageComplete(true);
        this.model = new ImageRunSelectionModel(selectedImage);
        this.lastLaunchConfiguration = lastLaunchConfiguration;
    }

    public ImageRunSelectionPage(IDockerConnection selectedConnection) {
        super("ImageSelectionPage", WizardMessages.getString("ImageSelectionPage.exposedPortTitle"), SWTImagesFactory.DESC_BANNER_REPOSITORY);
        this.setMessage(WizardMessages.getString("ImageRunSelectionPage.exposedPortMsg"));
        this.setPageComplete(false);
        this.model = new ImageRunSelectionModel(selectedConnection);
        this.lastLaunchConfiguration = null;
    }

    public ImageRunSelectionModel getModel() {
        return this.model;
    }

    public void dispose() {
        this.dbc.dispose();
        super.dispose();
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridDataFactory.fillDefaults().align(4, 4).span(1, 1).grab(true, false).applyTo((Control)container);
        GridLayoutFactory.fillDefaults().numColumns(3).margins(6, 6).applyTo(container);
        this.setDefaultValues();
        this.createImageSettingsSection(container);
        this.createSectionSeparator(container, true);
        this.createPortSettingsSection(container);
        this.createLinkSettingsSection(container);
        this.createRunOptionsSection(container);
        IObservableValue imageSelectionObservable = BeanProperties.value(ImageRunSelectionModel.class, (String)"selectedImageName").observe((Object)this.model);
        imageSelectionObservable.addValueChangeListener(this.onImageSelectionChange());
        WizardPageSupport.create((WizardPage)this, (DataBindingContext)this.dbc);
        ImageSelectionValidator imageSelectionValidator = new ImageSelectionValidator(imageSelectionObservable);
        imageSelectionObservable.addValueChangeListener(this.onImageSelectionChange());
        this.dbc.addValidationStatusProvider((ValidationStatusProvider)imageSelectionValidator);
        imageSelectionObservable.addValueChangeListener(this.onImageSelectionChange());
        IObservableValue containerNameObservable = BeanProperties.value(ImageRunSelectionModel.class, (String)"containerName").observe((Object)this.model);
        ContainerNameValidator containerNameValidator = new ContainerNameValidator(this.model.getSelectedConnection(), containerNameObservable);
        this.dbc.addValidationStatusProvider((ValidationStatusProvider)containerNameValidator);
        Object containerstatus = containerNameValidator.getValidationStatus().getValue();
        WizardPageSupport.create((WizardPage)this, (DataBindingContext)this.dbc);
        this.setStatusMessage(containerstatus);
        this.setControl((Control)container);
    }

    private void setStatusMessage(Object containerstatus) {
        if (containerstatus instanceof ValidationStatus) {
            ValidationStatus validationStatus = (ValidationStatus)containerstatus;
            if (validationStatus.getSeverity() == 4) {
                this.setMessage(validationStatus.getMessage(), 3);
            } else if (validationStatus.getSeverity() == 2) {
                this.setMessage(validationStatus.getMessage(), 2);
            }
        } else if (containerstatus instanceof IStatus) {
            IStatus status = (IStatus)containerstatus;
            if (status.getSeverity() == 4) {
                this.setMessage(status.getMessage(), 3);
            } else if (status != null && status.getSeverity() == 2) {
                this.setMessage(status.getMessage(), 2);
            }
        }
    }

    private void createSectionSeparator(Composite container, boolean separator) {
        int SECTION_INDENT = 10;
        GridDataFactory.fillDefaults().align(4, 0x1000000).span(3, 1).grab(true, false).indent(-1, 10).applyTo((Control)new Label(container, separator ? 258 : 0));
    }

    private void createImageSettingsSection(Composite container) {
        Label imageSelectionLabel = new Label(container, 0);
        imageSelectionLabel.setText(WizardMessages.getString("ImageRunSelectionPage.imageName"));
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(false, false).applyTo((Control)imageSelectionLabel);
        Combo imageSelectionCombo = new Combo(container, 2048);
        ComboViewer imageSelectionComboViewer = new ComboViewer(imageSelectionCombo);
        imageSelectionCombo.setToolTipText(WizardMessages.getString("ImageRunSelectionPage.selectTooltip"));
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).span(1, 1).applyTo((Control)imageSelectionCombo);
        new ControlDecoration((Control)imageSelectionCombo, 16512);
        new ContentProposalAdapter((Control)imageSelectionCombo, (IControlContentAdapter)new ComboContentAdapter(){

            public void insertControlContents(Control control, String text, int cursorPosition) {
                Combo combo = (Combo)control;
                Point selection = combo.getSelection();
                combo.setText(text);
                selection.y = selection.x = text.length();
                combo.setSelection(selection);
            }
        }, this.getImageNameContentProposalProvider(imageSelectionCombo), null, null);
        Button searchImageButton = new Button(container, 0);
        searchImageButton.setText(WizardMessages.getString("ImageRunSelectionPage.search"));
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(false, false).span(1, 1).applyTo((Control)searchImageButton);
        searchImageButton.addSelectionListener(this.onSearchImage());
        Label fillerLabel = new Label(container, 0);
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(false, false).span(1, 1).applyTo((Control)fillerLabel);
        Link pullImageLink = new Link(container, 0);
        pullImageLink.setText(WizardMessages.getString("ImageRunSelectionPage.pullImage"));
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).span(2, 1).applyTo((Control)pullImageLink);
        pullImageLink.addSelectionListener(this.onPullImage());
        this.dbc.bindValue((IObservableValue)WidgetProperties.enabled().observe((Widget)pullImageLink), BeanProperties.value(ImageRunSelectionModel.class, (String)"selectedImageNeedsPulling").observe((Object)this.model));
        imageSelectionComboViewer.setContentProvider((IContentProvider)new ObservableListContentProvider());
        this.dbc.bindList((IObservableList)WidgetProperties.items().observe((Widget)imageSelectionCombo), BeanProperties.list(ImageRunSelectionModel.class, (String)"imageNames").observe((Object)this.model));
        this.dbc.bindValue((IObservableValue)WidgetProperties.selection().observe((Widget)imageSelectionCombo), BeanProperties.value(ImageRunSelectionModel.class, (String)"selectedImageName").observe((Object)this.model));
        Label containerNameLabel = new Label(container, 0);
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(false, false).applyTo((Control)imageSelectionLabel);
        containerNameLabel.setText(WizardMessages.getString("ImageRunSelectionPage.containerName"));
        Text containerNameText = new Text(container, 2048);
        containerNameText.setToolTipText(WizardMessages.getString("ImageRunSelectionPage.containerTooltip"));
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).span(1, 1).applyTo((Control)containerNameText);
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(false, false).span(1, 1).applyTo((Control)new Label(container, 0));
        this.dbc.bindValue((IObservableValue)WidgetProperties.text((int)24).observe((Widget)containerNameText), BeanProperties.value(ImageRunSelectionModel.class, (String)"containerName").observe((Object)this.model));
        Label entrypointLabel = new Label(container, 0);
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(false, false).applyTo((Control)imageSelectionLabel);
        entrypointLabel.setText(WizardMessages.getString("ImageRunSelectionPage.entrypoint"));
        Text entrypointText = new Text(container, 2048);
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).span(1, 1).applyTo((Control)entrypointText);
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(false, false).span(1, 1).applyTo((Control)new Label(container, 0));
        this.dbc.bindValue((IObservableValue)WidgetProperties.text((int)24).observe((Widget)entrypointText), BeanProperties.value(ImageRunSelectionModel.class, (String)"entrypoint").observe((Object)this.model));
        Label commandLabel = new Label(container, 0);
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(false, false).applyTo((Control)imageSelectionLabel);
        commandLabel.setText(WizardMessages.getString("ImageRunSelectionPage.command"));
        Text commandText = new Text(container, 2048);
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).span(1, 1).applyTo((Control)commandText);
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(false, false).span(1, 1).applyTo((Control)new Label(container, 0));
        this.dbc.bindValue((IObservableValue)WidgetProperties.text((int)24).observe((Widget)commandText), BeanProperties.value(ImageRunSelectionModel.class, (String)"command").observe((Object)this.model));
    }

    private void createPortSettingsSection(Composite container) {
        Button publishAllPortsButton = new Button(container, 32);
        publishAllPortsButton.setText(WizardMessages.getString("ImageRunSelectionPage.publishAllPorts"));
        GridDataFactory.fillDefaults().align(4, 0x1000000).span(3, 1).grab(true, false).applyTo((Control)publishAllPortsButton);
        this.dbc.bindValue((IObservableValue)WidgetProperties.selection().observe((Widget)publishAllPortsButton), BeanProperties.value(ImageRunSelectionModel.class, (String)"publishAllPorts").observe((Object)this.model));
        Label portSettingsLabel = new Label(container, 0);
        portSettingsLabel.setText(WizardMessages.getString("ImageRunSelectionPage.portSettings"));
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).span(3, 1).indent(30, 0).applyTo((Control)portSettingsLabel);
        CheckboxTableViewer exposedPortsTableViewer = this.createPortSettingsTable(container);
        GridDataFactory.fillDefaults().align(4, 128).grab(true, false).span(2, 1).indent(30, 0).hint(200, 70).applyTo((Control)exposedPortsTableViewer.getTable());
        Composite buttonsContainers = new Composite(container, 0);
        GridDataFactory.fillDefaults().align(4, 128).grab(false, false).applyTo((Control)buttonsContainers);
        GridLayoutFactory.fillDefaults().numColumns(1).margins(0, 0).spacing(-1, 0).applyTo(buttonsContainers);
        Button addButton = new Button(buttonsContainers, 0);
        GridDataFactory.fillDefaults().align(4, 128).grab(true, false).applyTo((Control)addButton);
        addButton.setText(WizardMessages.getString("ImageRunSelectionPage.add"));
        addButton.addSelectionListener(this.onAddPort(exposedPortsTableViewer));
        Button editButton = new Button(buttonsContainers, 0);
        GridDataFactory.fillDefaults().align(4, 128).grab(true, false).applyTo((Control)editButton);
        editButton.setText(WizardMessages.getString("ImageRunSelectionPage.editButton"));
        editButton.setEnabled(false);
        editButton.addSelectionListener(this.onEditPort(exposedPortsTableViewer));
        Button removeButton = new Button(buttonsContainers, 0);
        GridDataFactory.fillDefaults().align(4, 128).grab(true, false).applyTo((Control)removeButton);
        removeButton.setText(WizardMessages.getString("ImageRunSelectionPage.remove"));
        removeButton.addSelectionListener(this.onRemovePorts((TableViewer)exposedPortsTableViewer));
        BeanProperties.value(ImageRunSelectionModel.class, (String)"publishAllPorts").observe((Object)this.model).addValueChangeListener(this.onPublishAllPortsChange(new Control[]{exposedPortsTableViewer.getTable(), addButton, removeButton}));
        ViewerSupport.bind((StructuredViewer)exposedPortsTableViewer, (IObservableList)this.model.getExposedPorts(), (IValueProperty[])BeanProperties.values(ImageRunSelectionModel.ExposedPortModel.class, (String[])new String[]{"containerPort", "portType", "hostAddress", "hostPort"}));
        this.dbc.bindSet((IObservableSet)ViewersObservables.observeCheckedElements((CheckboxTableViewer)exposedPortsTableViewer, ImageRunSelectionModel.ExposedPortModel.class), BeanProperties.set((String)"selectedPorts").observe((Object)this.model));
        this.checkAllElements(exposedPortsTableViewer);
        exposedPortsTableViewer.addSelectionChangedListener(this.onSelectionChanged(editButton, removeButton));
        this.togglePortMappingControls(new Control[]{exposedPortsTableViewer.getTable(), addButton, removeButton});
    }

    private void checkAllElements(CheckboxTableViewer exposedPortsTableViewer) {
        exposedPortsTableViewer.setAllChecked(true);
        this.model.setSelectedPorts(new HashSet<ImageRunSelectionModel.ExposedPortModel>((Collection<ImageRunSelectionModel.ExposedPortModel>)this.model.getExposedPorts()));
    }

    private ISelectionChangedListener onSelectionChanged(final Button ... targetButtons) {
        return new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent e) {
                if (e.getSelection().isEmpty()) {
                    ImageRunSelectionPage.setControlsEnabled((Control[])targetButtons, false);
                } else {
                    ImageRunSelectionPage.setControlsEnabled((Control[])targetButtons, true);
                }
            }
        };
    }

    private CheckboxTableViewer createPortSettingsTable(Composite container) {
        Table table = new Table(container, 68384);
        CheckboxTableViewer tableViewer = new CheckboxTableViewer(table);
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        this.createTableViewerColum((TableViewer)tableViewer, WizardMessages.getString("ImageRunSelectionPage.containerPortColumn"), 100);
        this.createTableViewerColum((TableViewer)tableViewer, WizardMessages.getString("ImageRunSelectionPage.typeColumn"), 50);
        this.createTableViewerColum((TableViewer)tableViewer, WizardMessages.getString("ImageRunSelectionPage.hostAddressColumn"), 100);
        this.createTableViewerColum((TableViewer)tableViewer, WizardMessages.getString("ImageRunSelectionPage.hostPortColumn"), 100);
        tableViewer.setContentProvider((IContentProvider)new ObservableListContentProvider());
        return tableViewer;
    }

    private TableViewerColumn createTableViewerColum(TableViewer tableViewer, String title, int width) {
        TableViewerColumn viewerColumn = new TableViewerColumn(tableViewer, 0);
        TableColumn column = viewerColumn.getColumn();
        if (title != null) {
            column.setText(title);
        }
        column.setWidth(width);
        return viewerColumn;
    }

    private void createLinkSettingsSection(Composite container) {
        Label linksLabel = new Label(container, 0);
        linksLabel.setText(WizardMessages.getString("ImageRunSelectionPage.links"));
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(false, false).span(3, 1).applyTo((Control)linksLabel);
        TableViewer linksTableViewer = this.createLinksTable(container);
        GridDataFactory.fillDefaults().align(4, 128).grab(true, true).span(2, 1).hint(200, 50).indent(30, -1).applyTo((Control)linksTableViewer.getTable());
        Composite buttonsContainers = new Composite(container, 0);
        GridDataFactory.fillDefaults().align(4, 128).grab(false, false).applyTo((Control)buttonsContainers);
        GridLayoutFactory.fillDefaults().numColumns(1).margins(0, 0).spacing(-1, 0).applyTo(buttonsContainers);
        Button addButton = new Button(buttonsContainers, 0);
        GridDataFactory.fillDefaults().align(4, 128).grab(true, false).applyTo((Control)addButton);
        addButton.setText(WizardMessages.getString("ImageRunSelectionPage.addButton"));
        addButton.addSelectionListener(this.onAddLink());
        Button editButton = new Button(buttonsContainers, 0);
        GridDataFactory.fillDefaults().align(4, 128).grab(true, false).applyTo((Control)editButton);
        editButton.setText(WizardMessages.getString("ImageRunSelectionPage.editButton"));
        editButton.setEnabled(false);
        editButton.addSelectionListener(this.onEditLink(linksTableViewer));
        Button removeButton = new Button(buttonsContainers, 0);
        GridDataFactory.fillDefaults().align(4, 128).grab(true, false).applyTo((Control)removeButton);
        removeButton.setText(WizardMessages.getString("ImageRunSelectionPage.remove"));
        removeButton.addSelectionListener(this.onRemoveLinks(linksTableViewer));
        removeButton.setEnabled(false);
        ViewerSupport.bind((StructuredViewer)linksTableViewer, (IObservableList)this.model.getLinks(), (IValueProperty[])BeanProperties.values(ImageRunSelectionModel.ContainerLinkModel.class, (String[])new String[]{"containerName", "containerAlias"}));
        linksTableViewer.addSelectionChangedListener(this.onSelectionChanged(editButton, removeButton));
    }

    private TableViewer createLinksTable(Composite container) {
        Table table = new Table(container, 2818);
        TableViewer tableViewer = new TableViewer(table);
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        this.createTableViewerColum(tableViewer, WizardMessages.getString("ImageRunSelectionPage.containerNameColumn"), 200);
        this.createTableViewerColum(tableViewer, WizardMessages.getString("ImageRunSelectionPage.aliasColumn"), 150);
        return tableViewer;
    }

    private SelectionListener onAddLink() {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ContainerLinkDialog dialog = new ContainerLinkDialog(ImageRunSelectionPage.this.getShell(), ImageRunSelectionPage.this.model.getSelectedConnection());
                dialog.create();
                if (dialog.open() == 0) {
                    ImageRunSelectionPage.this.model.addLink(dialog.getContainerName(), dialog.getContainerAlias());
                }
            }
        };
    }

    private SelectionListener onEditLink(final TableViewer linksTableViewer) {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IStructuredSelection selection = linksTableViewer.getStructuredSelection();
                ImageRunSelectionModel.ContainerLinkModel selectedContainerLink = (ImageRunSelectionModel.ContainerLinkModel)selection.getFirstElement();
                ContainerLinkDialog dialog = new ContainerLinkDialog(ImageRunSelectionPage.this.getShell(), ImageRunSelectionPage.this.model.getSelectedConnection(), selectedContainerLink);
                dialog.create();
                if (dialog.open() == 0) {
                    selectedContainerLink.setContainerName(dialog.getContainerName());
                    selectedContainerLink.setContainerAlias(dialog.getContainerAlias());
                    linksTableViewer.refresh();
                }
            }
        };
    }

    private SelectionListener onRemoveLinks(final TableViewer linksTableViewer) {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IStructuredSelection selection = linksTableViewer.getStructuredSelection();
                Iterator iterator = selection.iterator();
                while (iterator.hasNext()) {
                    ImageRunSelectionPage.this.model.removeLink((ImageRunSelectionModel.ContainerLinkModel)iterator.next());
                }
            }
        };
    }

    private void createRunOptionsSection(Composite container) {
        Button interactiveButton = new Button(container, 32);
        interactiveButton.setText(WizardMessages.getString("ImageRunSelectionPage.openStdin"));
        GridDataFactory.fillDefaults().align(4, 0x1000000).span(3, 1).grab(true, false).applyTo((Control)interactiveButton);
        this.dbc.bindValue((IObservableValue)WidgetProperties.selection().observe((Widget)interactiveButton), BeanProperties.value(ImageRunSelectionModel.class, (String)"interactiveMode").observe((Object)this.model));
        Button allocatePseudoTTY = new Button(container, 32);
        allocatePseudoTTY.setText(WizardMessages.getString("ImageRunSelectionPage.tty"));
        GridDataFactory.fillDefaults().align(4, 0x1000000).span(3, 1).grab(true, false).applyTo((Control)allocatePseudoTTY);
        this.dbc.bindValue((IObservableValue)WidgetProperties.selection().observe((Widget)allocatePseudoTTY), BeanProperties.value(ImageRunSelectionModel.class, (String)"allocatePseudoTTY").observe((Object)this.model));
        Button removeWhenExitsButton = new Button(container, 32);
        removeWhenExitsButton.setText(WizardMessages.getString("ImageRunSelectionPage.autoRemove"));
        GridDataFactory.fillDefaults().align(4, 0x1000000).span(3, 1).grab(true, false).applyTo((Control)removeWhenExitsButton);
        this.dbc.bindValue((IObservableValue)WidgetProperties.selection().observe((Widget)removeWhenExitsButton), BeanProperties.value(ImageRunSelectionModel.class, (String)"removeWhenExits").observe((Object)this.model));
    }

    private IContentProposalProvider getImageNameContentProposalProvider(final Combo imageSelectionCombo) {
        return new IContentProposalProvider(){

            public IContentProposal[] getProposals(String contents, int position) {
                ArrayList<ContentProposal> proposals = new ArrayList<ContentProposal>();
                String[] stringArray = imageSelectionCombo.getItems();
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String imageName = stringArray[n2];
                    if (imageName.contains(contents)) {
                        proposals.add(new ContentProposal(imageName, imageName, imageName, position));
                    }
                    ++n2;
                }
                return proposals.toArray(new IContentProposal[0]);
            }
        };
    }

    private IValueChangeListener onImageSelectionChange() {
        return new IValueChangeListener(){

            public void handleValueChange(ValueChangeEvent event) {
                IDockerImage selectedImage = ImageRunSelectionPage.this.model.getSelectedImage();
                if (selectedImage == null) {
                    ImageRunSelectionPage.this.model.setExposedPorts(Collections.emptyList());
                    return;
                }
                IDockerImageInfo selectedImageInfo = ImageRunSelectionPage.this.getImageInfo(selectedImage);
                ImageRunSelectionPage.this.applyImageInfo(selectedImageInfo);
            }
        };
    }

    private SelectionListener onPullImage() {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ImageRunSelectionPage.this.pullSelectedImage();
            }
        };
    }

    private IValueChangeListener onPublishAllPortsChange(final Control ... controls) {
        return new IValueChangeListener(){

            public void handleValueChange(ValueChangeEvent event) {
                ImageRunSelectionPage.this.togglePortMappingControls(controls);
            }
        };
    }

    private SelectionListener onSearchImage() {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ImageSearch imageSearchWizard = new ImageSearch(ImageRunSelectionPage.this.model.getSelectedConnection(), ImageRunSelectionPage.this.model.getSelectedImageName());
                boolean completed = CommandUtils.openWizard((IWizard)imageSearchWizard, ImageRunSelectionPage.this.getShell());
                if (completed) {
                    ImageRunSelectionPage.this.model.setSelectedImageName(imageSearchWizard.getSelectedImage());
                }
            }
        };
    }

    private SelectionListener onAddPort(final CheckboxTableViewer exposedPortsTableViewer) {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ContainerPortDialog dialog = new ContainerPortDialog(ImageRunSelectionPage.this.getShell());
                dialog.create();
                if (dialog.open() == 0) {
                    ImageRunSelectionModel.ExposedPortModel port = dialog.getPort();
                    port.setSelected(true);
                    ImageRunSelectionPage.this.model.addAvailablePort(port);
                    ImageRunSelectionPage.this.model.getSelectedPorts().add(port);
                    exposedPortsTableViewer.setChecked((Object)port, true);
                }
            }
        };
    }

    private SelectionListener onEditPort(final CheckboxTableViewer exposedPortsTableViewer) {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IStructuredSelection selection = exposedPortsTableViewer.getStructuredSelection();
                ImageRunSelectionModel.ExposedPortModel selectedContainerPort = (ImageRunSelectionModel.ExposedPortModel)selection.getFirstElement();
                ContainerPortDialog dialog = new ContainerPortDialog(ImageRunSelectionPage.this.getShell(), selectedContainerPort);
                dialog.create();
                if (dialog.open() == 0) {
                    ImageRunSelectionModel.ExposedPortModel configuredPort = dialog.getPort();
                    selectedContainerPort.setContainerPort(configuredPort.getContainerPort());
                    selectedContainerPort.setHostAddress(configuredPort.getHostAddress());
                    selectedContainerPort.setHostPort(configuredPort.getHostPort());
                    exposedPortsTableViewer.refresh();
                }
            }
        };
    }

    private SelectionListener onRemovePorts(final TableViewer portsTableViewer) {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IStructuredSelection selection = portsTableViewer.getStructuredSelection();
                for (ImageRunSelectionModel.ExposedPortModel port : selection) {
                    ImageRunSelectionPage.this.model.removeAvailablePort(port);
                    ImageRunSelectionPage.this.model.getSelectedPorts().remove(port);
                }
            }
        };
    }

    private void setDefaultValues() {
        IDockerImage selectedImage = this.model.getSelectedImage();
        if (selectedImage == null) {
            return;
        }
        IDockerImageInfo selectedImageInfo = this.getImageInfo(selectedImage);
        if (this.lastLaunchConfiguration != null) {
            try {
                this.model.setContainerName(this.lastLaunchConfiguration.getAttribute("containerName", ""));
                this.model.setCommand(this.lastLaunchConfiguration.getAttribute("command", ""));
                this.model.setEntrypoint(this.lastLaunchConfiguration.getAttribute("entryPoint", ""));
                this.model.setPublishAllPorts(this.lastLaunchConfiguration.getAttribute("publishAllPorts", false));
                List exposedPortInfos = this.lastLaunchConfiguration.getAttribute("publishedPorts", Collections.emptyList());
                List<ImageRunSelectionModel.ExposedPortModel> exposedPorts = ImageRunSelectionModel.ExposedPortModel.fromStrings(selectedImageInfo.config().exposedPorts());
                this.model.setExposedPorts(exposedPorts);
                List<ImageRunSelectionModel.ExposedPortModel> selectedExposedPorts = ImageRunSelectionModel.ExposedPortModel.fromStrings(exposedPortInfos);
                this.model.setSelectedPorts(new HashSet<ImageRunSelectionModel.ExposedPortModel>(selectedExposedPorts));
                this.model.setLinks(this.lastLaunchConfiguration.getAttribute("links", Collections.emptyList()));
                this.model.setRemoveWhenExits(this.lastLaunchConfiguration.getAttribute("autoRemove", false));
                this.model.setInteractiveMode(this.lastLaunchConfiguration.getAttribute("interactive", false));
                this.model.setAllocatePseudoTTY(this.lastLaunchConfiguration.getAttribute("allocatePseudoTTY", false));
            }
            catch (CoreException e) {
                Activator.log(e);
            }
        } else {
            this.applyImageInfo(selectedImageInfo);
        }
    }

    private IDockerImageInfo getImageInfo(IDockerImage selectedImage) {
        try {
            FindImageInfoRunnable findImageInfoRunnable = new FindImageInfoRunnable(selectedImage);
            this.getContainer().run(true, true, (IRunnableWithProgress)findImageInfoRunnable);
            IDockerImageInfo selectedImageInfo = findImageInfoRunnable.getResult();
            return selectedImageInfo;
        }
        catch (InterruptedException | InvocationTargetException e) {
            Activator.log(e);
            return null;
        }
    }

    private void applyImageInfo(IDockerImageInfo selectedImageInfo) {
        if (selectedImageInfo != null && selectedImageInfo.config() != null) {
            List<ImageRunSelectionModel.ExposedPortModel> exposedPorts = ImageRunSelectionModel.ExposedPortModel.fromStrings(selectedImageInfo.config().exposedPorts());
            this.model.setExposedPorts(exposedPorts);
            this.model.setCommand(selectedImageInfo.config().cmd());
            this.model.setEntrypoint(selectedImageInfo.config().entrypoint());
        }
    }

    private void togglePortMappingControls(Control ... controls) {
        Control[] controlArray = controls;
        int n = controls.length;
        int n2 = 0;
        while (n2 < n) {
            Control control = controlArray[n2];
            if (this.model.isPublishAllPorts()) {
                control.setEnabled(false);
            } else {
                control.setEnabled(true);
            }
            ++n2;
        }
    }

    private void pullSelectedImage() {
        try {
            this.getContainer().run(true, true, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InterruptedException {
                    IDockerConnection connection = ImageRunSelectionPage.this.model.getSelectedConnection();
                    final String imageName = ImageRunSelectionPage.this.model.getSelectedImageName();
                    monitor.beginTask(WizardMessages.getFormattedString("ImageRunSelectionPage.pullingTask", imageName), 1);
                    try {
                        try {
                            connection.pullImage(imageName, (IDockerProgressHandler)new ImagePullProgressHandler(connection, imageName));
                        }
                        catch (DockerException e) {
                            Display.getDefault().syncExec(new Runnable(){

                                @Override
                                public void run() {
                                    MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)DVMessages.getFormattedString(ImageRunSelectionPage.ERROR_PULLING_IMAGE, imageName), (String)e.getMessage());
                                }
                            });
                            monitor.done();
                            ImageRunSelectionPage.this.model.refreshImageNames();
                            if (ImageRunSelectionPage.this.model.getImageNames().contains(imageName)) {
                                ImageRunSelectionPage.this.model.setSelectedImageName(imageName);
                            }
                        }
                    }
                    finally {
                        monitor.done();
                        ImageRunSelectionPage.this.model.refreshImageNames();
                        if (ImageRunSelectionPage.this.model.getImageNames().contains(imageName)) {
                            ImageRunSelectionPage.this.model.setSelectedImageName(imageName);
                        }
                    }
                }
            });
        }
        catch (InterruptedException | InvocationTargetException e) {
            Activator.log(e);
        }
    }

    private static void setControlsEnabled(Control[] controls, boolean enabled) {
        Control[] controlArray = controls;
        int n = controls.length;
        int n2 = 0;
        while (n2 < n) {
            Control control = controlArray[n2];
            control.setEnabled(enabled);
            ++n2;
        }
    }

    private class ContainerNameValidator
    extends MultiValidator {
        private final IDockerConnection connection;
        private final IObservableValue containerNameObservable;

        ContainerNameValidator(IDockerConnection connection, IObservableValue containerNameObservable) {
            this.connection = connection;
            this.containerNameObservable = containerNameObservable;
        }

        protected IStatus validate() {
            String containerName = (String)this.containerNameObservable.getValue();
            for (IDockerContainer container : this.connection.getContainers()) {
                if (!container.name().equals(containerName)) continue;
                return ValidationStatus.error((String)WizardMessages.getString("ImageRunSelectionPage.containerWithSameName"));
            }
            return ValidationStatus.ok();
        }

        public IObservableList getTargets() {
            WritableList targets = new WritableList();
            targets.add((Object)this.containerNameObservable);
            return targets;
        }
    }

    private class ImageSelectionValidator
    extends MultiValidator {
        private final IObservableValue imageSelectionObservable;

        ImageSelectionValidator(IObservableValue imageSelectionObservable) {
            this.imageSelectionObservable = imageSelectionObservable;
        }

        protected IStatus validate() {
            String selectedImageName = (String)this.imageSelectionObservable.getValue();
            if (selectedImageName.isEmpty()) {
                ImageRunSelectionPage.this.model.setSelectedImageNeedsPulling(false);
                return ValidationStatus.error((String)WizardMessages.getString("ImageRunSelectionPage.specifyImageMsg"));
            }
            if (ImageRunSelectionPage.this.model.getSelectedImage() != null) {
                ImageRunSelectionPage.this.model.setSelectedImageNeedsPulling(false);
                return ValidationStatus.ok();
            }
            ImageRunSelectionPage.this.model.setSelectedImageNeedsPulling(true);
            return ValidationStatus.warning((String)WizardMessages.getFormattedString("ImageRunSelectionPage.imageNotFoundMessage", selectedImageName));
        }

        public IObservableList getTargets() {
            WritableList targets = new WritableList();
            targets.add((Object)this.imageSelectionObservable);
            return targets;
        }
    }
}

