/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.docker.ui.views;

import java.text.DecimalFormat;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.viewers.BaseLabelProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.linuxtools.docker.core.IDockerConnection;
import org.eclipse.linuxtools.docker.core.IDockerImage;
import org.eclipse.swt.graphics.Image;

public class ImageViewLabelAndContentProvider
extends BaseLabelProvider
implements IStructuredContentProvider,
ITableLabelProvider {
    private IDockerConnection connection;
    private List<IDockerImage> images;

    public void setTableViewer(TableViewer viewer) {
    }

    public Object[] getElements(Object inputElement) {
        return this.images.toArray(new IDockerImage[0]);
    }

    public void dispose() {
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        if (newInput != null) {
            if (newInput instanceof IDockerImage[]) {
                this.images = Arrays.asList((IDockerImage[])newInput);
            } else {
                this.connection = (IDockerConnection)newInput;
                this.images = this.connection.getImages();
            }
        }
    }

    public Image getColumnImage(Object element, int columnIndex) {
        return null;
    }

    public Object getColumnCompareObject(Object element, int columnIndex) {
        Column c = Column.getColumn(columnIndex);
        IDockerImage i = (IDockerImage)element;
        switch (c) {
            case CREATED: {
                Long l = Long.valueOf(Long.MAX_VALUE) - Long.valueOf(i.created());
                return l;
            }
            case SIZE: {
                return i.size();
            }
            case VIRTSIZE: {
                return i.virtualSize();
            }
            case ID: {
                return i.id();
            }
            case PARENT: {
                return i.parentId();
            }
            case TAGS: {
                return i.repoTags().get(0);
            }
        }
        return "";
    }

    public String getColumnText(Object element, int columnIndex) {
        Column c = Column.getColumn(columnIndex);
        IDockerImage i = (IDockerImage)element;
        switch (c) {
            case CREATED: {
                return i.createdDate();
            }
            case ID: {
                return i.id();
            }
            case PARENT: {
                return i.parentId();
            }
            case SIZE: {
                return this.displaySize(i.size());
            }
            case VIRTSIZE: {
                return this.displaySize(i.virtualSize());
            }
            case TAGS: {
                StringBuilder tags = new StringBuilder();
                Iterator iterator = i.tags().iterator();
                while (iterator.hasNext()) {
                    tags.append((String)iterator.next());
                    if (!iterator.hasNext()) continue;
                    tags.append(", ");
                }
                return tags.toString();
            }
        }
        return "";
    }

    private String displaySize(Long size) {
        if (size <= 0L) {
            return "0";
        }
        String[] units = new String[]{"B", "kB", "MB", "GB", "TB"};
        int digitGroups = (int)(Math.log10(size.longValue()) / Math.log10(1000.0));
        return String.valueOf(new DecimalFormat("#,##0.#").format((double)size.longValue() / Math.pow(1000.0, digitGroups))) + " " + units[digitGroups];
    }

    public static enum Column {
        ID(0, 20),
        TAGS(1, 20),
        PARENT(2, 20),
        CREATED(3, 20),
        SIZE(4, 10),
        VIRTSIZE(5, 10);

        private int column;
        private int weight;
        private static final Map<Integer, Column> lookup;

        static {
            lookup = new HashMap<Integer, Column>();
            for (Column c : EnumSet.allOf(Column.class)) {
                lookup.put(c.getColumnNumber(), c);
            }
        }

        private Column(int column, int weight) {
            this.column = column;
            this.weight = weight;
        }

        public int getColumnNumber() {
            return this.column;
        }

        public int getWeight() {
            return this.weight;
        }

        public static Column getColumn(int number) {
            return lookup.get(number);
        }

        public static int getSize() {
            return lookup.size();
        }
    }
}

