/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.docker.ui.views;

import java.util.List;
import java.util.Map;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.linuxtools.docker.core.IDockerContainerConfig;
import org.eclipse.linuxtools.docker.core.IDockerContainerInfo;
import org.eclipse.linuxtools.docker.core.IDockerContainerState;
import org.eclipse.linuxtools.docker.core.IDockerHostConfig;
import org.eclipse.linuxtools.docker.core.IDockerNetworkSettings;
import org.eclipse.linuxtools.docker.core.IDockerPortBinding;
import org.eclipse.linuxtools.internal.docker.ui.views.LabelUtils;

public class ContainerInspectContentProvider
implements ITreeContentProvider {
    private static final Object[] EMPTY = new Object[0];

    public void dispose() {
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }

    public Object[] getElements(Object inputElement) {
        if (inputElement instanceof IDockerContainerInfo) {
            IDockerContainerInfo info = (IDockerContainerInfo)inputElement;
            return new Object[]{new Object[]{"Id", info.id().substring(0, 12)}, new Object[]{"Name", info.name()}, new Object[]{"Created", LabelUtils.toCreatedDate(info.created())}, new Object[]{"State", info.state()}, new Object[]{"Args", LabelUtils.reduce(info.args())}, new Object[]{"Driver", info.driver()}, new Object[]{"ExecDriver", info.execDriver()}, new Object[]{"Config", info.config()}, new Object[]{"HostConfig", info.hostConfig()}, new Object[]{"HostnamePath", info.hostnamePath()}, new Object[]{"HostsPath", info.hostsPath()}, new Object[]{"Image", info.image()}, new Object[]{"MountLabel", info.mountLabel()}, new Object[]{"NetworkSettings", info.networkSettings()}, new Object[]{"Path", info.path()}, new Object[]{"ProcessLabel", info.processLabel()}, new Object[]{"ResolvConfPath", info.resolvConfPath()}, new Object[]{"Volumes", info.volumes()}, new Object[]{"VolumesRW", info.volumesRW()}};
        }
        return EMPTY;
    }

    public Object[] getChildren(Object parentElement) {
        Object propertyValue = ((Object[])parentElement)[1];
        if (propertyValue instanceof IDockerContainerState) {
            IDockerContainerState containerState = (IDockerContainerState)propertyValue;
            return new Object[]{new Object[]{"ExitCode", containerState.exitCode()}, new Object[]{"Finished at", LabelUtils.toFinishedDate(containerState.finishDate())}, new Object[]{"Running", containerState.running()}, new Object[]{"Paused", containerState.paused()}, new Object[]{"Pid", containerState.pid()}};
        }
        if (propertyValue instanceof IDockerHostConfig) {
            IDockerHostConfig hostConfig = (IDockerHostConfig)propertyValue;
            return new Object[]{new Object[]{"Binds", LabelUtils.reduce(hostConfig.binds())}, new Object[]{"ContainerIDFile", hostConfig.containerIDFile()}, new Object[]{"Dns", LabelUtils.reduce(hostConfig.dns())}, new Object[]{"DnsSearch", LabelUtils.reduce(hostConfig.dnsSearch())}, new Object[]{"Links", this.splitLinks(hostConfig.links())}, new Object[]{"LxcConf", hostConfig.lxcConf()}, new Object[]{"NetworkMode", hostConfig.networkMode()}, new Object[]{"PortBindings", LabelUtils.reduce(hostConfig.portBindings())}, new Object[]{"Privileged", hostConfig.privileged()}, new Object[]{"PublishAllPorts", hostConfig.publishAllPorts()}, new Object[]{"VolumesFrom", LabelUtils.reduce(hostConfig.volumesFrom())}};
        }
        if (propertyValue instanceof IDockerContainerConfig) {
            IDockerContainerConfig config = (IDockerContainerConfig)propertyValue;
            return new Object[]{new Object[]{"AttachStderr", config.attachStderr()}, new Object[]{"AttachStdin", config.attachStdin()}, new Object[]{"AttachStdout", config.attachStdout()}, new Object[]{"Cmd", LabelUtils.reduce(config.cmd())}, new Object[]{"CpuSet", config.cpuset()}, new Object[]{"CpuShares", config.cpuShares()}, new Object[]{"Domainname", config.domainname()}, new Object[]{"Entrypoint", LabelUtils.reduce(config.entrypoint())}, new Object[]{"Env", LabelUtils.reduce(config.env())}, new Object[]{"ExposedPorts", LabelUtils.reduce(config.exposedPorts())}, new Object[]{"Hostname", config.hostname()}, new Object[]{"Image", config.image()}, new Object[]{"Memory", config.memory()}, new Object[]{"MemorySwap", config.memorySwap()}, new Object[]{"NetworkDisabled", config.networkDisabled()}, new Object[]{"OnBuild", config.onBuild()}, new Object[]{"OpenStdin", config.openStdin()}, new Object[]{"PortSpecs", LabelUtils.reduce(config.portSpecs())}, new Object[]{"StdinOnce", config.stdinOnce()}, new Object[]{"Tty", config.tty()}, new Object[]{"Volumes", config.volumes()}, new Object[]{"WorkingDir", config.workingDir()}};
        }
        if (propertyValue instanceof IDockerPortBinding) {
            IDockerPortBinding portBinding = (IDockerPortBinding)propertyValue;
            return new Object[]{new Object[]{"Host IP/Port", LabelUtils.toString(portBinding)}};
        }
        if (propertyValue instanceof IDockerNetworkSettings) {
            IDockerNetworkSettings networkSettings = (IDockerNetworkSettings)propertyValue;
            return new Object[]{new Object[]{"Bridge", networkSettings.bridge()}, new Object[]{"Gateway", networkSettings.gateway()}, new Object[]{"IPAddress", networkSettings.ipAddress()}, new Object[]{"IPPrefixLen", networkSettings.ipPrefixLen()}, new Object[]{"PortMapping", networkSettings.portMapping()}, new Object[]{"Ports", LabelUtils.reduce(networkSettings.ports())}};
        }
        if (propertyValue instanceof List) {
            List propertyValues = (List)propertyValue;
            Object[] result = new Object[propertyValues.size()];
            int i = 0;
            while (i < propertyValues.size()) {
                result[i] = new Object[]{"", LabelUtils.toString(propertyValues.get(i))};
                ++i;
            }
            return result;
        }
        if (propertyValue instanceof Map) {
            Map propertyValues = (Map)propertyValue;
            Object[] result = new Object[propertyValues.size()];
            int i = 0;
            for (Map.Entry entry : propertyValues.entrySet()) {
                result[i] = new Object[]{entry.getKey(), entry.getValue()};
                ++i;
            }
            return result;
        }
        return EMPTY;
    }

    private Object splitLinks(List<String> links) {
        if (links == null || links.isEmpty()) {
            return "";
        }
        if (links.size() == 1) {
            return links.get(0);
        }
        Object[] result = new Object[links.size()];
        int i = 0;
        while (i < links.size()) {
            String[] split = links.get(i).split(":");
            result[i] = new Object[]{split[0], split[1]};
            ++i;
        }
        return links;
    }

    public Object getParent(Object element) {
        return null;
    }

    public boolean hasChildren(Object element) {
        if (element instanceof Object[]) {
            Object value = ((Object[])element)[1];
            return value instanceof List || value instanceof Map || value instanceof IDockerContainerState || value instanceof IDockerNetworkSettings || value instanceof IDockerHostConfig || value instanceof IDockerPortBinding || value instanceof IDockerContainerConfig;
        }
        return false;
    }
}

