/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.docker.ui.views;

import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.linuxtools.docker.core.DockerException;
import org.eclipse.linuxtools.docker.core.IDockerConnection;
import org.eclipse.linuxtools.docker.core.IDockerConnectionInfo;
import org.eclipse.linuxtools.docker.ui.Activator;
import org.eclipse.linuxtools.internal.docker.ui.views.BasePropertySection;
import org.eclipse.linuxtools.internal.docker.ui.views.ConnectionInfoContentProvider;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;

public class ConnectionInfoPropertySection
extends BasePropertySection {
    private IDockerConnection selectedConnection = null;
    private IDockerConnectionInfo connectionInfo;

    @Override
    public void createControls(Composite parent, TabbedPropertySheetPage propertySheetPage) {
        super.createControls(parent, propertySheetPage);
        this.getTreeViewer().setContentProvider((IContentProvider)new ConnectionInfoContentProvider());
    }

    public void setInput(IWorkbenchPart part, ISelection selection) {
        super.setInput(part, selection);
        Assert.isTrue((boolean)(selection instanceof ITreeSelection));
        Object input = ((ITreeSelection)selection).getFirstElement();
        Assert.isTrue((boolean)(input instanceof IDockerConnection));
        this.selectedConnection = (IDockerConnection)input;
        this.connectionInfo = this.getConnectionInfo(this.selectedConnection);
        if (this.getTreeViewer() != null) {
            this.getTreeViewer().setInput((Object)this.connectionInfo);
            this.getTreeViewer().expandAll();
        }
    }

    private IDockerConnectionInfo getConnectionInfo(final IDockerConnection connection) {
        final ArrayBlockingQueue result = new ArrayBlockingQueue(1);
        Job loadConnectionInfoJob = new Job("Loading connection info..."){

            protected IStatus run(IProgressMonitor monitor) {
                monitor.beginTask("Loading connection info...", 1);
                try {
                    result.add(connection.getInfo());
                }
                catch (DockerException e) {
                    Activator.log(e);
                }
                monitor.done();
                return Status.OK_STATUS;
            }
        };
        loadConnectionInfoJob.schedule();
        try {
            return (IDockerConnectionInfo)result.poll(2L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            Activator.log((IStatus)new Status(4, "org.eclipse.linuxtools.docker.ui", "Failed to retrieve general info on connection '" + connection.getName() + "'", (Throwable)e));
            return null;
        }
    }
}

