/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.docker.ui.launch;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.IDebugModelPresentation;
import org.eclipse.debug.ui.ILaunchShortcut;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.linuxtools.docker.core.DockerConnectionManager;
import org.eclipse.linuxtools.docker.core.IDockerConnection;
import org.eclipse.linuxtools.docker.ui.Activator;
import org.eclipse.linuxtools.internal.docker.ui.SWTImagesFactory;
import org.eclipse.linuxtools.internal.docker.ui.launch.BuildDockerImageUtils;
import org.eclipse.linuxtools.internal.docker.ui.launch.LaunchConfigurationUtils;
import org.eclipse.linuxtools.internal.docker.ui.launch.LaunchMessages;
import org.eclipse.linuxtools.internal.docker.ui.wizards.ImageBuildDialog;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;

public class BuildDockerImageShortcut
implements ILaunchShortcut {
    private static final String LaunchShortcut_Error_Launching = "ImageBuildShortcut.error.msg";
    private static final String LaunchShortcut_No_Connections = "NoConnection.error.msg";
    private static final String LaunchShortcut_Config_Selection = "ImageBuildShortcutConfigSelection.title";
    private static final String LaunchShortcut_Choose_Launch = "ImageBuildShortcutChooseLaunch.msg";
    private static final String LaunchShortcut_Connection_Selection = "ImageBuildShortcutConnectionSelection.title";
    private static final String LaunchShortcut_Choose_Connection = "ImageBuildShortcutChooseConnection.msg";

    public void launch(ISelection selection, String mode) {
        if (selection instanceof IStructuredSelection) {
            IResource resource = (IResource)((IStructuredSelection)selection).toArray()[0];
            this.launch(resource, mode);
        }
    }

    public void launch(IEditorPart editor, String mode) {
        this.launch((IResource)editor.getEditorInput().getAdapter(IResource.class), mode);
    }

    public void launch(IResource resource, String mode) {
        ILaunchConfiguration config = this.findLaunchConfiguration(resource);
        if (config != null) {
            DebugUITools.launch((ILaunchConfiguration)config, (String)mode);
        }
    }

    protected ILaunchConfiguration findLaunchConfiguration(IResource resource) {
        ILaunchConfiguration configuration = null;
        ILaunchConfigurationType configType = LaunchConfigurationUtils.getLaunchConfigType("org.eclipse.linuxtools.docker.ui.buildDockerImageLaunchConfigurationType");
        List<ILaunchConfiguration> candidateConfigs = Collections.emptyList();
        try {
            ILaunchConfiguration[] configs = DebugPlugin.getDefault().getLaunchManager().getLaunchConfigurations(configType);
            candidateConfigs = new ArrayList(configs.length);
            ILaunchConfiguration[] iLaunchConfigurationArray = configs;
            int n = configs.length;
            int n2 = 0;
            while (n2 < n) {
                boolean workspaceRelative;
                ILaunchConfiguration config = iLaunchConfigurationArray[n2];
                String sourcePath = config.getAttribute("sourcePathLocation", "");
                IPath dockerfilePath = this.getPath(sourcePath, workspaceRelative = config.getAttribute("sourcePathWorkspaceRelativeLocation", false));
                if (dockerfilePath.equals((Object)resource.getLocation().removeLastSegments(1))) {
                    candidateConfigs.add(config);
                }
                ++n2;
            }
        }
        catch (CoreException e) {
            Activator.log(e);
        }
        int candidateCount = candidateConfigs.size();
        configuration = candidateCount < 1 ? this.createConfiguration(resource) : (candidateCount == 1 ? (ILaunchConfiguration)candidateConfigs.get(0) : this.chooseConfiguration(candidateConfigs));
        return configuration;
    }

    private IPath getPath(String sourcePathLocation, boolean sourcePathWorkspaceRelativeLocation) {
        if (sourcePathWorkspaceRelativeLocation) {
            return ResourcesPlugin.getWorkspace().getRoot().findMember((IPath)new Path(sourcePathLocation)).getLocation();
        }
        return new Path(sourcePathLocation);
    }

    protected ILaunchConfiguration createConfiguration(IResource resource) {
        block4: {
            IDockerConnection[] connections = DockerConnectionManager.getInstance().getConnections();
            if (connections.length != 0) break block4;
            Display.getDefault().syncExec(new Runnable(){

                @Override
                public void run() {
                    MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)LaunchMessages.getString(BuildDockerImageShortcut.LaunchShortcut_Error_Launching), (String)LaunchMessages.getString(BuildDockerImageShortcut.LaunchShortcut_No_Connections));
                }
            });
            return null;
        }
        try {
            ImageBuildDialog dialog = new ImageBuildDialog(this.getActiveWorkbenchShell());
            int result = dialog.open();
            if (result == 0) {
                ILaunchConfigurationType configType = LaunchConfigurationUtils.getLaunchConfigType("org.eclipse.linuxtools.docker.ui.buildDockerImageLaunchConfigurationType");
                ILaunchConfigurationWorkingCopy wc = configType.newInstance(null, DebugPlugin.getDefault().getLaunchManager().generateLaunchConfigurationName(BuildDockerImageShortcut.createLaunchConfigurationName(dialog.getRepoName(), resource)));
                wc.setAttribute("sourcePathLocation", resource.getFullPath().removeLastSegments(1).toString());
                wc.setAttribute("sourcePathWorkspaceRelativeLocation", true);
                IDockerConnection connection = dialog.getConnection();
                String repoName = dialog.getRepoName();
                wc.setAttribute("dockerConnection", connection.getName());
                wc.setAttribute("repoName", repoName);
                return wc.doSave();
            }
        }
        catch (CoreException e) {
            Activator.log(e);
        }
        return null;
    }

    public static String createLaunchConfigurationName(String imageName, IResource resource) {
        if (imageName != null) {
            String repository = BuildDockerImageUtils.getRepository(imageName);
            String name = BuildDockerImageUtils.getName(imageName);
            String tag = BuildDockerImageUtils.getTag(imageName);
            StringBuilder configNameBuilder = new StringBuilder();
            if (name != null) {
                if (repository != null) {
                    configNameBuilder.append(repository).append('_');
                }
                if (name != null) {
                    configNameBuilder.append(name);
                }
                if (tag != null) {
                    configNameBuilder.append(" [").append(tag).append("]");
                } else {
                    configNameBuilder.append(" [latest]");
                }
                return configNameBuilder.toString();
            }
        }
        return "Dockerfile [" + resource.getProject().getName() + "]";
    }

    protected IDockerConnection chooseConnection(IDockerConnection[] connections) {
        IDebugModelPresentation labelProvider = DebugUITools.newDebugModelPresentation();
        ElementListSelectionDialog dialog = new ElementListSelectionDialog(this.getActiveWorkbenchShell(), (ILabelProvider)new ConnectionSelectionLabelProvider(this){});
        dialog.setElements((Object[])connections);
        dialog.setTitle(LaunchMessages.getString(LaunchShortcut_Connection_Selection));
        dialog.setMessage(LaunchMessages.getString(LaunchShortcut_Choose_Connection));
        dialog.setMultipleSelection(false);
        int result = dialog.open();
        labelProvider.dispose();
        if (result == 0) {
            return (IDockerConnection)dialog.getFirstResult();
        }
        return null;
    }

    protected ILaunchConfiguration chooseConfiguration(List<ILaunchConfiguration> configList) {
        IDebugModelPresentation labelProvider = DebugUITools.newDebugModelPresentation();
        ElementListSelectionDialog dialog = new ElementListSelectionDialog(this.getActiveWorkbenchShell(), (ILabelProvider)labelProvider);
        dialog.setElements(configList.toArray());
        dialog.setTitle(LaunchMessages.getString(LaunchShortcut_Config_Selection));
        dialog.setMessage(LaunchMessages.getString(LaunchShortcut_Choose_Launch));
        dialog.setMultipleSelection(false);
        int result = dialog.open();
        labelProvider.dispose();
        if (result == 0) {
            return (ILaunchConfiguration)dialog.getFirstResult();
        }
        return null;
    }

    protected Shell getActiveWorkbenchShell() {
        return Activator.getActiveWorkbenchShell();
    }

    private class ConnectionSelectionLabelProvider
    implements ILabelProvider {
        private ConnectionSelectionLabelProvider() {
        }

        public void removeListener(ILabelProviderListener listener) {
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void dispose() {
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public String getText(Object element) {
            return element.toString();
        }

        public Image getImage(Object element) {
            return SWTImagesFactory.DESC_REPOSITORY_MIDDLE.createImage();
        }
    }
}

