/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.docker.ui.commands;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.linuxtools.docker.core.IDockerConnection;
import org.eclipse.linuxtools.docker.core.IDockerContainer;
import org.eclipse.linuxtools.docker.core.IDockerImage;
import org.eclipse.linuxtools.docker.core.IDockerPortMapping;
import org.eclipse.linuxtools.docker.ui.Activator;
import org.eclipse.linuxtools.internal.docker.ui.RunConsole;
import org.eclipse.linuxtools.internal.docker.ui.views.DockerContainersView;
import org.eclipse.linuxtools.internal.docker.ui.views.DockerExplorerContentProvider;
import org.eclipse.linuxtools.internal.docker.ui.views.DockerExplorerView;
import org.eclipse.linuxtools.internal.docker.ui.views.DockerImagesView;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPart;

public class CommandUtils {
    public static void asyncRefresh(final Viewer viewer) {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (viewer != null && !viewer.getControl().isDisposed()) {
                    viewer.refresh();
                }
            }
        });
    }

    public static IDockerConnection getCurrentConnection(IWorkbenchPart activePart) {
        if (activePart instanceof DockerContainersView) {
            return ((DockerContainersView)activePart).getConnection();
        }
        if (activePart instanceof DockerImagesView) {
            return ((DockerImagesView)activePart).getConnection();
        }
        if (activePart instanceof DockerExplorerView) {
            ITreeSelection selection = ((DockerExplorerView)activePart).getCommonViewer().getStructuredSelection();
            Object firstElement = selection.getFirstElement();
            if (firstElement instanceof IDockerConnection) {
                return (IDockerConnection)firstElement;
            }
            if (firstElement instanceof IDockerContainer) {
                return ((IDockerContainer)firstElement).getConnection();
            }
            if (firstElement instanceof IDockerImage) {
                return ((IDockerImage)firstElement).getConnection();
            }
            if (firstElement instanceof DockerExplorerContentProvider.DockerContainersCategory) {
                return ((DockerExplorerContentProvider.DockerContainersCategory)firstElement).getConnection();
            }
            if (firstElement instanceof DockerExplorerContentProvider.DockerContainersCategory) {
                return ((DockerExplorerContentProvider.DockerContainersCategory)firstElement).getConnection();
            }
            if (firstElement instanceof DockerExplorerContentProvider.DockerContainerLinksCategory) {
                return ((DockerExplorerContentProvider.DockerContainerLinksCategory)firstElement).getContainer().getConnection();
            }
            if (firstElement instanceof DockerExplorerContentProvider.DockerContainerLink) {
                return ((DockerExplorerContentProvider.DockerContainerLink)firstElement).getContainer().getConnection();
            }
            if (firstElement instanceof DockerExplorerContentProvider.DockerContainerPortMappingsCategory) {
                return ((DockerExplorerContentProvider.DockerContainerPortMappingsCategory)firstElement).getContainer().getConnection();
            }
            if (firstElement instanceof IDockerPortMapping) {
                return ((IDockerPortMapping)firstElement).getContainer().getConnection();
            }
            if (firstElement instanceof DockerExplorerContentProvider.DockerContainerVolumesCategory) {
                return ((DockerExplorerContentProvider.DockerContainerVolumesCategory)firstElement).getContainer().getConnection();
            }
            if (firstElement instanceof DockerExplorerContentProvider.DockerContainerVolume) {
                return ((DockerExplorerContentProvider.DockerContainerVolume)firstElement).getContainer().getConnection();
            }
            if (firstElement instanceof DockerExplorerContentProvider.DockerImagesCategory) {
                return ((DockerExplorerContentProvider.DockerImagesCategory)firstElement).getConnection();
            }
        }
        return null;
    }

    public static List<IDockerContainer> getSelectedContainers(IWorkbenchPart activePart) {
        if (activePart instanceof DockerContainersView) {
            ISelection selection = ((DockerContainersView)activePart).getSelection();
            return CommandUtils.convertSelectionTo(selection, IDockerContainer.class);
        }
        if (activePart instanceof DockerExplorerView) {
            ISelection selection = ((DockerExplorerView)activePart).getCommonViewer().getSelection();
            return CommandUtils.convertSelectionTo(selection, IDockerContainer.class);
        }
        return Collections.emptyList();
    }

    public static List<IDockerPortMapping> getSelectedPortMappings(IWorkbenchPart activePart) {
        if (activePart instanceof DockerContainersView) {
            ISelection selection = ((DockerContainersView)activePart).getSelection();
            return CommandUtils.convertSelectionTo(selection, IDockerPortMapping.class);
        }
        if (activePart instanceof DockerExplorerView) {
            ISelection selection = ((DockerExplorerView)activePart).getCommonViewer().getSelection();
            return CommandUtils.convertSelectionTo(selection, IDockerPortMapping.class);
        }
        return Collections.emptyList();
    }

    public static List<DockerExplorerContentProvider.DockerContainerVolume> getSelectedVolumes(IWorkbenchPart activePart) {
        if (activePart instanceof DockerContainersView) {
            ISelection selection = ((DockerContainersView)activePart).getSelection();
            return CommandUtils.convertSelectionTo(selection, DockerExplorerContentProvider.DockerContainerVolume.class);
        }
        if (activePart instanceof DockerExplorerView) {
            ISelection selection = ((DockerExplorerView)activePart).getCommonViewer().getSelection();
            return CommandUtils.convertSelectionTo(selection, DockerExplorerContentProvider.DockerContainerVolume.class);
        }
        return Collections.emptyList();
    }

    public static List<IDockerImage> getSelectedImages(IWorkbenchPart activePart) {
        if (activePart instanceof DockerImagesView) {
            ISelection selection = ((DockerImagesView)activePart).getSelection();
            return CommandUtils.convertSelectionTo(selection, IDockerImage.class);
        }
        if (activePart instanceof DockerExplorerView) {
            ISelection selection = ((DockerExplorerView)activePart).getCommonViewer().getSelection();
            return CommandUtils.convertSelectionTo(selection, IDockerImage.class);
        }
        return Collections.emptyList();
    }

    private static <T> List<T> convertSelectionTo(ISelection selection, Class<T> targetClass) {
        if (selection instanceof IStructuredSelection) {
            ArrayList selectedContainers = new ArrayList();
            IStructuredSelection structuredSelection = (IStructuredSelection)selection;
            for (Object selectedElement : structuredSelection) {
                if (!targetClass.isAssignableFrom(selectedElement.getClass())) continue;
                selectedContainers.add(selectedElement);
            }
            return Collections.unmodifiableList(selectedContainers);
        }
        return Collections.emptyList();
    }

    public static RunConsole getRunConsole(IDockerConnection connection, IDockerContainer container) {
        RunConsole console;
        if (container != null && connection.getContainerInfo(container.id()) != null && connection.getContainerInfo(container.id()).config() != null && connection.getContainerInfo(container.id()).config().tty()) {
            RunConsole.attachToTerminal(connection, container.id());
            return null;
        }
        boolean autoLogOnStart = Activator.getDefault().getPreferenceStore().getBoolean("autoLogOnStart");
        if (autoLogOnStart && (console = RunConsole.findConsole(container)) != null) {
            console.attachToConsole(connection);
            console.clearConsole();
            return console;
        }
        return null;
    }

    public static boolean openWizard(IWizard wizard, Shell shell) {
        WizardDialog wizardDialog = new WizardDialog(shell, wizard);
        wizardDialog.create();
        return wizardDialog.open() == 0;
    }

    public static boolean openWizard(IWizard wizard, Shell shell, int width, int height) {
        WizardDialog wizardDialog = new WizardDialog(shell, wizard);
        wizardDialog.setPageSize(width, height);
        wizardDialog.create();
        return wizardDialog.open() == 0;
    }
}

