/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.cdk.server.ui.internal;

import java.io.File;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.IServerWorkingCopy;
import org.eclipse.wst.server.ui.wizard.IWizardHandle;
import org.eclipse.wst.server.ui.wizard.WizardFragment;
import org.jboss.tools.foundation.ui.credentials.ChooseCredentialComponent;
import org.jboss.tools.foundation.ui.credentials.ICredentialCompositeListener;
import org.jboss.tools.openshift.cdk.server.core.internal.CDKCoreActivator;

public class CDKServerWizardFragment
extends WizardFragment {
    private IWizardHandle handle;
    private String homeDir;
    private Text homeText;
    private Button browseButton;
    private ChooseCredentialComponent credentials;

    public boolean hasComposite() {
        return true;
    }

    public ImageDescriptor getImageDescriptor() {
        return CDKCoreActivator.getDefault().getSharedImages().descriptor("icons/cdk_box_130x65.png");
    }

    public Composite createComposite(Composite parent, IWizardHandle handle) {
        this.handle = handle;
        Composite main = new Composite(parent, 0);
        handle.setTitle("CDK Server Adapter");
        handle.setDescription("A server adapter representing a CDK installation folder containing a Vagrantfile.");
        handle.setImageDescriptor(this.getImageDescriptor());
        main.setLayout((Layout)new GridLayout(3, false));
        this.credentials = new ChooseCredentialComponent(new String[]{"access.redhat.com"});
        this.credentials.addCredentialListener(new ICredentialCompositeListener(){

            public void credentialsChanged() {
                CDKServerWizardFragment.this.validate();
            }
        });
        this.credentials.create(main);
        this.credentials.gridLayout(3);
        Label l = new Label(main, 0);
        l.setText("Folder: ");
        GridData homeData = new GridData();
        homeData.grabExcessHorizontalSpace = true;
        homeData.horizontalAlignment = 4;
        this.homeText = new Text(main, 2048);
        this.homeText.setLayoutData((Object)homeData);
        this.browseButton = new Button(main, 8);
        this.browseButton.setText("Browse...");
        this.homeText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                CDKServerWizardFragment.this.homeDir = CDKServerWizardFragment.this.homeText.getText();
                CDKServerWizardFragment.this.validate();
            }
        });
        this.browseButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                CDKServerWizardFragment.this.browseHomeDirClicked();
                CDKServerWizardFragment.this.validate();
            }
        });
        String err = this.findError();
        this.setComplete(err == null);
        handle.update();
        return main;
    }

    private void validate() {
        String err = this.findError();
        if (err != null) {
            this.handle.setMessage(err, 3);
            this.setComplete(false);
        } else {
            this.setComplete(true);
            String warn = this.findWarning();
            if (warn != null) {
                this.handle.setMessage(warn, 2);
            } else {
                this.handle.setMessage(null, 0);
            }
        }
        this.handle.update();
    }

    private String findWarning() {
        return null;
    }

    private String findError() {
        if (this.homeDir == null || !new File(this.homeDir).exists()) {
            return "The selected folder does not exist.";
        }
        if (!new File(this.homeDir, "Vagrantfile").exists()) {
            return "The selected folder does not have a Vagrantfile";
        }
        if (this.credentials.getDomain() == null || this.credentials.getUser() == null) {
            return "The CDK Server Adapter requries Red Hat Access credentials.";
        }
        return null;
    }

    protected void browseHomeDirClicked() {
        File directory;
        File file;
        File file2 = file = this.homeDir == null ? null : new File(this.homeDir);
        if (file != null && !file.exists()) {
            file = null;
        }
        if ((directory = CDKServerWizardFragment.getDirectory(file, this.homeText.getShell())) != null) {
            this.homeDir = directory.getAbsolutePath();
            this.homeText.setText(this.homeDir);
        }
    }

    protected static File getDirectory(File startingDirectory, Shell shell) {
        String dir;
        DirectoryDialog fileDialog = new DirectoryDialog(shell, 4096);
        if (startingDirectory != null) {
            fileDialog.setFilterPath(startingDirectory.getPath());
        }
        if ((dir = fileDialog.open()) != null && (dir = dir.trim()).length() > 0) {
            return new File(dir);
        }
        return null;
    }

    protected IServer getServerFromTaskModel() {
        IServer wc = (IServer)this.getTaskModel().getObject("server");
        return wc;
    }

    public void performFinish(IProgressMonitor monitor) throws CoreException {
        this.exit();
        IServer s = this.getServerFromTaskModel();
        if (s instanceof IServerWorkingCopy) {
            IServerWorkingCopy swc = (IServerWorkingCopy)s;
            swc.setAttribute("org.jboss.tools.openshift.cdk.server.core.internal.adapter.FOLDER", this.homeDir);
        }
    }
}

