/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.cdk.server.core.internal.listeners;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Properties;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.linuxtools.docker.core.DockerConnectionManager;
import org.eclipse.linuxtools.docker.core.DockerException;
import org.eclipse.linuxtools.docker.core.IDockerConnection;
import org.eclipse.linuxtools.internal.docker.core.DockerConnection;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.ServerEvent;
import org.jboss.ide.eclipse.as.core.server.UnitedServerListener;
import org.jboss.tools.openshift.cdk.server.core.internal.CDKConstantUtility;
import org.jboss.tools.openshift.cdk.server.core.internal.CDKCoreActivator;
import org.jboss.tools.openshift.cdk.server.core.internal.adapter.CDKServer;
import org.jboss.tools.openshift.cdk.server.core.internal.adapter.controllers.VagrantLaunchUtility;
import org.jboss.tools.openshift.common.core.connection.ConnectionType;
import org.jboss.tools.openshift.common.core.connection.ConnectionsFactoryTracker;
import org.jboss.tools.openshift.common.core.connection.ConnectionsRegistrySingleton;
import org.jboss.tools.openshift.common.core.connection.IConnection;
import org.jboss.tools.openshift.common.core.connection.IConnectionFactory;
import org.jboss.tools.openshift.core.connection.Connection;

public class ConfigureDependentFrameworksListener
extends UnitedServerListener {
    private static String DOTCDK_AUTH_SCHEME = "openshift.auth.scheme";
    private static String DOTCDK_AUTH_USERNAME = "openshift.auth.username";

    public void serverChanged(final ServerEvent event) {
        if (ConfigureDependentFrameworksListener.serverSwitchesToState((ServerEvent)event, (int)2) && this.canHandleServer(event.getServer())) {
            new Thread("Loading ADBInfo to configure dependent frameworks"){

                @Override
                public void run() {
                    ConfigureDependentFrameworksListener.this.launchChange(event.getServer());
                }
            }.start();
        }
    }

    private void launchChange(IServer server) {
        ADBInfo adb = this.loadADBInfo(server);
        this.configureOpenshift(server, adb);
        this.configureDocker(server, adb);
    }

    public boolean canHandleServer(IServer server) {
        return server.getServerType().getId().equals("org.jboss.tools.openshift.cdk.server.type");
    }

    private String getNextName(IServer server, DockerConnectionManager mgr) {
        String nameBase;
        IDockerConnection[] cons = mgr.getConnections();
        ArrayList<String> names = new ArrayList<String>();
        int i = 0;
        while (i < cons.length) {
            names.add(cons[i].getName());
            ++i;
        }
        String name = nameBase = server.getName();
        int count = 0;
        boolean done = false;
        while (!done) {
            if (names.contains(name)) {
                name = String.valueOf(nameBase) + " (" + ++count + ")";
                continue;
            }
            done = true;
        }
        return name;
    }

    private boolean dockerConnectionExists(DockerConnectionManager mgr, String dockerHost) {
        IDockerConnection[] cons = mgr.getConnections();
        String httpHost = dockerHost.replace("tcp://", "http://");
        String httpsHost = dockerHost.replace("tcp://", "https://");
        int i = 0;
        while (i < cons.length) {
            if (cons[i].getUri().equals(dockerHost) || cons[i].getUri().equals(httpHost) || cons[i].getUri().equals(httpsHost)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private void configureDocker(IServer server, ADBInfo adb) {
        try {
            DockerConnectionManager mgr = DockerConnectionManager.getInstance();
            String dockerHost = (String)adb.env.get("DOCKER_HOST");
            if (!this.dockerConnectionExists(mgr, dockerHost)) {
                boolean tlsVerify;
                DockerConnection.Builder tcpConnectionBuilder = new DockerConnection.Builder().name(this.getNextName(server, mgr)).tcpHost(dockerHost);
                String tlsVerifyString = (String)adb.env.get("DOCKER_TLS_VERIFY");
                boolean bl = tlsVerify = Integer.parseInt(tlsVerifyString) != 0;
                if (tlsVerify) {
                    String tlsCertPath = (String)adb.env.get("DOCKER_CERT_PATH");
                    tcpConnectionBuilder.tcpCertPath(tlsCertPath);
                }
                DockerConnection con = tcpConnectionBuilder.build();
                mgr.getConnections();
                mgr.addConnection((IDockerConnection)con);
            }
        }
        catch (DockerException de) {
            de.printStackTrace();
        }
    }

    private Properties getDotCDK(IServer server) {
        File dotcdk;
        String cdkFolder = server.getAttribute("org.jboss.tools.openshift.cdk.server.core.internal.adapter.FOLDER", null);
        if (cdkFolder != null && new File(cdkFolder).exists() && (dotcdk = new File(cdkFolder, ".cdk")).exists()) {
            try {
                Properties props = new Properties();
                props.load(new FileInputStream(dotcdk));
                return props;
            }
            catch (IOException ioe) {
                CDKCoreActivator.pluginLog().logError("Error loading properties from .cdk file " + dotcdk.getAbsolutePath(), (Throwable)ioe);
            }
        }
        return new Properties();
    }

    private void configureOpenshift(IServer server, ADBInfo adb) {
        Properties dotcdkProps = this.getDotCDK(server);
        String authScheme = dotcdkProps.containsKey(DOTCDK_AUTH_SCHEME) ? dotcdkProps.getProperty(DOTCDK_AUTH_SCHEME) : "Basic";
        String username = dotcdkProps.containsKey(DOTCDK_AUTH_USERNAME) ? dotcdkProps.getProperty(DOTCDK_AUTH_USERNAME) : "test-admin";
        String password = "password";
        Collection connections = ConnectionsRegistrySingleton.getInstance().getAll();
        Iterator it = connections.iterator();
        String soughtHost = String.valueOf(adb.openshiftHost) + ":" + adb.openshiftPort;
        boolean found = false;
        while (it.hasNext() && !found) {
            String host;
            IConnection c = (IConnection)it.next();
            if (c.getType() != ConnectionType.Kubernetes || !(host = c.getHost()).equals(soughtHost)) continue;
            found = true;
        }
        if (!found) {
            ConnectionsFactoryTracker connectionsFactory = new ConnectionsFactoryTracker();
            connectionsFactory.open();
            IConnectionFactory factory = connectionsFactory.getById("org.jboss.tools.openshift.core.ConnectionFactory");
            IConnection con = factory.create(soughtHost);
            ((Connection)con).setAuthScheme(authScheme);
            ((Connection)con).setUsername(username);
            ((Connection)con).setPassword(password);
            ConnectionsRegistrySingleton.getInstance().add(con);
        }
    }

    private File getWorkingDirectory(IServer s) {
        String str = s.getAttribute("org.jboss.tools.openshift.cdk.server.core.internal.adapter.FOLDER", null);
        if (str != null && new File(str).exists()) {
            return new File(str);
        }
        return null;
    }

    private ADBInfo loadADBInfo(IServer server) {
        String[] args = new String[]{"adbinfo", "--no-color"};
        HashMap<String, String> env = new HashMap<String, String>(System.getenv());
        String vagrantcmdloc = CDKConstantUtility.getVagrantLocation(server);
        CDKServer cdkServer = (CDKServer)((Object)server.loadAdapter(CDKServer.class, (IProgressMonitor)new NullProgressMonitor()));
        boolean passCredentials = cdkServer.getServer().getAttribute("org.jboss.tools.openshift.cdk.server.core.internal.adapter.CDKServer.passCredentials", false);
        if (passCredentials) {
            String userKey = cdkServer.getServer().getAttribute("org.jboss.tools.openshift.cdk.server.core.internal.adapter.CDKServer.env.user", "SUB_USERNAME");
            String passKey = cdkServer.getServer().getAttribute("org.jboss.tools.openshift.cdk.server.core.internal.adapter.CDKServer.env.pass", "SUB_PASSWORD");
            env.put(userKey, cdkServer.getUsername());
            env.put(passKey, cdkServer.getPassword());
        }
        try {
            String[] lines = VagrantLaunchUtility.call(vagrantcmdloc, args, this.getWorkingDirectory(server), env);
            String setEnvVarCommand = Platform.getOS().equals("win32") ? "setx " : "export ";
            String setEnvVarDelim = Platform.getOS().equals("win32") ? " " : "=";
            HashMap<String, String> adbEnv = new HashMap<String, String>();
            for (String oneAppend : Arrays.asList(lines)) {
                String[] allAppends = oneAppend.split("\n");
                int i = 0;
                while (i < allAppends.length) {
                    String lineRemainder;
                    int eq;
                    if (allAppends[i].trim().startsWith(setEnvVarCommand) && (eq = (lineRemainder = allAppends[i].trim().substring(setEnvVarCommand.length())).indexOf(setEnvVarDelim)) != -1) {
                        String k = lineRemainder.substring(0, eq);
                        String v = lineRemainder.substring(eq + 1);
                        adbEnv.put(k, v);
                    }
                    ++i;
                }
            }
            return new ADBInfo(adbEnv);
        }
        catch (IOException ce) {
            ce.printStackTrace();
            return null;
        }
    }

    private static class ADBInfo {
        private int openshiftPort = 8443;
        private String openshiftHost = "https://10.1.2.2";
        private HashMap<String, String> env;

        public ADBInfo(HashMap<String, String> env) {
            this.env = env;
            try {
                String dockerHost = env.get("DOCKER_HOST");
                URI url = new URI(dockerHost);
                String h = url.getHost();
                this.openshiftHost = "https://" + h;
            }
            catch (URISyntaxException murle) {
                murle.printStackTrace();
            }
        }
    }
}

