/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.cdk.server.core.internal.adapter.controllers;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.wst.server.core.IServer;
import org.jboss.tools.openshift.cdk.server.core.internal.adapter.CDKServer;
import org.jboss.tools.openshift.cdk.server.core.internal.adapter.controllers.ExternalLaunchUtil;

public class VagrantLaunchUtility {
    public ILaunchConfigurationWorkingCopy createExternalToolsLaunchConfig(IServer s, String args, String launchConfigName) throws CoreException {
        return this.setupLaunch(s, args, launchConfigName, s.getLaunchConfiguration(true, (IProgressMonitor)new NullProgressMonitor()));
    }

    public ILaunchConfigurationWorkingCopy setupLaunch(IServer s, String args, String launchConfigName, ILaunchConfiguration startupConfig) throws CoreException {
        CDKServer cdkServer = (CDKServer)((Object)s.loadAdapter(CDKServer.class, (IProgressMonitor)new NullProgressMonitor()));
        ILaunchConfigurationWorkingCopy wc = this.findLaunchConfig(s, launchConfigName);
        wc.setAttributes(startupConfig.getAttributes());
        wc.setAttribute("org.eclipse.ui.externaltools.ATTR_TOOL_ARGUMENTS", args);
        boolean passCredentials = cdkServer.getServer().getAttribute("org.jboss.tools.openshift.cdk.server.core.internal.adapter.CDKServer.passCredentials", false);
        if (passCredentials) {
            String userName;
            HashMap existingEnvironment = startupConfig.getAttribute("org.eclipse.debug.core.environmentVariables", null);
            if (existingEnvironment == null) {
                existingEnvironment = new HashMap();
            }
            if ((userName = cdkServer.getUsername()) == null) {
                throw new CoreException((IStatus)new Status(4, "org.jboss.tools.openshift.cdk.server.core", "The credentials for " + s.getName() + " are invalid. No username found. Please open your server editor " + "and set your access.redhat.com credentials."));
            }
            HashMap<String, String> env = new HashMap<String, String>(existingEnvironment);
            String passKey = cdkServer.getServer().getAttribute("org.jboss.tools.openshift.cdk.server.core.internal.adapter.CDKServer.env.pass", "SUB_PASSWORD");
            String pass = cdkServer.getPassword();
            if (pass == null) {
                throw new CoreException((IStatus)new Status(4, "org.jboss.tools.openshift.cdk.server.core", "The credentials for " + s.getName() + " are invalid. No password found for username " + cdkServer.getUsername() + " for the access.redhat.com domain. Please open your server editor " + "set your access.redhat.com credentials."));
            }
            if (passKey != null && pass != null) {
                env.put(passKey, pass);
            }
            wc.setAttribute("org.eclipse.debug.core.environmentVariables", env);
        } else {
            wc.setAttribute("org.eclipse.debug.core.environmentVariables", startupConfig.getAttribute("org.eclipse.debug.core.environmentVariables", null));
        }
        return wc;
    }

    private ILaunchConfigurationWorkingCopy findLaunchConfig(IServer s, String launchName) throws CoreException {
        return ExternalLaunchUtil.findExternalToolsLaunchConfig(s, launchName);
    }

    public static String[] convertEnvironment(Map<String, String> env) {
        if (env == null || env.size() == 0) {
            return null;
        }
        HashMap<String, String> original = new HashMap<String, String>(System.getenv());
        for (String k : env.keySet()) {
            original.put(k, env.get(k));
        }
        ArrayList<String> ret = new ArrayList<String>();
        Iterator it = original.keySet().iterator();
        String working = null;
        while (it.hasNext()) {
            working = (String)it.next();
            ret.add(String.valueOf(working) + "=" + (String)original.get(working));
        }
        return ret.toArray(new String[ret.size()]);
    }

    public static String[] call(String rootCommand, String[] args, File vagrantDir, Map<String, String> env) throws IOException {
        ArrayList<String> result;
        block4: {
            String[] envp = env == null ? null : VagrantLaunchUtility.convertEnvironment(env);
            result = new ArrayList<String>();
            ArrayList<String> cmd = new ArrayList<String>();
            cmd.add(rootCommand);
            cmd.addAll(Arrays.asList(args));
            Process p = Runtime.getRuntime().exec(cmd.toArray(new String[0]), envp, vagrantDir);
            BufferedReader buff = new BufferedReader(new InputStreamReader(p.getInputStream()));
            try {
                if (p.waitFor() == 0) {
                    String line;
                    while ((line = buff.readLine()) != null) {
                        result.add(line);
                    }
                    break block4;
                }
                return new String[0];
            }
            catch (InterruptedException interruptedException) {}
        }
        return result.toArray(new String[0]);
    }
}

