/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.cdk.server.core.internal.adapter.controllers;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IDebugEventSetListener;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.swt.widgets.Display;
import org.eclipse.tm.internal.terminal.control.impl.ITerminalControlForText;
import org.eclipse.tm.terminal.view.core.interfaces.ITerminalService;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.IServerAttributes;
import org.jboss.ide.eclipse.as.core.server.IServerStatePoller;
import org.jboss.ide.eclipse.as.core.server.internal.PollThread;
import org.jboss.ide.eclipse.as.core.util.JBossServerBehaviorUtils;
import org.jboss.ide.eclipse.as.core.util.PollThreadUtils;
import org.jboss.ide.eclipse.as.wtp.core.server.behavior.AbstractSubsystemController;
import org.jboss.ide.eclipse.as.wtp.core.server.behavior.ControllableServerBehavior;
import org.jboss.ide.eclipse.as.wtp.core.server.behavior.IServerShutdownController;
import org.jboss.tools.openshift.cdk.server.core.internal.CDKCoreActivator;
import org.jboss.tools.openshift.cdk.server.core.internal.adapter.CDKServer;
import org.jboss.tools.openshift.cdk.server.core.internal.adapter.VagrantPoller;
import org.jboss.tools.openshift.cdk.server.core.internal.adapter.controllers.ExternalLaunchUtil;
import org.jboss.tools.openshift.cdk.server.core.internal.adapter.controllers.IExternalLaunchConstants;
import org.jboss.tools.openshift.cdk.server.core.internal.adapter.controllers.VagrantLaunchUtility;
import org.jboss.tools.openshift.cdk.server.ui.internal.util.TerminalUtility;

public class CDKShutdownController
extends AbstractSubsystemController
implements IServerShutdownController,
IExternalLaunchConstants {
    public IStatus canStop() {
        return Status.OK_STATUS;
    }

    public ControllableServerBehavior getBehavior() {
        return (ControllableServerBehavior)this.getServer().loadAdapter(ControllableServerBehavior.class, (IProgressMonitor)new NullProgressMonitor());
    }

    private void cancelPoller() {
        Object pt = this.getBehavior().getSharedData("DeployableServerBehavior.PollThread");
        if (pt instanceof PollThread) {
            ((PollThread)pt).cancel();
        }
    }

    protected boolean getRequiresForce() {
        Object o = this.getControllableBehavior().getSharedData("DeployableServerBehavior.RequiresForceStop");
        return o == null ? false : (Boolean)o;
    }

    protected void setNextStopRequiresForce(boolean val) {
        this.getControllableBehavior().putSharedData("DeployableServerBehavior.RequiresForceStop", (Object)val);
    }

    public void stop(boolean force) {
        this.getBehavior().setServerStopping();
        IStatus state = PollThreadUtils.isServerStarted((IServer)this.getServer(), (IServerStatePoller)new VagrantPoller());
        boolean started = state.isOK();
        if (!started && state.getSeverity() == 4) {
            this.cancelPoller();
            this.getBehavior().setServerStopped();
            return;
        }
        try {
            this.shutdownViaExternalTools();
        }
        catch (CoreException ce) {
            CDKCoreActivator.getDefault().getLog().log((IStatus)new Status(4, "org.jboss.tools.openshift.cdk.server.core", "Error shutting down server", (Throwable)ce));
            this.getBehavior().setServerStarted();
        }
    }

    private void shutdownViaExternalTools() throws CoreException {
        String cmd = "halt --no-color";
        ILaunchConfigurationWorkingCopy wc = new VagrantLaunchUtility().createExternalToolsLaunchConfig(this.getServer(), cmd, "Shutdown " + this.getServer().getName());
        ControllableServerBehavior beh = (ControllableServerBehavior)this.getServer().loadAdapter(ControllableServerBehavior.class, (IProgressMonitor)new NullProgressMonitor());
        try {
            ILaunch launch2 = wc.launch("run", (IProgressMonitor)new NullProgressMonitor());
            IProcess[] processes = launch2.getProcesses();
            beh.setServerStopping();
            if (processes != null && processes.length >= 1 && processes[0] != null) {
                DebugPlugin.getDefault().addDebugEventListener(this.getDebugListener(processes));
            }
        }
        catch (CoreException ce) {
            CDKCoreActivator.getDefault().getLog().log(ce.getStatus());
        }
    }

    private IDebugEventSetListener getDebugListener(final IProcess[] processes) {
        return new IDebugEventSetListener(){

            public void handleDebugEvents(DebugEvent[] events) {
                if (events != null) {
                    int size = events.length;
                    int i = 0;
                    while (i < size) {
                        if (processes[0] != null && processes[0].equals(events[i].getSource()) && events[i].getKind() == 8) {
                            CDKShutdownController.this.processTerminated(CDKShutdownController.this.getServer(), processes[0], this);
                        }
                        ++i;
                    }
                }
            }
        };
    }

    private void processTerminated(IServer server, IProcess process, IDebugEventSetListener listener) {
        final ControllableServerBehavior beh = (ControllableServerBehavior)JBossServerBehaviorUtils.getControllableBehavior((IServerAttributes)server);
        new Thread(){

            @Override
            public void run() {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {}
                IStatus stat = new VagrantPoller().getCurrentStateSynchronous(CDKShutdownController.this.getServer());
                if (stat.getSeverity() == 4) {
                    beh.setServerStopped();
                    beh.setRunMode("run");
                    beh.putSharedData("CDKServerBehaviour.CACHED_PASSWORD", null);
                } else {
                    beh.setServerStarted();
                    CDKShutdownController.this.setNextStopRequiresForce(true);
                }
            }
        }.start();
        DebugPlugin.getDefault().removeDebugEventListener(listener);
    }

    private ILaunchConfigurationWorkingCopy findLaunchConfig(IServer s) throws CoreException {
        return ExternalLaunchUtil.findExternalToolsLaunchConfig(s, this.getStartupLaunchName(s));
    }

    private String getStartupLaunchName(IServer s) {
        return "Shutdown " + s.getName();
    }

    private void shutdownViaTerminal(boolean requiresCancelation) {
        if (this.getRequiresForce()) {
            this.setNextStopRequiresForce(false);
        }
        final ITerminalControlForText[] control = new ITerminalControlForText[]{null};
        final Map<String, Object> props = TerminalUtility.getPropertiesForServer(this.getServer());
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                control[0] = TerminalUtility.findTerminalControl(props);
            }
        });
        final CustomDone cd = new CustomDone();
        if (control[0] == null) {
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    TerminalUtility.openConsole(props, cd);
                }
            });
            while (cd.getStatus() == null) {
                try {
                    Thread.sleep(200L);
                }
                catch (InterruptedException interruptedException) {}
            }
            Display.getDefault().syncExec(new Runnable(){

                @Override
                public void run() {
                    control[0] = TerminalUtility.findTerminalControl(props);
                }
            });
        }
        String command2 = "vagrant halt";
        CDKServer cdkServer = (CDKServer)((Object)this.getServer().loadAdapter(CDKServer.class, (IProgressMonitor)new NullProgressMonitor()));
        boolean passCredentials = cdkServer.getServer().getAttribute("org.jboss.tools.openshift.cdk.server.core.internal.adapter.CDKServer.passCredentials", false);
        if (passCredentials) {
            String userKey = cdkServer.getServer().getAttribute("org.jboss.tools.openshift.cdk.server.core.internal.adapter.CDKServer.env.user", "SUB_USERNAME");
            String passKey = cdkServer.getServer().getAttribute("org.jboss.tools.openshift.cdk.server.core.internal.adapter.CDKServer.env.pass", "SUB_PASSWORD");
            String user = cdkServer.getUsername();
            String pass = cdkServer.getPassword();
            command2 = String.valueOf(userKey) + "=" + user + " " + passKey + "=" + pass + " " + command2;
        }
        String command = "\n" + command2 + "\n";
        if (control[0] != null) {
            OutputStream os = control[0].getOutputStream();
            try {
                if (requiresCancelation) {
                    os.write(new byte[]{3});
                    try {
                        Thread.sleep(300L);
                    }
                    catch (InterruptedException interruptedException) {}
                    os.write(new byte[]{3});
                }
                os.write(command.getBytes());
                os.flush();
                try {
                    Thread.sleep(1500L);
                }
                catch (InterruptedException interruptedException) {}
                this.launchShutdownPoller();
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
        } else {
            this.getBehavior().setServerStarted();
        }
    }

    private void launchShutdownPoller() {
        PollThreadUtils.pollServer((IServer)this.getServer(), (boolean)false, (IServerStatePoller)new VagrantPoller());
    }

    private class CustomDone
    implements ITerminalService.Done {
        private IStatus stat = null;

        private CustomDone() {
        }

        public void done(IStatus status) {
            this.stat = status;
        }

        public IStatus getStatus() {
            return this.stat;
        }
    }
}

