/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.cdk.server.core.internal.adapter.controllers;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IDebugEventSetListener;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.swt.widgets.Display;
import org.eclipse.tm.internal.terminal.control.impl.ITerminalControlForText;
import org.eclipse.tm.terminal.view.core.interfaces.ITerminalService;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.IServerAttributes;
import org.eclipse.wst.server.core.ServerUtil;
import org.jboss.ide.eclipse.as.core.server.IServerStatePoller;
import org.jboss.ide.eclipse.as.core.util.JBossServerBehaviorUtils;
import org.jboss.ide.eclipse.as.core.util.PollThreadUtils;
import org.jboss.ide.eclipse.as.wtp.core.server.behavior.AbstractSubsystemController;
import org.jboss.ide.eclipse.as.wtp.core.server.behavior.ControllableServerBehavior;
import org.jboss.ide.eclipse.as.wtp.core.server.behavior.IControllableServerBehavior;
import org.jboss.ide.eclipse.as.wtp.core.server.behavior.ILaunchServerController;
import org.jboss.tools.openshift.cdk.server.core.internal.CDKConstantUtility;
import org.jboss.tools.openshift.cdk.server.core.internal.CDKCoreActivator;
import org.jboss.tools.openshift.cdk.server.core.internal.adapter.CDKServer;
import org.jboss.tools.openshift.cdk.server.core.internal.adapter.CDKServerBehaviour;
import org.jboss.tools.openshift.cdk.server.core.internal.adapter.VagrantPoller;
import org.jboss.tools.openshift.cdk.server.core.internal.adapter.controllers.IExternalLaunchConstants;
import org.jboss.tools.openshift.cdk.server.core.internal.adapter.controllers.VagrantLaunchUtility;
import org.jboss.tools.openshift.cdk.server.ui.internal.util.TerminalUtility;

public class CDKLaunchController
extends AbstractSubsystemController
implements ILaunchServerController,
IExternalLaunchConstants {
    private static final String FLAG_INITIALIZED = "org.jboss.tools.openshift.cdk.server.core.internal.adapter.controllers.launch.isInitialized";

    public IStatus canStart(String launchMode) {
        return Status.OK_STATUS;
    }

    public void setupLaunchConfiguration(ILaunchConfigurationWorkingCopy workingCopy, IProgressMonitor monitor) throws CoreException {
        if (!this.isInitialized(workingCopy)) {
            this.initialize(workingCopy);
        }
        this.performOverrides(workingCopy);
    }

    private void performOverrides(ILaunchConfigurationWorkingCopy workingCopy) throws CoreException {
        IServer s = ServerUtil.getServer((ILaunchConfiguration)workingCopy);
        CDKServer cdkServer = (CDKServer)((Object)s.loadAdapter(CDKServer.class, (IProgressMonitor)new NullProgressMonitor()));
        String workingDir = s.getAttribute("org.jboss.tools.openshift.cdk.server.core.internal.adapter.FOLDER", null);
        workingCopy.setAttribute("org.eclipse.ui.externaltools.ATTR_WORKING_DIRECTORY", workingDir);
        boolean passCredentials = cdkServer.getServer().getAttribute("org.jboss.tools.openshift.cdk.server.core.internal.adapter.CDKServer.passCredentials", false);
        HashMap<String, String> env = workingCopy.getAttribute("org.eclipse.debug.core.environmentVariables", null);
        env = env == null ? new HashMap<String, String>() : new HashMap(env);
        if (passCredentials) {
            String userKey = cdkServer.getServer().getAttribute("org.jboss.tools.openshift.cdk.server.core.internal.adapter.CDKServer.env.user", "SUB_USERNAME");
            env.put(userKey, cdkServer.getUsername());
        }
        if (Platform.getOS().equals("win32")) {
            env.put("VAGRANT_DETECTED_OS", "cygwin");
        }
        workingCopy.setAttribute("org.eclipse.debug.core.environmentVariables", env);
    }

    private void initialize(ILaunchConfigurationWorkingCopy wc) throws CoreException {
        IServer s = ServerUtil.getServer((ILaunchConfiguration)wc);
        CDKServer cdkServer = (CDKServer)((Object)s.loadAdapter(CDKServer.class, (IProgressMonitor)new NullProgressMonitor()));
        wc.setAttribute(FLAG_INITIALIZED, true);
        String workingDir = s.getAttribute("org.jboss.tools.openshift.cdk.server.core.internal.adapter.FOLDER", null);
        wc.setAttribute("org.eclipse.ui.externaltools.ATTR_WORKING_DIRECTORY", workingDir);
        boolean passCredentials = cdkServer.getServer().getAttribute("org.jboss.tools.openshift.cdk.server.core.internal.adapter.CDKServer.passCredentials", false);
        if (passCredentials) {
            HashMap<String, String> env = new HashMap<String, String>();
            String userKey = cdkServer.getServer().getAttribute("org.jboss.tools.openshift.cdk.server.core.internal.adapter.CDKServer.env.user", "SUB_USERNAME");
            env.put(userKey, cdkServer.getUsername());
            wc.setAttribute("org.eclipse.debug.core.environmentVariables", env);
        }
        wc.setAttribute("org.eclipse.ui.externaltools.ATTR_LOCATION", CDKConstantUtility.getVagrantLocation());
        String args = "up --provision --no-color";
        wc.setAttribute("org.eclipse.ui.externaltools.ATTR_TOOL_ARGUMENTS", args);
    }

    private boolean isInitialized(ILaunchConfigurationWorkingCopy wc) throws CoreException {
        return wc.hasAttribute(FLAG_INITIALIZED) && wc.getAttribute(FLAG_INITIALIZED, Boolean.valueOf(false).booleanValue());
    }

    public void launch(ILaunchConfiguration configuration, String mode, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        IServer s = ServerUtil.getServer((ILaunchConfiguration)configuration);
        if (s == null) {
            throw new CoreException(CDKCoreActivator.statusFactory().errorStatus("Unable to locate server from launch configuration."));
        }
        ControllableServerBehavior beh = (ControllableServerBehavior)JBossServerBehaviorUtils.getControllableBehavior((ILaunchConfiguration)configuration);
        beh.setServerStarting();
        String vagrantLoc = CDKConstantUtility.getVagrantLocation(s);
        if (vagrantLoc == null || !new File(vagrantLoc).exists()) {
            beh.setServerStopped();
            if (vagrantLoc == null) {
                throw new CoreException(CDKCoreActivator.statusFactory().errorStatus("Unable to locate vagrant command. Please check to ensure that the command is available on your Path environment variable."));
            }
            throw new CoreException(CDKCoreActivator.statusFactory().errorStatus("Expected location of vagrant command does not exist: " + vagrantLoc));
        }
        CDKServer cdkServer = (CDKServer)((Object)s.loadAdapter(CDKServer.class, (IProgressMonitor)new NullProgressMonitor()));
        String password = cdkServer.getPassword();
        beh.putSharedData("CDKServerBehaviour.CACHED_PASSWORD", (Object)password);
        IStatus stat = new VagrantPoller().getCurrentStateSynchronous(this.getServer());
        if (stat.isOK()) {
            beh.setServerStarted();
            return;
        }
        String args = configuration.getAttribute("org.eclipse.ui.externaltools.ATTR_TOOL_ARGUMENTS", null);
        ILaunchConfigurationWorkingCopy wc = null;
        try {
            wc = new VagrantLaunchUtility().createExternalToolsLaunchConfig(s, args, this.getStartupLaunchName(s));
        }
        catch (CoreException ce) {
            CDKCoreActivator.pluginLog().logError((Throwable)ce);
            beh.setServerStopped();
            throw ce;
        }
        ILaunch launch2 = wc.launch("run", monitor);
        IProcess[] processes = launch2.getProcesses();
        if (processes != null && processes.length >= 1 && processes[0] != null) {
            IDebugEventSetListener debug = this.getDebugListener(processes);
            if (beh != null) {
                IProcess launched = processes[0];
                beh.putSharedData("AbstractStartJavaServerLaunchDelegate.Process", (Object)launched);
                beh.putSharedData("AbstractStartJavaServerLaunchDelegate.DebugListener", (Object)debug);
            }
            DebugPlugin.getDefault().addDebugEventListener(debug);
        }
    }

    private IDebugEventSetListener getDebugListener(final IProcess[] processes) {
        return new IDebugEventSetListener(){

            public void handleDebugEvents(DebugEvent[] events) {
                if (events != null) {
                    int size = events.length;
                    int i = 0;
                    while (i < size) {
                        if (processes[0] != null && processes[0].equals(events[i].getSource()) && events[i].getKind() == 8) {
                            CDKLaunchController.this.processTerminated(CDKLaunchController.this.getServer(), processes[0], this);
                        }
                        ++i;
                    }
                }
            }
        };
    }

    private void processTerminated(IServer server, IProcess process, IDebugEventSetListener listener) {
        final ControllableServerBehavior beh = (ControllableServerBehavior)JBossServerBehaviorUtils.getControllableBehavior((IServerAttributes)server);
        new Thread(){

            @Override
            public void run() {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {}
                IStatus stat = new VagrantPoller().getCurrentStateSynchronous(CDKLaunchController.this.getServer());
                if (stat.isOK()) {
                    beh.setServerStarted();
                    beh.setRunMode("run");
                } else {
                    beh.setServerStopped();
                }
            }
        }.start();
        DebugPlugin.getDefault().removeDebugEventListener(listener);
    }

    private String getStartupLaunchName(IServer s) {
        return "Start " + s.getName();
    }

    public void launchViaTerminal(ILaunchConfiguration configuration, String mode, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        IServer s = ServerUtil.getServer((ILaunchConfiguration)configuration);
        CDKServer cdkServer = (CDKServer)((Object)s.loadAdapter(CDKServer.class, (IProgressMonitor)new NullProgressMonitor()));
        final CDKServerBehaviour beh = (CDKServerBehaviour)((Object)s.loadAdapter(CDKServerBehaviour.class, (IProgressMonitor)new NullProgressMonitor()));
        beh.setServerStarting();
        final Map<String, Object> props = TerminalUtility.getPropertiesForServer(s);
        final CustomDone customDone = new CustomDone();
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                CDKLaunchController.this.openView(props, customDone);
            }
        });
        while (customDone.getStatus() == null) {
            try {
                Thread.sleep(200L);
            }
            catch (InterruptedException interruptedException) {}
        }
        String command2 = "vagrant up";
        boolean passCredentials = cdkServer.getServer().getAttribute("org.jboss.tools.openshift.cdk.server.core.internal.adapter.CDKServer.passCredentials", false);
        if (passCredentials) {
            String userKey = cdkServer.getServer().getAttribute("org.jboss.tools.openshift.cdk.server.core.internal.adapter.CDKServer.env.user", "SUB_USERNAME");
            String passKey = cdkServer.getServer().getAttribute("org.jboss.tools.openshift.cdk.server.core.internal.adapter.CDKServer.env.pass", "SUB_PASSWORD");
            String user = cdkServer.getUsername();
            String pass = cdkServer.getPassword();
            command2 = String.valueOf(userKey) + "=" + user + " " + passKey + "=" + pass + " " + command2;
        }
        final String command = "\n" + command2 + "\n";
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                ITerminalControlForText control = TerminalUtility.findTerminalControl(props);
                if (control != null) {
                    OutputStream os = control.getOutputStream();
                    try {
                        os.write(command.getBytes());
                    }
                    catch (IOException ioe) {
                        ioe.printStackTrace();
                    }
                    CDKLaunchController.this.launchPoller(beh);
                }
            }
        });
    }

    private void launchPoller(IControllableServerBehavior beh) {
        try {
            Thread.sleep(1500L);
        }
        catch (InterruptedException interruptedException) {}
        PollThreadUtils.pollServer((IServer)beh.getServer(), (boolean)true, (IServerStatePoller)new VagrantPoller());
    }

    private void openView(Map<String, Object> props, ITerminalService.Done d) {
        TerminalUtility.openConsole(props, d);
    }

    private class CustomDone
    implements ITerminalService.Done {
        private IStatus stat = null;

        private CustomDone() {
        }

        public void done(IStatus status) {
            this.stat = status;
        }

        public IStatus getStatus() {
            return this.stat;
        }
    }
}

