/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.cdk.server.core.internal;

import java.io.File;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.wst.server.core.IServer;
import org.jboss.tools.openshift.internal.common.core.util.CommandLocationBinary;

public class CDKConstantUtility {
    private static final String VAGRANT_LOCATION_LINUX = "/usr/bin/vagrant";
    private static final String VAGRANT_LOCATION_WINDOWS = "C:\\HashiCorp\\Vagrant\\bin\\vagrant.exe";
    private static CommandLocationBinary binary;

    public static String getVagrantLocation() {
        return CDKConstantUtility.findVagrantLocation();
    }

    public static String getVagrantLocation(IServer server) {
        if (server != null) {
            try {
                String ret;
                ILaunchConfiguration lc = server.getLaunchConfiguration(false, (IProgressMonitor)new NullProgressMonitor());
                if (lc != null && (ret = lc.getAttribute("org.eclipse.ui.externaltools.ATTR_LOCATION", null)) != null && new File(ret).exists()) {
                    return ret;
                }
            }
            catch (CoreException coreException) {}
        }
        return CDKConstantUtility.findVagrantLocation();
    }

    private static String findVagrantLocation() {
        if (binary == null) {
            binary = new CommandLocationBinary("vagrant");
            binary.addPlatformLocation("linux", VAGRANT_LOCATION_LINUX);
            binary.addPlatformLocation("win32", VAGRANT_LOCATION_WINDOWS);
            binary.setDefaultPlatform("linux");
        }
        return binary.findLocation();
    }
}

