/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.cdi.seam.config.core.xml;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jboss.tools.cdi.seam.config.core.xml.Location;
import org.jboss.tools.cdi.seam.config.core.xml.SAXAttribute;
import org.jboss.tools.cdi.seam.config.core.xml.SAXNode;
import org.jboss.tools.cdi.seam.config.core.xml.SAXText;
import org.w3c.dom.Node;

public class SAXElement
extends SAXNode {
    protected String uri;
    protected String localName;
    protected String name;
    protected Location nameLocation;
    protected Map<String, SAXAttribute> attributes = new HashMap<String, SAXAttribute>();
    protected SAXText text;
    protected SAXElement parent = null;
    protected List<SAXElement> children = new ArrayList<SAXElement>();

    public SAXElement() {
    }

    public SAXElement(Node node) {
        this.setName(node.getNodeName());
        this.setLocalName(node.getLocalName());
        this.setURI(node.getNamespaceURI());
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void setNameLocation(Location location) {
        this.nameLocation = location;
    }

    public Location getNameLocation() {
        return this.nameLocation;
    }

    public void setURI(String uri) {
        this.uri = uri;
    }

    public String getURI() {
        return this.uri;
    }

    public void setLocalName(String name) {
        this.localName = name;
    }

    public String getLocalName() {
        return this.localName;
    }

    public String getPrefix() {
        return this.name != null && this.name.indexOf(":") >= 0 ? this.name.substring(0, this.name.indexOf(":")) : null;
    }

    public void setTextNode(SAXText text) {
        this.text = text;
    }

    public SAXText getTextNode() {
        return this.text;
    }

    public void addAttribute(SAXAttribute a) {
        a.setParent(this);
        this.attributes.put(a.getName(), a);
    }

    public boolean hasAttribute(String name) {
        return this.attributes.containsKey(name);
    }

    public SAXAttribute getAttribute(String name) {
        return this.attributes.get(name);
    }

    public Set<String> getAttributeNames() {
        return this.attributes.keySet();
    }

    public void addChildElement(SAXElement child) {
        child.setParent(this);
        this.children.add(child);
    }

    public List<SAXElement> getChildElements() {
        return this.children;
    }

    public void setParent(SAXElement parent) {
        this.parent = parent;
    }

    public SAXElement getParent() {
        return this.parent;
    }
}

