/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.foundation.ui.util;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.SWTError;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.browser.IWebBrowser;
import org.jboss.tools.foundation.core.IURLProvider;
import org.jboss.tools.foundation.core.plugin.log.StatusFactory;
import org.jboss.tools.foundation.ui.internal.FoundationUIPlugin;
import org.jboss.tools.foundation.ui.util.BrowserUtilityMessages;

public class BrowserUtility {
    private static boolean browserLoadingErrorLoged;
    protected static Map<Integer, String> browserNames;
    protected static final boolean isMacOS;

    static {
        browserNames = new HashMap<Integer, String>();
        browserNames.put(65536, "Webkit");
        browserNames.put(32768, "Mozilla");
        isMacOS = "Mac OS X".equals(System.getProperty("os.name"));
    }

    public void checkedCreateInternalBrowser(String url, String browserId, String pluginId, ILog log) {
        try {
            this.openUrl(url, PlatformUI.getWorkbench().getBrowserSupport().createBrowser(6, browserId, null, null), pluginId, log);
        }
        catch (PartInitException e) {
            IStatus errorStatus = StatusFactory.errorStatus((String)pluginId, (String)NLS.bind((String)"Could not open browser for url \"{0}\".", (Object)url), (Throwable)e);
            log.log(errorStatus);
        }
    }

    public void checkedCreateExternalBrowser(String url, String pluginId, ILog log) {
        try {
            this.openUrl(url, PlatformUI.getWorkbench().getBrowserSupport().getExternalBrowser(), pluginId, log);
        }
        catch (PartInitException e) {
            IStatus errorStatus = StatusFactory.errorStatus((String)pluginId, (String)NLS.bind((String)"Could not open browser for url \"{0}\".", (Object)url), (Throwable)e);
            log.log(errorStatus);
        }
    }

    public void openUrl(String url, IWebBrowser browser, String pluginId, ILog log) {
        try {
            browser.openURL(new URL(url));
        }
        catch (PartInitException e) {
            IStatus errorStatus = StatusFactory.errorStatus((String)pluginId, (String)NLS.bind((String)"Could not open browser for url \"{0}\".", (Object)url), (Throwable)e);
            log.log(errorStatus);
        }
        catch (MalformedURLException e) {
            IStatus errorStatus = StatusFactory.errorStatus((String)pluginId, (String)NLS.bind((String)"Could not display malformed url \"{0}\".", (Object)url), (Throwable)e);
            log.log(errorStatus);
        }
    }

    public void openExtenalBrowser(String URL2) {
        this.checkedCreateExternalBrowser(URL2, "org.jboss.tools.foundation.ui", FoundationUIPlugin.getDefault().getLog());
    }

    public Browser createBrowser(int style, Composite parent) {
        return this.createBrowser(style, parent, BrowserUtility.getPreferredBrowser());
    }

    public Browser createBrowser(Composite parent) {
        return this.createBrowser(24, parent, BrowserUtility.getPreferredBrowser());
    }

    public Browser createBrowser(Composite parent, int preferredBrowser) {
        return this.createBrowser(24, parent, preferredBrowser);
    }

    public Browser createBrowser(int style, Composite parent, int preferredBrowser) {
        return this.createBrowser(style, parent, preferredBrowser, true);
    }

    /*
     * Unable to fully structure code
     */
    private Browser createBrowser(int style, Composite parent, int preferredBrowser, boolean logError) {
        val = System.getProperty("jbosstools.skip.browser.creation");
        if (val != null && (skip = Boolean.parseBoolean(val))) {
            return null;
        }
        try {
            return new Browser(parent, style | preferredBrowser);
        }
        catch (SWTError e) {
            preLogged = BrowserUtility.browserLoadingErrorLoged;
            if (!preLogged && logError) {
                BrowserUtility.logBrowserLoadingProblem((Error)e, BrowserUtility.browserNames.get(preferredBrowser), true);
            }
            var12_10 = children = parent.getChildren();
            var11_12 = children.length;
            var10_14 = 0;
            ** while (var10_14 < var11_12)
        }
lbl-1000:
        // 1 sources

        {
            child = var12_10[var10_14];
            child.dispose();
            ++var10_14;
            continue;
        }
lbl18:
        // 1 sources

        try {
            return new Browser(parent, style);
        }
        catch (SWTError e1) {
            if (!preLogged && logError) {
                BrowserUtility.logBrowserLoadingProblem((Error)e1, null, false);
            }
            var14_18 = children1 = parent.getChildren();
            var13_19 = children1.length;
            var12_11 = 0;
            ** while (var12_11 < var13_19)
        }
lbl-1000:
        // 1 sources

        {
            child = var14_18[var12_11];
            child.dispose();
            ++var12_11;
            continue;
        }
lbl31:
        // 1 sources

        return null;
    }

    public Control createBrowserOrLink(int style, Composite parent, int preferredBrowser, String url, String noBrowserText, Menu contextMenu) {
        Control result = this.createBrowserOrLink(style, parent, preferredBrowser, url, noBrowserText);
        result.setMenu(this.createLinkDefaultContextMenu(result, url));
        return result;
    }

    public Control createBrowserOrLink(int style, Composite parent, int preferredBrowser, final String url, String noBrowserText) {
        return this.createBrowserOrLink(style, parent, preferredBrowser, new IURLProvider(){

            public String getUrl() {
                return url;
            }
        }, noBrowserText);
    }

    public Control createBrowserOrLink(int style, Composite parent, IURLProvider url, String noBrowserText) {
        return this.createBrowserOrLink(style, parent, BrowserUtility.getPreferredBrowser(), url, noBrowserText);
    }

    public Control createBrowserOrLink(int style, Composite parent, int preferredBrowser, IURLProvider url, String noBrowserText) {
        Browser result = null;
        Browser browser = this.createBrowser(style, parent, preferredBrowser, false);
        if (browser == null) {
            Link link = new Link(parent, 0);
            link.setText(noBrowserText);
            OpenExBrowserListener openExBrowser = new OpenExBrowserListener(url);
            link.addSelectionListener((SelectionListener)openExBrowser);
            result = link;
        } else {
            result = browser;
        }
        return result;
    }

    private Menu createLinkDefaultContextMenu(Control link, String url) {
        Menu popupMenu = new Menu(link);
        MenuItem refreshItem = new MenuItem(popupMenu, 0);
        refreshItem.setText(BrowserUtilityMessages.Open_in_external_browser);
        refreshItem.addSelectionListener((SelectionListener)new OpenExBrowserListener(url));
        MenuItem copyToClipboard = new MenuItem(popupMenu, 0);
        copyToClipboard.setText(BrowserUtilityMessages.Copy_URL_to_clipboard);
        copyToClipboard.addSelectionListener((SelectionListener)new CopyToClipboardListener(url));
        link.setMenu(popupMenu);
        return popupMenu;
    }

    private static void logBrowserLoadingProblem(Error e, String browserName, boolean warning) {
        Exception e2 = new Exception(e);
        if (browserName == null) {
            browserName = "default";
        }
        String message = "Cannot create " + browserName + " browser";
        if (warning) {
            FoundationUIPlugin.pluginLog().logWarning(message, (Throwable)e2);
        } else {
            FoundationUIPlugin.pluginLog().logError(message, (Throwable)e2);
        }
        browserLoadingErrorLoged = true;
    }

    public static int getPreferredBrowser() {
        return isMacOS ? 65536 : 32768;
    }

    private static class CopyToClipboardListener
    extends SelectionAdapter {
        private String url;
        private Clipboard cb = new Clipboard(Display.getCurrent());

        public CopyToClipboardListener(String url) {
            this.url = url;
        }

        public void widgetSelected(SelectionEvent e) {
            TextTransfer textTransfer = TextTransfer.getInstance();
            this.cb.setContents(new Object[]{this.url}, new Transfer[]{textTransfer});
        }
    }

    public class OpenExBrowserListener
    extends SelectionAdapter {
        private String url;
        private IURLProvider provider;

        public OpenExBrowserListener(String url) {
            this.url = url;
        }

        public OpenExBrowserListener(IURLProvider provider) {
            this.provider = provider;
        }

        public void widgetSelected(SelectionEvent event) {
            if (this.url != null) {
                BrowserUtility.this.openExtenalBrowser(this.url);
            } else {
                BrowserUtility.this.openExtenalBrowser(this.provider.getUrl());
            }
        }
    }
}

