/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.foundation.ui.credentials.internal;

import java.util.Arrays;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.jboss.tools.foundation.core.credentials.ICredentialDomain;
import org.jboss.tools.foundation.core.credentials.ICredentialsModel;
import org.jboss.tools.foundation.ui.credentials.internal.CredentialMessages;
import org.jboss.tools.foundation.ui.util.FormDataUtility;

public class NewCredentialDomainDialog
extends TitleAreaDialog {
    private ICredentialsModel model;
    private String domainName;
    private ICredentialDomain domain;
    private String defaultUser;
    private Combo defaultUserCombo;
    private Text domainText;

    public NewCredentialDomainDialog(Shell parentShell, ICredentialsModel model) {
        super(parentShell);
        this.model = model;
    }

    public NewCredentialDomainDialog(Shell parentShell, ICredentialsModel model, ICredentialDomain domain) {
        super(parentShell);
        this.model = model;
        this.domain = domain;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        Shell s2 = shell.getParent().getShell();
        if (s2 != null) {
            shell.setLocation(s2.getLocation());
        }
        shell.setBounds(shell.getLocation().x, shell.getLocation().y, 550, 500);
        if (this.domain == null) {
            shell.setText(CredentialMessages.AddACredentialDomain);
        } else {
            shell.setText(CredentialMessages.EditACredentialDomain);
        }
    }

    protected int getShellStyle() {
        int ret = super.getShellStyle();
        return ret | 0x10;
    }

    protected Control createDialogArea(Composite parent) {
        Composite main = new Composite((Composite)super.createDialogArea(parent), 0);
        main.setLayoutData((Object)new GridData(1808));
        main.setLayout((Layout)new FormLayout());
        this.domainText = new Text(main, 2052);
        Label l = new Label(main, 0);
        l.setText(CredentialMessages.NewDomainNameLabel);
        l.setLayoutData((Object)new FormDataUtility().createFormData(0, 4, null, 0, 0, 5, null, 0));
        this.domainText.setLayoutData((Object)new FormDataUtility().createFormData(null, 0, null, 0, l, 5, 100, -5));
        if (this.domain == null) {
            this.setTitle(CredentialMessages.AddACredentialDomain);
        } else {
            this.setTitle(CredentialMessages.EditACredentialDomain);
            this.addDefaultUsernameCombo(main, this.domainText);
            this.domainText.setEnabled(false);
        }
        this.addListeners();
        return main;
    }

    private void addListeners() {
        this.domainText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                NewCredentialDomainDialog.this.domainName = NewCredentialDomainDialog.this.domainText.getText();
                ICredentialDomain[] domains = NewCredentialDomainDialog.this.model.getDomains();
                int i = 0;
                while (i < domains.length) {
                    if (domains[i].getName().equals(NewCredentialDomainDialog.this.domainText.getText())) {
                        NewCredentialDomainDialog.this.setMessage(CredentialMessages.DomainNameExists, 3);
                        NewCredentialDomainDialog.this.getButton(0).setEnabled(false);
                        return;
                    }
                    if (domains[i].getId().equals(NewCredentialDomainDialog.this.domainText.getText())) {
                        NewCredentialDomainDialog.this.setMessage(CredentialMessages.DomainIdExists, 3);
                        NewCredentialDomainDialog.this.getButton(0).setEnabled(false);
                        return;
                    }
                    NewCredentialDomainDialog.this.setMessage(null, 0);
                    NewCredentialDomainDialog.this.getButton(0).setEnabled(true);
                    ++i;
                }
            }
        });
        if (this.defaultUserCombo != null) {
            this.defaultUserCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    int sel = NewCredentialDomainDialog.this.defaultUserCombo.getSelectionIndex();
                    if (sel != -1) {
                        NewCredentialDomainDialog.this.defaultUser = NewCredentialDomainDialog.this.defaultUserCombo.getItem(sel);
                    }
                }
            });
        }
    }

    private void addDefaultUsernameCombo(Composite main, Text domainText) {
        domainText.setText(this.domain.getName());
        String[] users = this.domain.getUsernames();
        if (users.length > 0) {
            int toSelect;
            domainText.setEnabled(false);
            this.defaultUser = this.domain.getDefaultUsername();
            Label comboLabel = new Label(main, 0);
            comboLabel.setText("Default user: ");
            comboLabel.setLayoutData((Object)new FormDataUtility().createFormData(domainText, 8, null, 0, 0, 5, null, 0));
            this.defaultUserCombo = new Combo(main, 8);
            this.defaultUserCombo.setItems(this.domain.getUsernames());
            this.defaultUserCombo.setLayoutData((Object)new FormDataUtility().createFormData(domainText, 5, null, 0, comboLabel, 5, 100, -5));
            int n = toSelect = this.defaultUser == null ? -1 : Arrays.asList(users).indexOf(this.defaultUser);
            if (toSelect != -1) {
                this.defaultUserCombo.select(toSelect);
            }
        }
    }

    public String getDefaultUser() {
        return this.defaultUser;
    }

    public String getDomainName() {
        return this.domainName;
    }
}

