/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.foundation.ui.credentials.internal;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;
import org.jboss.tools.foundation.core.ecf.URLTransportUtility;
import org.jboss.tools.foundation.ui.internal.FoundationUIPlugin;
import org.jboss.tools.foundation.ui.plugin.BaseUISharedImages;
import org.osgi.framework.Bundle;

public class FaviconCache
extends BaseUISharedImages {
    private static final FaviconCache instance = new FaviconCache(FoundationUIPlugin.getDefault().getBundle());
    private static final String FAVICONS = "favicons";
    private static final String DOT_ICO = ".ico";
    private ArrayList<String> failedLoads = new ArrayList();

    public static FaviconCache getDefault() {
        return instance;
    }

    public FaviconCache(Bundle pluginBundle) {
        super(pluginBundle);
        this.init();
    }

    private void init() {
        IPath p = FoundationUIPlugin.getDefault().getStateLocation().append(FAVICONS);
        if (p.toFile().exists()) {
            File[] all = p.toFile().listFiles();
            int i = 0;
            while (i < all.length) {
                if (all[i].getName().endsWith(DOT_ICO)) {
                    String host = all[i].getName().substring(0, all[i].getName().lastIndexOf("."));
                    this.addImage(host, all[i].getName());
                }
                ++i;
            }
        } else {
            p.toFile().mkdirs();
        }
    }

    public void loadFavicon(final String host, final FaviconCacheListener listener) {
        new Thread("Load favicon.ico for " + host){

            @Override
            public void run() {
                FaviconCache.this.loadFaviconSync(host, listener);
            }
        }.start();
    }

    private void loadFaviconSync(String host, FaviconCacheListener listener) {
        File f = this.fetchFaviconSync(host, listener);
        if (f == null) {
            this.failedLoads.add(host);
            listener.fetchFailed(host);
        } else {
            IPath p = FoundationUIPlugin.getDefault().getStateLocation().append(FAVICONS);
            String target = String.valueOf(host) + DOT_ICO;
            f.renameTo(p.append(target).toFile());
            this.addImage(host, target);
            listener.iconCached(host);
        }
    }

    public boolean loadFailed(String host) {
        return this.failedLoads.contains(host);
    }

    private File fetchFaviconSync(String host, FaviconCacheListener listener) {
        try {
            String url = "http://" + host + "/favicon.ico";
            File f = new URLTransportUtility().getCachedFileForURL(url, "Fetching favicon for " + host, 2, (IProgressMonitor)new NullProgressMonitor());
            if (f != null && f.length() > 0L) {
                return f;
            }
        }
        catch (CoreException ce) {
            FoundationUIPlugin.pluginLog().logError((Throwable)ce);
        }
        return null;
    }

    public ImageDescriptor getDescriptorForHost(String host) {
        return this.descriptor(host);
    }

    public Image getImageForHost(String host) {
        return this.image(host);
    }

    @Override
    protected ImageDescriptor createImageDescriptor(String path) {
        try {
            IPath p = FoundationUIPlugin.getDefault().getStateLocation().append(FAVICONS);
            p = p.append(path);
            return ImageDescriptor.createFromURL((URL)p.toFile().toURI().toURL());
        }
        catch (MalformedURLException malformedURLException) {
            FoundationUIPlugin.pluginLog().logError("Error generating favicon image descriptor for host " + path);
            return null;
        }
    }

    public static void cleanup() {
        instance.dispose();
    }

    public static interface FaviconCacheListener {
        public void iconCached(String var1);

        public void fetchFailed(String var1);
    }
}

