/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.batch.ui.participants;

import java.util.HashSet;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.ui.search.ElementQuerySpecification;
import org.eclipse.jdt.ui.search.IMatchPresentation;
import org.eclipse.jdt.ui.search.IQueryParticipant;
import org.eclipse.jdt.ui.search.ISearchRequestor;
import org.eclipse.jdt.ui.search.QuerySpecification;
import org.eclipse.search.ui.text.Match;
import org.jboss.tools.batch.core.IBatchArtifact;
import org.jboss.tools.batch.core.IBatchProject;
import org.jboss.tools.batch.core.IBatchProperty;
import org.jboss.tools.batch.internal.core.impl.BatchProject;
import org.jboss.tools.batch.internal.core.impl.BatchProjectFactory;
import org.jboss.tools.batch.internal.core.impl.BatchUtil;
import org.jboss.tools.batch.ui.participants.BatchParticipantMessages;
import org.jboss.tools.common.text.ITextSourceReference;

public class BatchArtifactSearchParticipant
implements IQueryParticipant {
    public void search(ISearchRequestor requestor, QuerySpecification querySpecification, IProgressMonitor monitor) throws CoreException {
        if (querySpecification instanceof ElementQuerySpecification) {
            BatchProject[] projects;
            if (!this.isSearchForReferences(querySpecification.getLimitTo())) {
                return;
            }
            ElementQuerySpecification qs = (ElementQuerySpecification)querySpecification;
            IJavaElement element = qs.getElement();
            IProject project = element.getJavaProject().getProject();
            BatchProject batchProject = (BatchProject)BatchProjectFactory.getBatchProjectWithProgress((IProject)project);
            if (batchProject == null) {
                return;
            }
            if (BatchArtifactSearchParticipant.containsInSearchScope(querySpecification, project.getFullPath())) {
                this.searchInProject(requestor, querySpecification, (IBatchProject)batchProject, monitor, element);
            }
            BatchProject[] batchProjectArray = projects = batchProject.getAllDependentProjects(true);
            int n = projects.length;
            int n2 = 0;
            while (n2 < n) {
                BatchProject p = batchProjectArray[n2];
                if (BatchArtifactSearchParticipant.containsInSearchScope(querySpecification, p.getProject().getFullPath())) {
                    this.searchInProject(requestor, querySpecification, (IBatchProject)p, monitor, element);
                }
                ++n2;
            }
        }
    }

    private static boolean containsInSearchScope(QuerySpecification querySpecification, IPath projectPath) {
        IPath[] paths;
        IJavaSearchScope searchScope = querySpecification.getScope();
        if (searchScope == null) {
            return true;
        }
        IPath[] iPathArray = paths = searchScope.enclosingProjectsAndJars();
        int n = paths.length;
        int n2 = 0;
        while (n2 < n) {
            IPath path = iPathArray[n2];
            if (path.equals((Object)projectPath)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private void searchInProject(ISearchRequestor requestor, QuerySpecification querySpecification, IBatchProject batchProject, IProgressMonitor monitor, IJavaElement element) {
        IField field;
        IType type;
        IBatchArtifact artifact;
        int worked = 0;
        monitor.beginTask(BatchParticipantMessages.Searching_For_Batch_Artifacts_References, batchProject.getDeclaredBatchJobs().size());
        HashSet references = new HashSet();
        if (element instanceof IType) {
            IType type2 = (IType)element;
            IBatchArtifact artifact2 = batchProject.getArtifact(type2);
            if (artifact2 != null) {
                for (IFile file : batchProject.getDeclaredBatchJobs()) {
                    if (monitor.isCanceled()) {
                        return;
                    }
                    references.addAll(BatchUtil.getAttributeReferences((IFile)file, (String)"ref", (String)artifact2.getName()));
                    monitor.worked(++worked);
                }
            } else {
                for (IFile file : batchProject.getDeclaredBatchJobs()) {
                    if (monitor.isCanceled()) {
                        return;
                    }
                    references.addAll(BatchUtil.getAttributeReferences((IFile)file, (String)"class", (String)type2.getFullyQualifiedName()));
                    monitor.worked(++worked);
                }
            }
        } else if (element instanceof IField && (artifact = batchProject.getArtifact(type = (field = (IField)element).getDeclaringType())) != null) {
            for (IBatchProperty property : artifact.getProperties()) {
                if (!property.getField().equals(field)) continue;
                for (IFile file : batchProject.getDeclaredBatchJobs()) {
                    if (monitor.isCanceled()) {
                        return;
                    }
                    references.addAll(BatchUtil.getPropertyAttributeReferences((IFile)file, (String)artifact.getName(), (String)property.getPropertyName()));
                    monitor.worked(++worked);
                }
            }
        }
        for (ITextSourceReference reference : references) {
            Match match = new Match((Object)((IFile)reference.getResource()), reference.getStartPosition(), reference.getLength());
            requestor.reportMatch(match);
        }
        monitor.done();
    }

    public int estimateTicks(QuerySpecification specification) {
        return 500;
    }

    public IMatchPresentation getUIParticipant() {
        return null;
    }

    public boolean isSearchForReferences(int limitTo) {
        int maskedLimitTo = limitTo & 0xFFFFFFCF;
        return maskedLimitTo == 2 || maskedLimitTo == 3;
    }
}

