/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.batch.ui.internal.wizard;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.jboss.tools.batch.core.BatchArtifactType;
import org.jboss.tools.batch.core.IBatchProject;
import org.jboss.tools.batch.internal.core.impl.PreferredPackageManager;
import org.jboss.tools.batch.ui.internal.wizard.NewBatchArtifactWizard;
import org.jboss.tools.batch.ui.internal.wizard.NewBatchArtifactWizardPage;
import org.jboss.tools.foundation.checkup.TestEnvironmentDetector;

public class NewBatchArtifactDialog
extends WizardDialog {
    public NewBatchArtifactDialog(Shell parentShell) {
        super(parentShell, (IWizard)new NewBatchArtifactWizard());
    }

    public NewBatchArtifactWizard getBatchWizard() {
        return (NewBatchArtifactWizard)this.getWizard();
    }

    public NewBatchArtifactWizardPage getBatchPage() {
        return this.getBatchWizard().getPage();
    }

    public void setTypes(List<BatchArtifactType> types) {
        this.getBatchWizard().setTypes(types);
    }

    public void init(IWorkbench workbench, IStructuredSelection currentSelection) {
        this.getBatchWizard().init(workbench, currentSelection);
    }

    public int open(IBatchProject batchProject, BatchArtifactType artifact, boolean artifactCanBeModified, String typeName) {
        ArrayList<BatchArtifactType> list = new ArrayList<BatchArtifactType>();
        list.add(artifact);
        return this.open(batchProject, null, false, list, artifactCanBeModified, typeName);
    }

    public int open(IBatchProject batchProject, String artifactName, boolean artifactNameCanBeModified, List<BatchArtifactType> artifacts, boolean artifactCanBeModified, String typeName) {
        this.create();
        if (artifactName != null) {
            this.getBatchPage().setArtifactName(artifactName, artifactNameCanBeModified);
        }
        if (typeName != null) {
            this.getBatchPage().setTypeName(typeName, true);
        }
        if (artifacts != null && artifacts.size() > 0) {
            this.getBatchPage().setArtifact(artifacts.get(0), artifactCanBeModified);
            IPackageFragment pack = PreferredPackageManager.getPackageSuggestion((IBatchProject)batchProject, artifacts);
            if (pack != null) {
                this.getBatchPage().setPackageFragment(pack, true);
            }
        }
        if (TestEnvironmentDetector.isTestEnvironment()) {
            this.setBlockOnOpen(false);
        }
        int code = this.open();
        if (TestEnvironmentDetector.isTestEnvironment()) {
            this.getBatchWizard().performFinish();
            this.close();
        }
        return code;
    }
}

