/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.rcp.utils;

import com.google.common.base.Optional;
import org.eclipse.jdt.internal.compiler.ast.ASTNode;
import org.eclipse.jdt.internal.compiler.lookup.ArrayBinding;
import org.eclipse.jdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.recommenders.utils.names.IMethodName;
import org.eclipse.recommenders.utils.names.ITypeName;
import org.eclipse.recommenders.utils.names.VmMethodName;
import org.eclipse.recommenders.utils.names.VmTypeName;

public final class CompilerBindings {
    public static final ASTNode UNKNOWN = new UNKNOWN();

    private CompilerBindings() {
    }

    public static Optional<ITypeName> toTypeName(TypeBinding binding) {
        if (binding == null) {
            return Optional.absent();
        }
        try {
            binding = binding.original();
            char[] signature = binding.signature();
            if (signature == null) {
                return Optional.absent();
            }
            VmTypeName result = CompilerBindings.isPrimitiveBaseType(binding) ? VmTypeName.get((String)String.valueOf(signature)) : VmTypeName.get((String)String.valueOf(signature, 0, signature.length - 1));
            return Optional.of((Object)result);
        }
        catch (RuntimeException runtimeException) {
            return Optional.absent();
        }
    }

    private static boolean isPrimitiveBaseType(TypeBinding binding) {
        if (binding.isArrayType()) {
            return ((ArrayBinding)binding).elementsType().isBaseType();
        }
        return binding.isBaseType();
    }

    public static Optional<IMethodName> toMethodName(MethodBinding binding) {
        if (binding == null) {
            return Optional.absent();
        }
        try {
            binding = binding.original();
            ITypeName declaringType = (ITypeName)CompilerBindings.toTypeName((TypeBinding)binding.declaringClass).orNull();
            if (declaringType == null) {
                return Optional.absent();
            }
            char[] name = binding.selector;
            if (name == null) {
                return Optional.absent();
            }
            char[] signature = binding.signature();
            if (signature == null) {
                return Optional.absent();
            }
            StringBuilder sb = new StringBuilder();
            sb.append(declaringType.getIdentifier()).append('.');
            sb.append(name);
            sb.append(signature);
            VmMethodName result = VmMethodName.get((String)sb.toString());
            return Optional.of((Object)result);
        }
        catch (RuntimeException runtimeException) {
            return Optional.absent();
        }
    }

    private static final class UNKNOWN
    extends ASTNode {
        private UNKNOWN() {
        }

        public StringBuffer print(int indent, StringBuffer output) {
            output.append("UNKNOWN");
            return output;
        }
    }
}

