/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.internal.rcp.news;

import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.recommenders.internal.rcp.RcpPlugin;
import org.eclipse.recommenders.internal.rcp.l10n.Messages;
import org.eclipse.recommenders.internal.rcp.news.AbstractNotificationPopup;
import org.eclipse.recommenders.utils.rcp.Browsers;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.ui.PlatformUI;

public class NewsNotificationPopup
extends AbstractNotificationPopup {
    private static final int DELAY_CLOSE_MS = 4000;
    private String message;

    public NewsNotificationPopup(String link) {
        super(PlatformUI.getWorkbench().getDisplay());
        this.setFadingEnabled(true);
        this.setDelayClose(4000L);
        this.message = link;
    }

    @Override
    protected void createContentArea(Composite composite) {
        super.createContentArea(composite);
        composite.setLayout((Layout)new GridLayout(1, true));
        Link link = new Link(composite, 64);
        link.setText(this.message);
        link.setLayoutData((Object)GridDataFactory.fillDefaults().hint(400, -1).create());
        link.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Browsers.openInExternalBrowser((String)e.text);
            }
        });
        Link optout = new Link(composite, 64);
        optout.setText(Messages.NEWS_TURN_OFF_MESSAGE);
        optout.setLayoutData((Object)GridDataFactory.fillDefaults().hint(400, -1).create());
        optout.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IEclipsePreferences prefs = RcpPlugin.getPreferences();
                prefs.putBoolean("news-enabled", false);
                NewsNotificationPopup.this.close();
            }
        });
    }

    @Override
    protected String getPopupShellTitle() {
        return Messages.NEWS_LOADING_MESSAGE;
    }
}

