/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.vpe.html.template;

import org.jboss.tools.jst.web.ui.internal.editor.preferences.VpePreference;
import org.jboss.tools.vpe.editor.context.VpePageContext;
import org.jboss.tools.vpe.editor.template.VpeAbstractTemplate;
import org.jboss.tools.vpe.editor.template.VpeCreationData;
import org.jboss.tools.vpe.xulrunner.util.XPCOM;
import org.mozilla.interfaces.nsIDOMDocument;
import org.mozilla.interfaces.nsIDOMElement;
import org.mozilla.interfaces.nsIDOMNode;
import org.mozilla.interfaces.nsIDOMText;
import org.mozilla.interfaces.nsISupports;
import org.w3c.dom.Node;

public class HtmlCommentTemplate
extends VpeAbstractTemplate {
    private static final String doubleHyphen = "--";
    private static final String COMMENT_STYLE = "font-style:italic; color:green";

    public VpeCreationData create(VpePageContext pageContext, Node sourceNode, nsIDOMDocument visualDocument) {
        nsIDOMElement visualNode;
        if ("yes".equals(VpePreference.SHOW_COMMENTS_VALUE)) {
            visualNode = visualDocument.createElement("div");
            ((nsIDOMElement)XPCOM.queryInterface((nsISupports)visualNode, nsIDOMElement.class)).setAttribute("style", COMMENT_STYLE);
            String value = sourceNode.getNodeValue();
            nsIDOMText text = visualDocument.createTextNode(value);
            ((nsIDOMElement)XPCOM.queryInterface((nsISupports)visualNode, nsIDOMElement.class)).appendChild((nsIDOMNode)text);
        } else {
            visualNode = visualDocument.createComment(this.removeDoubleHyphens(sourceNode.getNodeValue()));
        }
        return new VpeCreationData((nsIDOMNode)visualNode);
    }

    private String removeDoubleHyphens(String value) {
        StringBuilder stringBuilder = new StringBuilder("");
        while (value.indexOf(doubleHyphen) > -1) {
            stringBuilder.append(value.substring(0, value.indexOf(doubleHyphen)));
            value = value.substring(value.indexOf(doubleHyphen) + doubleHyphen.length());
        }
        stringBuilder.append(value);
        return stringBuilder.toString();
    }
}

