/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.thym.ui.plugins.internal;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.thym.core.HybridProject;
import org.eclipse.thym.core.plugin.RestorableCordovaPlugin;
import org.eclipse.thym.ui.HybridUI;
import org.eclipse.thym.ui.internal.status.StatusManager;
import org.eclipse.thym.ui.plugins.internal.PluginRestoreOperation;
import org.eclipse.thym.ui.plugins.internal.PluginRestorePage;

public class RestorePluginWizard
extends Wizard {
    private PluginRestorePage page;
    private HybridProject project;

    public RestorePluginWizard(HybridProject project) {
        this.project = project;
        this.setWindowTitle("Restore Cordova Plug-in");
        this.setDefaultPageImageDescriptor(HybridUI.getImageDescriptor("org.eclipse.thym.ui", "/icons/wizban/cordova_plugin_wiz.png"));
    }

    public void addPages() {
        this.page = new PluginRestorePage(this.project);
        this.addPage((IWizardPage)this.page);
    }

    public boolean performFinish() {
        RestorableCordovaPlugin[] restorables = this.page.getSelectedRestorables();
        try {
            this.getContainer().run(true, true, (IRunnableWithProgress)new PluginRestoreOperation(this.project, restorables));
        }
        catch (InvocationTargetException e) {
            if (e.getTargetException() != null) {
                if (e.getTargetException() instanceof CoreException) {
                    StatusManager.handle((CoreException)e.getTargetException());
                } else {
                    ErrorDialog.openError((Shell)this.getShell(), (String)"Error restoring plug-ins", null, (IStatus)new Status(4, "org.eclipse.thym.ui", "Errors occured during plug-in installation", e.getTargetException()));
                    return false;
                }
            }
            return false;
        }
        catch (InterruptedException interruptedException) {
            throw new OperationCanceledException();
        }
        return true;
    }
}

