/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.thym.ui.plugins.internal;

import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.thym.core.plugin.registry.CordovaPluginRegistryMapper;
import org.eclipse.thym.core.plugin.registry.CordovaRegistryPluginInfo;
import org.eclipse.thym.ui.plugins.internal.ControlListItem;
import org.eclipse.thym.ui.plugins.internal.CordovaPluginCatalogViewer;
import org.eclipse.thym.ui.plugins.internal.CordovaPluginWizardResources;

public class CordovaPluginInfoItem
extends ControlListItem<CordovaRegistryPluginInfo> {
    private static final int MAX_DESCRIPTION_CHARS = 162;
    private final CordovaPluginCatalogViewer viewer;
    private final CordovaPluginWizardResources resources;
    private Button checkbox;
    private boolean installed;
    private Label nameLabel;
    private Label description;
    private String nameString;
    private String descriptionText;
    private Label oldIdLabel;

    public CordovaPluginInfoItem(Composite parent, CordovaRegistryPluginInfo element, CordovaPluginWizardResources resources, CordovaPluginCatalogViewer viewer, boolean installed) {
        super(parent, 0, element);
        this.resources = resources;
        this.viewer = viewer;
        this.installed = installed;
    }

    @Override
    protected void refresh() {
        if (this.nameLabel == null) {
            this.createContent();
        }
        this.checkbox.setEnabled(!this.installed);
        if (this.installed) {
            this.nameLabel.setFont(this.resources.getSmallItalicHeaderFont());
            this.description.setFont(this.resources.getItalicFont());
        }
        this.nameLabel.setText(this.getNameString());
        this.description.setText(this.getDescriptionText());
        if (this.oldIdLabel != null) {
            this.oldIdLabel.setText(NLS.bind((String)"formerly: {0}", (Object)CordovaPluginRegistryMapper.toOld((String)((CordovaRegistryPluginInfo)this.getData()).getName())));
        }
    }

    private String getDescriptionText() {
        if (this.descriptionText == null) {
            this.descriptionText = ((CordovaRegistryPluginInfo)this.getData()).getDescription();
            if (this.descriptionText == null) {
                this.descriptionText = "";
            }
            if (this.descriptionText.length() > 162) {
                this.descriptionText = this.descriptionText.substring(0, 162);
            }
            this.descriptionText = this.descriptionText.replaceAll("(\\r\\n)|\\n|\\r", " ");
        }
        return this.descriptionText;
    }

    private String getNameString() {
        if (this.nameString != null) {
            return this.nameString;
        }
        IStructuredSelection selection = this.viewer.getSelection();
        if (selection == null || selection.isEmpty()) {
            this.checkbox.setSelection(false);
        } else {
            for (CordovaRegistryPluginInfo sel : selection) {
                if (sel != this.getData()) continue;
                this.checkbox.setSelection(true);
                break;
            }
        }
        this.nameString = this.installed ? NLS.bind((String)"{0} (installed)", (Object)((CordovaRegistryPluginInfo)this.getData()).getName()) : ((CordovaRegistryPluginInfo)this.getData()).getName();
        return this.nameString;
    }

    private void createContent() {
        GridLayout layout = new GridLayout(3, false);
        layout.marginLeft = 7;
        layout.marginTop = 2;
        this.setLayout((Layout)layout);
        Composite checkboxContainer = new Composite((Composite)this, 0);
        GridDataFactory.swtDefaults().align(0x1000000, 1).span(1, 4).applyTo((Control)checkboxContainer);
        GridLayoutFactory.fillDefaults().spacing(1, 1).numColumns(3).applyTo(checkboxContainer);
        this.checkbox = new Button(checkboxContainer, 34);
        this.checkbox.setText(" ");
        GridDataFactory.swtDefaults().align(0x1000000, 0x1000000).applyTo((Control)this.checkbox);
        this.checkbox.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                CordovaPluginInfoItem.this.viewer.modifySelection((CordovaRegistryPluginInfo)CordovaPluginInfoItem.this.getData(), CordovaPluginInfoItem.this.checkbox.getSelection());
            }
        });
        this.nameLabel = new Label((Composite)this, 0);
        GridDataFactory.fillDefaults().grab(true, false).span(2, 1).align(4, 0x1000000).applyTo((Control)this.nameLabel);
        this.nameLabel.setFont(this.resources.getSmallHeaderFont());
        this.description = new Label((Composite)this, 64);
        GridDataFactory.fillDefaults().grab(true, false).span(2, 2).hint(100, -1).applyTo((Control)this.description);
        String oldId = CordovaPluginRegistryMapper.toOld((String)((CordovaRegistryPluginInfo)this.getData()).getName());
        if (oldId != null) {
            this.oldIdLabel = new Label((Composite)this, 0);
            GridDataFactory.fillDefaults().grab(true, false).span(2, 1).align(4, 0x1000000).applyTo((Control)this.oldIdLabel);
            this.oldIdLabel.setFont(this.resources.getSubTextFont());
        }
        Label separator = new Label((Composite)this, 258);
        GridDataFactory.fillDefaults().indent(0, 2).grab(true, false).span(2, 1).align(4, 1).applyTo((Control)separator);
    }
}

