/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.thym.ui;

import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.thym.ui.PlatformImage;
import org.eclipse.thym.ui.internal.preferences.HybridToolsPreferences;
import org.eclipse.thym.ui.internal.status.HybridMobileStatusExtension;
import org.eclipse.thym.ui.plugins.internal.RestorePluginsListener;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

public class HybridUI
extends AbstractUIPlugin {
    public static final String PLUGIN_ID = "org.eclipse.thym.ui";
    private static ILog logger;
    private static HybridUI plugin;
    private final RestorePluginsListener pluginRestoreListener = new RestorePluginsListener();

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
        logger = Platform.getLog((Bundle)this.getBundle());
        IPreferenceStore store = this.getPreferenceStore();
        HybridToolsPreferences.init(store);
        store.addPropertyChangeListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                HybridToolsPreferences.getPrefs().loadValues(event);
            }
        });
        HybridToolsPreferences.getPrefs().loadValues();
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this.pluginRestoreListener, 1);
    }

    public void stop(BundleContext context) throws Exception {
        plugin = null;
        if (this.pluginRestoreListener != null) {
            ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this.pluginRestoreListener);
        }
        super.stop(context);
    }

    public static HybridUI getDefault() {
        return plugin;
    }

    public static void log(int status, String message, Throwable throwable) {
        logger.log((IStatus)new Status(status, PLUGIN_ID, message, throwable));
    }

    public static ImageDescriptor getImageDescriptor(String name, String path) {
        URL iconURL;
        Bundle bundle = Platform.getBundle((String)name);
        if (path != null && (iconURL = FileLocator.find((Bundle)bundle, (IPath)new Path(path), null)) != null) {
            return ImageDescriptor.createFromURL((URL)iconURL);
        }
        return null;
    }

    public static List<PlatformImage> getPlatformImages() {
        IConfigurationElement[] configurationElements = Platform.getExtensionRegistry().getConfigurationElementsFor("org.eclipse.thym.ui.platformImages");
        ArrayList<PlatformImage> images = new ArrayList<PlatformImage>();
        int i = 0;
        while (i < configurationElements.length) {
            PlatformImage image = new PlatformImage(configurationElements[i]);
            images.add(image);
            ++i;
        }
        return images;
    }

    public static List<HybridMobileStatusExtension> getHybridMobileStatusExtensions() {
        IConfigurationElement[] configurationElements = Platform.getExtensionRegistry().getConfigurationElementsFor("org.eclipse.thym.ui.hybridMobileStatusHandler");
        ArrayList<HybridMobileStatusExtension> handlers = new ArrayList<HybridMobileStatusExtension>();
        int i = 0;
        while (i < configurationElements.length) {
            HybridMobileStatusExtension ext = new HybridMobileStatusExtension(configurationElements[i]);
            handlers.add(ext);
            ++i;
        }
        return handlers;
    }
}

