/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.ws.creation.ui.widgets;

import javax.wsdl.Service;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.core.PackageFragment;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.SelectionDialog;
import org.eclipse.wst.command.internal.env.ui.widgets.SimpleWidgetDataContributor;
import org.eclipse.wst.command.internal.env.ui.widgets.WidgetDataEvents;
import org.jboss.tools.ws.core.utils.StatusUtils;
import org.jboss.tools.ws.creation.core.commands.WSDL2JavaHelpOptionCommand;
import org.jboss.tools.ws.creation.core.data.ServiceModel;
import org.jboss.tools.ws.creation.core.messages.JBossWSCreationCoreMessages;
import org.jboss.tools.ws.creation.core.utils.JBossWSCreationUtils;
import org.jboss.tools.ws.creation.ui.utils.JBossCreationUIUtils;
import org.jboss.tools.ws.ui.utils.JBossWSUIUtils;

public class WSDL2JavaCodeGenConfigWidget
extends SimpleWidgetDataContributor {
    private ServiceModel model;
    private IStatus status = null;
    private Button removeButton;
    private Button updateWebxmlButton;
    private Button genDefaultButton;
    private Button extensionButton;
    private Button customPacButton;
    private Button catalogButton;
    private Button additionalButton;
    private Combo serviceCombo = null;
    private Combo sourceCombo = null;
    private Combo targetCombo = null;
    private Text customPacText;
    private Text catalogText;
    private Text additionalText;
    private List bindingList;
    private boolean isOK;

    public WSDL2JavaCodeGenConfigWidget(ServiceModel model) {
        this.model = model;
    }

    public WidgetDataEvents addControls(Composite parent, final Listener statusListener) {
        Composite configCom = new Composite(parent, 0);
        GridLayout layout = new GridLayout(3, false);
        configCom.setLayout((Layout)layout);
        configCom.setLayoutData((Object)new GridData(1808));
        this.serviceCombo = JBossCreationUIUtils.createComboItem(configCom, this.model, JBossWSCreationCoreMessages.Label_Service_Name, JBossWSCreationCoreMessages.Tooltip_Service);
        this.serviceCombo.addListener(24, new Listener(){

            public void handleEvent(Event arg0) {
                Service service = (Service)WSDL2JavaCodeGenConfigWidget.this.serviceCombo.getData(WSDL2JavaCodeGenConfigWidget.this.serviceCombo.getText());
                if (service == null) {
                    return;
                }
                if (service.getPorts() == null || service.getPorts().isEmpty()) {
                    WSDL2JavaCodeGenConfigWidget.this.status = StatusUtils.errorStatus((String)JBossWSCreationCoreMessages.Error_Message_No_ServicePort);
                    statusListener.handleEvent(null);
                } else {
                    WSDL2JavaCodeGenConfigWidget.this.model.setService(service);
                }
            }
        });
        this.sourceCombo = JBossCreationUIUtils.createComboItem(configCom, this.model, JBossWSCreationCoreMessages.Label_SourceFolder_Name, JBossWSCreationCoreMessages.Tooltip_SourceFolder);
        this.sourceCombo.addListener(24, new Listener(){

            public void handleEvent(Event arg0) {
                String javaSourceFolder = WSDL2JavaCodeGenConfigWidget.this.sourceCombo.getText();
                WSDL2JavaCodeGenConfigWidget.this.model.setJavaSourceFolder(javaSourceFolder);
            }
        });
        this.customPacText = JBossCreationUIUtils.createTextItemWithButton(configCom, this.model, JBossWSCreationCoreMessages.Label_Custom_Package_Name, JBossWSCreationCoreMessages.Tooltip_Custom_Package);
        this.customPacButton = new Button(configCom, 0);
        this.customPacButton.setText(JBossWSCreationCoreMessages.Label__Browse_Button);
        this.customPacText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if ("".equals(WSDL2JavaCodeGenConfigWidget.this.customPacText.getText()) || WSDL2JavaCodeGenConfigWidget.this.validatePackage(WSDL2JavaCodeGenConfigWidget.this.customPacText.getText())) {
                    WSDL2JavaCodeGenConfigWidget.this.model.setCustomPackage(WSDL2JavaCodeGenConfigWidget.this.customPacText.getText());
                }
                statusListener.handleEvent(null);
            }
        });
        this.customPacButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                IJavaProject project = WSDL2JavaCodeGenConfigWidget.this.model.getJavaProject();
                if (project == null) {
                    return;
                }
                try {
                    SelectionDialog dialog = JavaUI.createPackageDialog(null, (IJavaProject)project, (int)32);
                    if (dialog.open() == 0 && dialog.getResult() != null && dialog.getResult().length == 1) {
                        String fqPackageName = ((PackageFragment)dialog.getResult()[0]).getElementName();
                        WSDL2JavaCodeGenConfigWidget.this.customPacText.setText(fqPackageName);
                    }
                }
                catch (JavaModelException e1) {
                    e1.printStackTrace();
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.targetCombo = JBossCreationUIUtils.createComboItem(configCom, this.model, JBossWSCreationCoreMessages.Label_JaxWS_Target, JBossWSCreationCoreMessages.Tooltip_JaxWS_Target);
        this.targetCombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                WSDL2JavaCodeGenConfigWidget.this.model.setTarget(WSDL2JavaCodeGenConfigWidget.this.targetCombo.getText());
            }
        });
        this.catalogText = JBossCreationUIUtils.createTextItemWithButton(configCom, this.model, JBossWSCreationCoreMessages.Label_Catalog_File, JBossWSCreationCoreMessages.Tooltip_Catalog_File);
        this.catalogButton = new Button(configCom, 0);
        this.catalogButton.setText(JBossWSCreationCoreMessages.Label_Add_Button);
        this.catalogButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String fileLocation = new FileDialog(Display.getCurrent().getActiveShell(), 0).open();
                WSDL2JavaCodeGenConfigWidget.this.catalogText.setText(fileLocation);
                WSDL2JavaCodeGenConfigWidget.this.model.setCatalog(fileLocation);
            }
        });
        this.createBindingFileItem(configCom);
        this.extensionButton = JBossCreationUIUtils.createCheckButton(configCom, JBossWSCreationCoreMessages.Label_EnableSOAP12_Binding_Extension);
        this.extensionButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                WSDL2JavaCodeGenConfigWidget.this.model.setEnableSOAP12(WSDL2JavaCodeGenConfigWidget.this.extensionButton.getSelection());
            }
        });
        if (this.model.getWsScenario() != 2) {
            this.genDefaultButton = JBossCreationUIUtils.createCheckButton(configCom, JBossWSCreationCoreMessages.Label_Generate_Impelemtation);
            this.genDefaultButton.setSelection(true);
            this.genDefaultButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    WSDL2JavaCodeGenConfigWidget.this.model.setGenerateImplementatoin(WSDL2JavaCodeGenConfigWidget.this.genDefaultButton.getSelection());
                    WSDL2JavaCodeGenConfigWidget.this.updateWebxmlButton.setEnabled(WSDL2JavaCodeGenConfigWidget.this.genDefaultButton.getSelection());
                    if (!WSDL2JavaCodeGenConfigWidget.this.genDefaultButton.getSelection()) {
                        WSDL2JavaCodeGenConfigWidget.this.model.setUpdateWebxml(false);
                    } else {
                        WSDL2JavaCodeGenConfigWidget.this.model.setUpdateWebxml(WSDL2JavaCodeGenConfigWidget.this.updateWebxmlButton.getSelection());
                    }
                }
            });
            this.updateWebxmlButton = JBossCreationUIUtils.createCheckButton(configCom, JBossWSCreationCoreMessages.Label_Update_Webxml);
            this.updateWebxmlButton.setSelection(true);
            this.updateWebxmlButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    WSDL2JavaCodeGenConfigWidget.this.model.setUpdateWebxml(WSDL2JavaCodeGenConfigWidget.this.updateWebxmlButton.getSelection());
                }
            });
        }
        this.additionalText = JBossCreationUIUtils.createTextItemWithButton(configCom, this.model, JBossWSCreationCoreMessages.Label_AdditionalOption_Name, JBossWSCreationCoreMessages.Tooltip_AdditionalOption);
        this.additionalButton = new Button(configCom, 0);
        this.additionalButton.setText(JBossWSCreationCoreMessages.Label_Help_Button);
        this.additionalButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String message = WSDL2JavaCodeGenConfigWidget.getAdditionalOptions(WSDL2JavaCodeGenConfigWidget.this.model);
                MessageDialog.openInformation((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)JBossWSCreationCoreMessages.AdditionalOption_Dialog_Title, (String)message);
            }
        });
        this.additionalText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (!"".equals(WSDL2JavaCodeGenConfigWidget.this.additionalText.getText())) {
                    WSDL2JavaCodeGenConfigWidget.this.model.setAddOptions(WSDL2JavaCodeGenConfigWidget.this.additionalText.getText());
                } else {
                    WSDL2JavaCodeGenConfigWidget.this.status = StatusUtils.errorStatus((String)JBossWSCreationCoreMessages.Error_Message_No_ServletName);
                    statusListener.handleEvent(null);
                }
            }
        });
        this.updateComposite();
        return this;
    }

    private void createBindingFileItem(Composite configCom) {
        Label label = new Label(configCom, 0);
        label.setText(JBossWSCreationCoreMessages.Label_Binding_File);
        label.setToolTipText(JBossWSCreationCoreMessages.Tooltip_BindingFile);
        this.bindingList = new List(configCom, 2817);
        GridData gd = new GridData(768);
        this.bindingList.setToolTipText(JBossWSCreationCoreMessages.Tooltip_BindingFile);
        gd.heightHint = Display.getCurrent().getActiveShell().getBounds().height / 4;
        gd.verticalSpan = 3;
        this.bindingList.setLayoutData((Object)gd);
        this.loadBindingFiles(this.bindingList);
        this.bindingList.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (WSDL2JavaCodeGenConfigWidget.this.bindingList.getSelectionIndex() >= 0) {
                    WSDL2JavaCodeGenConfigWidget.this.removeButton.setEnabled(true);
                } else {
                    WSDL2JavaCodeGenConfigWidget.this.removeButton.setEnabled(false);
                }
            }
        });
        Button btnSelect = new Button(configCom, 0);
        btnSelect.setText(JBossWSCreationCoreMessages.Label_Add_Button);
        btnSelect.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String fileLocation = new FileDialog(Display.getCurrent().getActiveShell(), 0).open();
                if (fileLocation != null && !WSDL2JavaCodeGenConfigWidget.this.model.getBindingFiles().contains(fileLocation)) {
                    WSDL2JavaCodeGenConfigWidget.this.bindingList.add(fileLocation);
                    WSDL2JavaCodeGenConfigWidget.this.model.addBindingFile(fileLocation);
                }
            }
        });
        new Label(configCom, 0);
        this.removeButton = new Button(configCom, 0);
        this.removeButton.setEnabled(false);
        this.removeButton.setText(JBossWSCreationCoreMessages.Label_Remove_Button);
        this.removeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                WSDL2JavaCodeGenConfigWidget.this.model.getBindingFiles().remove(WSDL2JavaCodeGenConfigWidget.this.bindingList.getSelectionIndex());
                WSDL2JavaCodeGenConfigWidget.this.bindingList.remove(WSDL2JavaCodeGenConfigWidget.this.bindingList.getSelectionIndex());
                if (WSDL2JavaCodeGenConfigWidget.this.bindingList.getSelectionIndex() == -1) {
                    WSDL2JavaCodeGenConfigWidget.this.removeButton.setEnabled(false);
                }
            }
        });
    }

    private void updateComposite() {
        boolean a = JBossWSCreationUtils.supportSOAP12((String)this.model.getWebProjectName());
        this.extensionButton.setEnabled(a);
        this.extensionButton.setSelection(a);
        this.isOK = JBossCreationUIUtils.populateServiceCombo(this.serviceCombo, this.model.getWsdlDefinition());
        if (!this.isOK) {
            this.status = StatusUtils.errorStatus((String)JBossWSCreationCoreMessages.Error_Message_No_Service);
        }
        this.isOK = JBossCreationUIUtils.populateSourceFolderCombo(this.sourceCombo, this.model.getSrcList());
        if (!this.isOK) {
            this.status = StatusUtils.errorStatus((String)JBossWSCreationCoreMessages.Error_Message_No_SourceFolder);
        }
        JBossCreationUIUtils.populateTargetCombo(this.targetCombo, this.model);
        this.customPacText.setText(this.model.getCustomPackage());
    }

    private void loadBindingFiles(List bindingList) {
        for (String fileLocation : this.model.getBindingFiles()) {
            bindingList.add(fileLocation);
        }
    }

    public static String getAdditionalOptions(ServiceModel model) {
        IStatus status = null;
        String message = JBossWSCreationCoreMessages.No_Message_AdditionalOptions_Dialog;
        WSDL2JavaHelpOptionCommand command = new WSDL2JavaHelpOptionCommand(model);
        try {
            status = command.execute(null, null);
        }
        catch (ExecutionException e) {
            status = StatusUtils.errorStatus((Throwable)e);
        }
        if (status.isOK()) {
            Thread thread = command.getThread();
            int i = 0;
            while (thread.isAlive() && i < 20) {
                ++i;
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            if (command.getHelpOptions() != null) {
                message = command.getHelpOptions();
            }
        }
        return message;
    }

    private boolean validatePackage(String name) {
        this.status = JBossWSUIUtils.validatePackageName((String)name, (IJavaElement)this.model.getJavaProject());
        return this.status == null || this.status.getSeverity() != 4;
    }

    public IStatus getStatus() {
        return this.status;
    }

    public ServiceModel getModel() {
        return this.model;
    }

    public void setModel(ServiceModel model) {
        this.model = model;
    }
}

