/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.modeling.el;

import java.math.BigDecimal;
import java.util.List;
import org.eclipse.sapphire.modeling.el.AggregateFunction;
import org.eclipse.sapphire.modeling.el.FunctionContext;
import org.eclipse.sapphire.modeling.el.FunctionResult;

public final class MaxFunction
extends AggregateFunction {
    @Override
    public String name() {
        return "Max";
    }

    @Override
    public final FunctionResult evaluate(FunctionContext context) {
        return new AggregateFunction.AggregateFunctionResult(this, context){

            @Override
            protected Object evaluate(List<Object> items) {
                BigDecimal max = null;
                for (Object item : items) {
                    if (item == null) continue;
                    BigDecimal itemAsDecimal = this.cast(item, BigDecimal.class);
                    if (max == null) {
                        max = itemAsDecimal;
                        continue;
                    }
                    if (itemAsDecimal.compareTo(max) <= 0) continue;
                    max = itemAsDecimal;
                }
                return max;
            }
        };
    }
}

