/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsp.ui.internal.hyperlink;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.jface.text.hyperlink.AbstractHyperlinkDetector;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.jface.text.hyperlink.URLHyperlink;
import org.eclipse.jst.jsp.core.internal.contentmodel.TaglibController;
import org.eclipse.jst.jsp.core.internal.contentmodel.tld.CMElementDeclarationImpl;
import org.eclipse.jst.jsp.core.internal.contentmodel.tld.TaglibTracker;
import org.eclipse.jst.jsp.core.taglib.ITLDRecord;
import org.eclipse.jst.jsp.core.taglib.TaglibIndex;
import org.eclipse.jst.jsp.ui.internal.JSPUIMessages;
import org.eclipse.jst.jsp.ui.internal.Logger;
import org.eclipse.jst.jsp.ui.internal.hyperlink.ExternalFileHyperlink;
import org.eclipse.jst.jsp.ui.internal.hyperlink.TLDFileHyperlink;
import org.eclipse.jst.jsp.ui.internal.hyperlink.TaglibJarUriHyperlink;
import org.eclipse.jst.jsp.ui.internal.hyperlink.URLFileRegionHyperlink;
import org.eclipse.jst.jsp.ui.internal.hyperlink.WorkspaceFileHyperlink;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.core.internal.provisional.IndexedRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegionCollection;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegionList;
import org.eclipse.wst.sse.core.utils.StringUtils;
import org.eclipse.wst.xml.core.internal.contentmodel.CMElementDeclaration;
import org.eclipse.wst.xml.core.internal.provisional.contentmodel.CMNodeWrapper;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMAttr;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.EntityReference;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class TaglibHyperlinkDetector
extends AbstractHyperlinkDetector {
    private final String HTTP_PROTOCOL = "http://";
    private final String JAR_PROTOCOL = "jar:file:";
    private String URN_TLD = "urn:jsptld:";
    private String XMLNS = "xmlns:";
    static final int TAG = 1;
    static final int ATTRIBUTE = 2;

    static IRegion findDefinition(IDOMModel model, String searchName, int searchType) {
        NodeList declarations = null;
        if (searchType == 1) {
            declarations = model.getDocument().getElementsByTagNameNS("*", "tag");
        } else if (searchType == 2) {
            declarations = model.getDocument().getElementsByTagNameNS("*", "attribute");
        }
        if (declarations == null || declarations.getLength() == 0) {
            if (searchType == 1) {
                declarations = model.getDocument().getElementsByTagName("tag");
            } else if (searchType == 2) {
                declarations = model.getDocument().getElementsByTagName("attribute");
            }
        }
        int i = 0;
        while (i < declarations.getLength()) {
            NodeList names = model.getDocument().getElementsByTagName("name");
            int j = 0;
            while (j < names.getLength()) {
                String name = TaglibHyperlinkDetector.getContainedText(names.item(j));
                if (searchName.compareTo(name) == 0) {
                    int start = -1;
                    int end = -1;
                    Node caret = names.item(j).getFirstChild();
                    if (caret != null) {
                        start = ((IDOMNode)caret).getStartOffset();
                    }
                    while (caret != null) {
                        end = ((IDOMNode)caret).getEndOffset();
                        caret = caret.getNextSibling();
                    }
                    if (start > 0) {
                        return new Region(start, end - start);
                    }
                }
                ++j;
            }
            ++i;
        }
        return null;
    }

    private static String getContainedText(Node parent) {
        NodeList children = parent.getChildNodes();
        if (children.getLength() == 1) {
            return children.item(0).getNodeValue().trim();
        }
        StringBuffer s = new StringBuffer();
        Node child = parent.getFirstChild();
        while (child != null) {
            if (child.getNodeType() == 5) {
                String reference = ((EntityReference)child).getNodeValue();
                if (reference == null && child.getNodeName() != null) {
                    reference = "&" + child.getNodeName() + ";";
                }
                if (reference != null) {
                    s.append(reference.trim());
                }
            } else {
                s.append(child.getNodeValue().trim());
            }
            child = child.getNextSibling();
        }
        return s.toString().trim();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public IHyperlink[] detectHyperlinks(ITextViewer textViewer, IRegion region, boolean canShowMultipleHyperlinks) {
        block24: {
            hyperlink = null;
            if (textViewer == null || region == null || (doc = textViewer.getDocument()) == null) break block24;
            try {
                partition = TextUtilities.getPartition((IDocument)doc, (String)"org.eclipse.wst.sse.core.default_structured_text_partitioning", (int)region.getOffset(), (boolean)false);
                if (partition == null || partition.getType() != "org.eclipse.jst.jsp.JSP_DIRECTIVE") break block24;
                sModel = null;
                try {
                    block26: {
                        block25: {
                            sModel = StructuredModelManager.getModelManager().getExistingModelForRead(doc);
                            currentNode = this.getCurrentNode(sModel, region.getOffset());
                            if (currentNode == null || currentNode.getNodeType() != 1) ** GOTO lbl-1000
                            baseLocationForTaglib = this.getBaseLocationForTaglib(doc);
                            if (baseLocationForTaglib == null || !"jsp:directive.taglib".equalsIgnoreCase(currentNode.getNodeName())) break block25;
                            taglibURINode = ((Element)currentNode).getAttributeNode("uri");
                            if (taglibURINode != null && (reference = TaglibIndex.resolve((String)baseLocationForTaglib, (String)taglibURINode.getValue(), (boolean)false)) != null) {
                                switch (reference.getRecordType()) {
                                    case 1: {
                                        record = (ITLDRecord)reference;
                                        uriString = record.getPath().toString();
                                        hyperlinkRegion = this.getHyperlinkRegion(taglibURINode, region);
                                        if (hyperlinkRegion == null) break;
                                        hyperlink = this.createHyperlink(uriString, hyperlinkRegion, doc, null);
                                        break;
                                    }
                                    case 2: 
                                    case 4: {
                                        hyperlinkRegion = this.getHyperlinkRegion(taglibURINode, region);
                                        if (hyperlinkRegion == null) break;
                                        hyperlink = new TaglibJarUriHyperlink(hyperlinkRegion, reference);
                                    }
                                    default: {
                                        break;
                                    }
                                }
                            }
                            ** GOTO lbl-1000
                        }
                        if (baseLocationForTaglib == null || !"jsp:root".equalsIgnoreCase(currentNode.getNodeName())) break block26;
                        attrs = currentNode.getAttributes();
                        i = 0;
                        if (true) ** GOTO lbl61
                    }
                    documentManager = TaglibController.getTLDCMDocumentManager((IDocument)doc);
                    if (documentManager == null) ** GOTO lbl-1000
                    documentTrackers = documentManager.getCMDocumentTrackers(currentNode.getPrefix(), region.getOffset());
                    i = 0;
                    if (true) ** GOTO lbl70
                    do {
                        if ((attr = (Attr)attrs.item(i)).getNodeName().startsWith(this.XMLNS)) {
                            uri = StringUtils.strip((String)attr.getNodeValue());
                            if (uri.startsWith(this.URN_TLD)) {
                                uri = uri.substring(this.URN_TLD.length());
                            }
                            if ((reference = TaglibIndex.resolve((String)baseLocationForTaglib, (String)uri, (boolean)false)) != null) {
                                switch (reference.getRecordType()) {
                                    case 1: {
                                        record = (ITLDRecord)reference;
                                        uriString = record.getPath().toString();
                                        hyperlinkRegion = this.getHyperlinkRegion(attr, region);
                                        if (hyperlinkRegion == null) break;
                                        hyperlink = this.createHyperlink(uriString, hyperlinkRegion, doc, null);
                                        break;
                                    }
                                    case 2: 
                                    case 4: {
                                        hyperlinkRegion = this.getHyperlinkRegion(attr, region);
                                        if (hyperlinkRegion == null) break;
                                        hyperlink = new TaglibJarUriHyperlink(hyperlinkRegion, reference);
                                        break;
                                    }
                                }
                            }
                        }
                        ++i;
lbl61:
                        // 2 sources

                    } while (i < attrs.getLength());
                    ** GOTO lbl-1000
                    do {
                        if ((decl = (CMElementDeclaration)(tracker = (TaglibTracker)documentTrackers.get(i)).getElements().getNamedItem(currentNode.getNodeName())) != null && (decl = (CMElementDeclaration)((CMNodeWrapper)decl).getOriginNode()) instanceof CMElementDeclarationImpl) {
                            base = ((CMElementDeclarationImpl)decl).getLocationString();
                            hyperlinkRegion = this.getHyperlinkRegion(currentNode, region);
                            if (hyperlinkRegion != null) {
                                hyperlink = this.createHyperlink(base, hyperlinkRegion, doc, currentNode);
                            }
                        }
                        ++i;
lbl70:
                        // 2 sources

                    } while (i < documentTrackers.size());
                }
                catch (Throwable var19_32) {
                    var18_33 = null;
                    if (sModel != null) {
                        sModel.releaseFromRead();
                    }
                    throw var19_32;
                }
lbl-1000:
                // 5 sources

                {
                    var18_34 = null;
                    if (sModel != null) {
                        sModel.releaseFromRead();
                    }
                }
            }
            catch (BadLocationException e) {
                Logger.log(202, e.getMessage(), e);
            }
        }
        if (hyperlink != null) {
            return new IHyperlink[]{hyperlink};
        }
        return null;
    }

    /*
     * Exception decompiling
     */
    private String getBaseLocationForTaglib(IDocument document) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 1[TRYBLOCK] [1 : 50->53)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private IRegion getHyperlinkRegion(Node node, IRegion boundingRegion) {
        Region hyperRegion = null;
        if (node != null) {
            IDOMNode docNode;
            short nodeType = node.getNodeType();
            if (nodeType == 10) {
                docNode = (IDOMNode)node;
                hyperRegion = new Region(docNode.getStartOffset(), docNode.getEndOffset() - docNode.getStartOffset());
            } else if (nodeType == 2) {
                IDOMAttr att = (IDOMAttr)node;
                int regOffset = att.getValueRegionStartOffset();
                ITextRegion valueRegion = att.getValueRegion();
                if (valueRegion != null) {
                    int regLength = valueRegion.getTextLength();
                    String attValue = att.getValueRegionText();
                    if (StringUtils.isQuoted((String)attValue)) {
                        ++regOffset;
                        regLength -= 2;
                    }
                    hyperRegion = new Region(regOffset, regLength);
                }
            }
            if (nodeType == 1 && (hyperRegion = this.getNameRegion((ITextRegionCollection)(docNode = (IDOMNode)node).getFirstStructuredDocumentRegion())) == null) {
                hyperRegion = new Region(docNode.getStartOffset(), docNode.getFirstStructuredDocumentRegion().getTextLength());
            }
        }
        if (hyperRegion != null && this.intersects((IRegion)hyperRegion, boundingRegion)) {
            return hyperRegion;
        }
        return null;
    }

    private boolean intersects(IRegion hyperlinkRegion, IRegion detectionRegion) {
        int hyperLinkStart = hyperlinkRegion.getOffset();
        int hyperLinkEnd = hyperlinkRegion.getOffset() + hyperlinkRegion.getLength();
        int detectionStart = detectionRegion.getOffset();
        int detectionEnd = detectionRegion.getOffset() + detectionRegion.getLength();
        return hyperLinkStart <= detectionStart && detectionStart < hyperLinkEnd || hyperLinkStart <= detectionEnd && detectionEnd <= hyperLinkEnd;
    }

    private IRegion getNameRegion(ITextRegionCollection containerRegion) {
        ITextRegionList regions = containerRegion.getRegions();
        ITextRegion nameRegion = null;
        int i = 0;
        while (i < regions.size()) {
            ITextRegion r = regions.get(i);
            if (r.getType() == "XML_TAG_NAME") {
                nameRegion = r;
                break;
            }
            ++i;
        }
        if (nameRegion != null) {
            return new Region(containerRegion.getStartOffset(nameRegion), nameRegion.getTextLength());
        }
        return null;
    }

    private IHyperlink createHyperlink(String uriString, IRegion hyperlinkRegion, IDocument document, Node node) {
        Object link = null;
        if (uriString != null) {
            String temp = uriString.toLowerCase();
            if (temp.startsWith("http://")) {
                link = new URLHyperlink(hyperlinkRegion, uriString);
            } else if (temp.startsWith("jar:file:")) {
                try {
                    link = new URLFileRegionHyperlink(hyperlinkRegion, 1, node.getLocalName(), new URL(uriString)){

                        public String getHyperlinkText() {
                            return JSPUIMessages.CustomTagHyperlink_hyperlinkText;
                        }
                    };
                }
                catch (MalformedURLException e) {
                    Logger.log(202, e.getMessage(), e);
                }
            } else {
                IFile file;
                Path path = new Path(uriString);
                if (path.segmentCount() > 1 && (file = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)path)).getType() == 1 && file.isAccessible()) {
                    link = node != null ? new TLDFileHyperlink((IResource)file, 1, node.getLocalName(), hyperlinkRegion){

                        public String getHyperlinkText() {
                            return JSPUIMessages.TLDHyperlink_hyperlinkText;
                        }
                    } : new WorkspaceFileHyperlink(hyperlinkRegion, file){

                        public String getHyperlinkText() {
                            return JSPUIMessages.TLDHyperlink_hyperlinkText;
                        }
                    };
                }
            }
            if (link == null) {
                File externalFile = new File(uriString);
                link = new ExternalFileHyperlink(hyperlinkRegion, externalFile){

                    public String getHyperlinkText() {
                        return JSPUIMessages.TLDHyperlink_hyperlinkText;
                    }
                };
            }
        }
        return link;
    }

    private Node getCurrentNode(IStructuredModel model, int offset) {
        IndexedRegion inode = null;
        if (model != null && (inode = model.getIndexedRegion(offset)) == null) {
            inode = model.getIndexedRegion(offset - 1);
        }
        if (inode instanceof Node) {
            return (Node)inode;
        }
        return null;
    }
}

