/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.internal.constructors.rcp;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.common.math.DoubleMath;
import java.math.RoundingMode;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.inject.Inject;
import org.eclipse.jdt.core.CompletionProposal;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.internal.codeassist.complete.CompletionOnQualifiedTypeReference;
import org.eclipse.jdt.internal.codeassist.complete.CompletionOnSingleTypeReference;
import org.eclipse.jdt.internal.compiler.ast.ASTNode;
import org.eclipse.recommenders.completion.rcp.IProposalNameProvider;
import org.eclipse.recommenders.completion.rcp.IRecommendersCompletionContext;
import org.eclipse.recommenders.completion.rcp.processable.IProcessableProposal;
import org.eclipse.recommenders.completion.rcp.processable.IProposalTag;
import org.eclipse.recommenders.completion.rcp.processable.OverlayImageProposalProcessor;
import org.eclipse.recommenders.completion.rcp.processable.ProposalProcessor;
import org.eclipse.recommenders.completion.rcp.processable.ProposalProcessorManager;
import org.eclipse.recommenders.completion.rcp.processable.ProposalTag;
import org.eclipse.recommenders.completion.rcp.processable.SessionProcessor;
import org.eclipse.recommenders.completion.rcp.processable.SimpleProposalProcessor;
import org.eclipse.recommenders.constructors.ConstructorModel;
import org.eclipse.recommenders.constructors.IConstructorModelProvider;
import org.eclipse.recommenders.internal.constructors.rcp.ConstructorsRcpPreferences;
import org.eclipse.recommenders.internal.constructors.rcp.l10n.Messages;
import org.eclipse.recommenders.internal.models.rcp.PrefetchModelArchiveJob;
import org.eclipse.recommenders.models.IModelProvider;
import org.eclipse.recommenders.models.IUniqueName;
import org.eclipse.recommenders.models.UniqueTypeName;
import org.eclipse.recommenders.models.rcp.IProjectCoordinateProvider;
import org.eclipse.recommenders.rcp.SharedImages;
import org.eclipse.recommenders.utils.Recommendation;
import org.eclipse.recommenders.utils.Recommendations;
import org.eclipse.recommenders.utils.Result;
import org.eclipse.recommenders.utils.names.IMethodName;

public class ConstructorCompletionSessionProcessor
extends SessionProcessor {
    private final ImmutableSet<Class<? extends ASTNode>> supportedCompletionRequests = ImmutableSet.of(CompletionOnSingleTypeReference.class, CompletionOnQualifiedTypeReference.class);
    private final IProjectCoordinateProvider pcProvider;
    private final IConstructorModelProvider modelProvider;
    private final IProposalNameProvider methodNameProvider;
    private final ConstructorsRcpPreferences prefs;
    private final OverlayImageProposalProcessor overlayProcessor;
    private Map<CompletionProposal, Double> recommationationsMap;

    @Inject
    public ConstructorCompletionSessionProcessor(IProjectCoordinateProvider pcProvider, IConstructorModelProvider modelProvider, IProposalNameProvider methodNameProvider, ConstructorsRcpPreferences prefs, SharedImages images) {
        this.pcProvider = Objects.requireNonNull(pcProvider);
        this.modelProvider = Objects.requireNonNull(modelProvider);
        this.methodNameProvider = Objects.requireNonNull(methodNameProvider);
        this.prefs = Objects.requireNonNull(prefs);
        this.overlayProcessor = new OverlayImageProposalProcessor(images.getDescriptor((SharedImages.ImageResource)SharedImages.Images.OVR_STAR), 0);
    }

    public boolean startSession(IRecommendersCompletionContext context) {
        ConstructorModel model;
        if (!this.isCompletionRequestSupported(context)) {
            return false;
        }
        IType expectedType = (IType)context.getExpectedType().orNull();
        if (expectedType == null) {
            return false;
        }
        Result res = this.pcProvider.tryToUniqueName(expectedType);
        switch (res.getReason()) {
            case 0: {
                model = (ConstructorModel)this.modelProvider.acquireModel((IUniqueName)((UniqueTypeName)res.get())).orNull();
                break;
            }
            case 1: {
                new PrefetchModelArchiveJob(expectedType, this.pcProvider, (IModelProvider)this.modelProvider).schedule(200L);
            }
            default: {
                return false;
            }
        }
        try {
            if (model == null) {
                return false;
            }
            Map proposals = context.getProposals();
            HashMap foundConstructors = Maps.newHashMap();
            int runningTotal = 0;
            for (Map.Entry entry : proposals.entrySet()) {
                int constructorCallCount;
                IMethodName methodName;
                CompletionProposal coreProposal = (CompletionProposal)entry.getValue();
                if (coreProposal.getKind() != 26 || (methodName = (IMethodName)this.methodNameProvider.toMethodName(coreProposal).orNull()) == null || !methodName.isInit() || (constructorCallCount = model.getConstructorCallCount(methodName)) == 0) continue;
                foundConstructors.put(coreProposal, methodName);
                runningTotal += constructorCallCount;
            }
            final int foundConstructorsTotal = runningTotal;
            if (foundConstructorsTotal == 0) {
                return false;
            }
            Iterable recommendations = Iterables.transform(foundConstructors.entrySet(), (Function)new Function<Map.Entry<CompletionProposal, IMethodName>, Recommendation<CompletionProposal>>(){

                public Recommendation<CompletionProposal> apply(Map.Entry<CompletionProposal, IMethodName> entry) {
                    IMethodName methodName = entry.getValue();
                    double relevance = (double)model.getConstructorCallCount(methodName) / (double)foundConstructorsTotal;
                    return Recommendation.newRecommendation((Object)entry.getKey(), (double)relevance);
                }
            });
            List topRecommendations = Recommendations.top((Iterable)recommendations, (int)this.prefs.maxNumberOfProposals, (double)((double)this.prefs.minProposalPercentage / 100.0));
            if (topRecommendations.isEmpty()) {
                return false;
            }
            this.recommationationsMap = Recommendations.asMap((Iterable)topRecommendations);
            return true;
        }
        finally {
            this.modelProvider.releaseModel((Object)model);
        }
    }

    public void process(IProcessableProposal proposal) throws Exception {
        int boost;
        CompletionProposal coreProposal = (CompletionProposal)proposal.getCoreProposal().orNull();
        if (coreProposal == null) {
            return;
        }
        Double relevance = this.recommationationsMap.get(coreProposal);
        if (relevance == null) {
            return;
        }
        int score = relevance < 0.01 ? DoubleMath.roundToInt((double)(relevance * 10000.0), (RoundingMode)RoundingMode.HALF_EVEN) : 100 + DoubleMath.roundToInt((double)(relevance * 100.0), (RoundingMode)RoundingMode.HALF_EVEN);
        if (score == 0) {
            return;
        }
        int n = boost = this.prefs.changeProposalRelevance ? score : 0;
        if (boost > 0) {
            proposal.setTag((IProposalTag)ProposalTag.RECOMMENDERS_SCORE, (Object)(relevance * 100.0));
        }
        String label = null;
        if (this.prefs.decorateProposalText) {
            String format = relevance < 0.01 ? Messages.PROPOSAL_LABEL_PROMILLE : Messages.PROPOSAL_LABEL_PERCENTAGE;
            label = MessageFormat.format(format, relevance);
        }
        ProposalProcessorManager manager = proposal.getProposalProcessorManager();
        if (boost != 0 || label != null) {
            manager.addProcessor((ProposalProcessor)new SimpleProposalProcessor(boost, label));
        }
        if (this.prefs.decorateProposalIcon) {
            manager.addProcessor((ProposalProcessor)this.overlayProcessor);
        }
    }

    private boolean isCompletionRequestSupported(IRecommendersCompletionContext context) {
        ASTNode node = (ASTNode)context.getCompletionNode().orNull();
        if (node == null) {
            return false;
        }
        for (Class supportedCompletionRequest : this.supportedCompletionRequests) {
            if (!supportedCompletionRequest.isInstance(node)) continue;
            return true;
        }
        return false;
    }
}

