/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.cdi.seam.text.ext.hyperlink;

import java.text.MessageFormat;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.ui.PartInitException;
import org.jboss.tools.cdi.core.CDICoreNature;
import org.jboss.tools.cdi.core.CDICorePlugin;
import org.jboss.tools.cdi.seam.config.core.CDISeamConfigExtension;
import org.jboss.tools.cdi.seam.config.core.definition.SeamBeansDefinition;
import org.jboss.tools.cdi.seam.config.core.definition.SeamFieldDefinition;
import org.jboss.tools.cdi.seam.config.core.definition.SeamMemberDefinition;
import org.jboss.tools.cdi.seam.config.core.definition.SeamMethodDefinition;
import org.jboss.tools.cdi.seam.config.core.util.Util;
import org.jboss.tools.cdi.seam.text.ext.CDISeamExtMessages;
import org.jboss.tools.common.text.ext.hyperlink.AbstractHyperlink;
import org.jboss.tools.common.text.ext.util.StructuredModelWrapper;
import org.jboss.tools.common.text.ext.util.Utils;
import org.jboss.tools.jst.web.ui.internal.text.ext.hyperlink.jsp.JSPRootHyperlinkPartitioner;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class SeamConfigTagNameHyperlink
extends AbstractHyperlink {
    protected void doHyperlink(IRegion region) {
        IFile documentFile = this.getFile();
        if (documentFile == null) {
            return;
        }
        IProject project = documentFile.getProject();
        CDICoreNature cdi = CDICorePlugin.getCDI((IProject)project, (boolean)true);
        if (cdi == null) {
            return;
        }
        String tagName = this.getTagName(region);
        if (tagName == null) {
            return;
        }
        int at = tagName.indexOf(64);
        String attrName = null;
        if (at >= 0) {
            attrName = tagName.substring(at + 1);
            tagName = tagName.substring(0, at);
        }
        String uri = this.getURI(region);
        IType element = null;
        IType type = Util.resolveType((String)tagName, (String)uri, (CDICoreNature)cdi);
        if (type != null) {
            element = type;
            if (attrName != null) {
                try {
                    if (type.isAnnotation()) {
                        IMethod m = type.getMethod(attrName, new String[0]);
                        if (m != null && m.exists()) {
                            element = m;
                        }
                    } else {
                        IField f = type.getField(attrName);
                        if (f != null && f.exists()) {
                            element = f;
                        }
                    }
                }
                catch (CoreException coreException) {}
            }
        } else {
            SeamMemberDefinition def = this.find(cdi, region, documentFile);
            if (def instanceof SeamFieldDefinition) {
                element = ((SeamFieldDefinition)def).getField();
            } else if (def instanceof SeamMethodDefinition) {
                element = ((SeamMethodDefinition)def).getMethod();
            }
        }
        if (element != null) {
            try {
                JavaUI.openInEditor((IJavaElement)element);
            }
            catch (JavaModelException javaModelException) {
            }
            catch (PartInitException partInitException) {}
        }
    }

    SeamMemberDefinition find(CDICoreNature cdi, IRegion region, IFile documentFile) {
        CDISeamConfigExtension ext = CDISeamConfigExtension.getExtension((CDICoreNature)cdi);
        if (ext == null) {
            return null;
        }
        SeamBeansDefinition def = ext.getContext().getDefinition(documentFile.getFullPath());
        if (def == null) {
            return null;
        }
        return def.findExactly(region.getOffset());
    }

    private IType resolve(IJavaProject jp, String tagName, String uri) {
        return null;
    }

    private String getURI(IRegion region) {
        return SeamConfigTagNameHyperlink.getURI(region, this.getDocument());
    }

    public static String getURI(IRegion region, IDocument document) {
        StructuredModelWrapper smw = new StructuredModelWrapper();
        smw.init(document);
        try {
            Document xmlDocument = smw.getDocument();
            if (xmlDocument == null) {
                return null;
            }
            Node n = Utils.findNodeForOffset((Node)xmlDocument, (int)region.getOffset());
            if (n instanceof Attr) {
                n = ((Attr)n).getOwnerElement();
            }
            if (!(n instanceof Element)) {
                return null;
            }
            String string = SeamConfigTagNameHyperlink.getURI(n, document, region.getOffset());
            return string;
        }
        finally {
            smw.dispose();
        }
    }

    public static String getURI(Node node, IDocument document, int offset) {
        String nodeName = node.getNodeName();
        if (nodeName.indexOf(58) == -1) {
            return null;
        }
        String nodePrefix = nodeName.substring(0, nodeName.indexOf(":"));
        if (nodePrefix == null || nodePrefix.length() == 0) {
            return null;
        }
        Map trackers = JSPRootHyperlinkPartitioner.getTrackersMap((IDocument)document, (int)offset);
        return trackers == null ? null : trackers.get(nodePrefix);
    }

    private String getTagName(IRegion region) {
        StructuredModelWrapper smw = new StructuredModelWrapper();
        smw.init(this.getDocument());
        try {
            Document xmlDocument = smw.getDocument();
            if (xmlDocument == null) {
                return null;
            }
            Node node = Utils.findNodeForOffset((Node)xmlDocument, (int)region.getOffset());
            Attr attr = null;
            Element elem = null;
            if (node instanceof Element) {
                elem = (Element)node;
            } else if (node instanceof Attr) {
                attr = (Attr)node;
                elem = attr.getOwnerElement();
            }
            if (elem == null) {
                return null;
            }
            String tagName = elem.getNodeName();
            if (tagName.indexOf(58) == -1) {
                return null;
            }
            tagName = tagName.substring(tagName.indexOf(58) + 1);
            if (attr != null) {
                tagName = String.valueOf(tagName) + "@" + attr.getName();
            }
            String string = tagName;
            return string;
        }
        finally {
            smw.dispose();
        }
    }

    public String getHyperlinkText() {
        String tagName = this.getTagName(this.getHyperlinkRegion());
        if (tagName == null) {
            return CDISeamExtMessages.CDI_SEAM_CONFIG_OPEN_TAG;
        }
        return MessageFormat.format(CDISeamExtMessages.CDI_SEAM_CONFIG_OPEN_TAG, tagName);
    }
}

