/*
 * Decompiled with CFR 0.152.
 */
package tern.eclipse.ide.ui.preferences;

import java.util.ArrayList;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import tern.eclipse.ide.core.IIDETernRepository;
import tern.eclipse.ide.core.TernCorePlugin;
import tern.eclipse.ide.internal.ui.TernUIMessages;
import tern.eclipse.ide.ui.preferences.ComboViewerFieldEditor;
import tern.eclipse.ide.ui.wizards.ImportTernRepositoryWizard;
import tern.utils.StringUtils;

public class TernRepositoryFieldEditor
extends ComboViewerFieldEditor {
    private static final int NB_BUTTONS = 1;
    private final IWorkbench workbench;
    private Button importButton;
    private Button addButton;

    public TernRepositoryFieldEditor(String name, String labelText, Composite parent, IWorkbench workbench) {
        super(name, labelText, parent);
        this.workbench = workbench;
        ArrayList<String> list = new ArrayList<String>();
        list.add(TernUIMessages.TernRepositoryFieldEditor_ternRepository_none);
        list.addAll(TernCorePlugin.getTernRepositoryManager().getRepositories());
        super.setLabelProvider((IBaseLabelProvider)IDETernRepositoryLabelProvider.INSTANCE);
        super.setInput(list);
    }

    @Override
    protected void adjustForNumColumns(int numColumns) {
        super.adjustForNumColumns(numColumns - 1);
    }

    @Override
    public int getNumberOfControls() {
        return super.getNumberOfControls() + 1;
    }

    @Override
    protected void doFillIntoGrid(Composite parent, int numColumns) {
        super.doFillIntoGrid(parent, numColumns - 1);
        this.importButton = this.getImportButtonControl(parent);
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        int widthHint = this.convertHorizontalDLUsToPixels((Control)this.importButton, 61);
        gd.widthHint = Math.max(widthHint, this.importButton.computeSize((int)-1, (int)-1, (boolean)true).x);
        this.importButton.setLayoutData((Object)gd);
    }

    protected Button getImportButtonControl(Composite parent) {
        if (this.importButton == null) {
            this.importButton = new Button(parent, 8);
            this.importButton.setText(TernUIMessages.Button_import);
            this.importButton.setFont(parent.getFont());
            this.importButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    boolean oldValid = TernRepositoryFieldEditor.this.isValid();
                    TernRepositoryFieldEditor.this.openImportDialogIfNeeded();
                    TernRepositoryFieldEditor.this.refreshValidState();
                    boolean newValid = TernRepositoryFieldEditor.this.isValid();
                    if (oldValid != newValid) {
                        TernRepositoryFieldEditor.this.fireValueChanged("field_editor_is_valid", oldValid, newValid);
                    }
                }
            });
            this.importButton.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent event) {
                    TernRepositoryFieldEditor.this.importButton = null;
                }
            });
        } else {
            this.checkParent((Control)this.importButton, parent);
        }
        return this.importButton;
    }

    protected Button getAddButtonControl(Composite parent) {
        if (this.addButton == null) {
            this.addButton = new Button(parent, 8);
            this.addButton.setText(TernUIMessages.Button_add);
            this.addButton.setFont(parent.getFont());
            this.addButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                }
            });
            this.addButton.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent event) {
                    TernRepositoryFieldEditor.this.addButton = null;
                }
            });
        } else {
            this.checkParent((Control)this.addButton, parent);
        }
        return this.addButton;
    }

    protected void fireValueChanged(String property, Object oldValue, Object newValue) {
        this.openImportDialogIfNeeded();
        super.fireValueChanged(property, oldValue, newValue);
    }

    @Override
    protected boolean checkState() {
        Object selectedRepository = this.getSelectedValue();
        if (selectedRepository == null || selectedRepository instanceof String) {
            this.showErrorMessage(TernUIMessages.TernRepositoryFieldEditor_ternRepository_err_not_selected);
            return false;
        }
        IIDETernRepository repository = (IIDETernRepository)selectedRepository;
        if (!repository.isImported()) {
            this.showErrorMessage(TernUIMessages.TernRepositoryFieldEditor_ternRepository_err_not_imported);
            return false;
        }
        this.clearErrorMessage();
        return true;
    }

    private void openImportDialogIfNeeded() {
        Object selectedRepository = this.getSelectedValue();
        if (selectedRepository == null || selectedRepository instanceof String) {
            this.importButton.setEnabled(false);
            return;
        }
        IIDETernRepository repository = (IIDETernRepository)selectedRepository;
        if (!repository.isImported()) {
            Shell shell = this.getLabelControl().getShell();
            ImportTernRepositoryWizard wizard = new ImportTernRepositoryWizard(repository);
            wizard.init(this.workbench, null);
            WizardDialog dialog = new WizardDialog(shell, (IWizard)wizard);
            dialog.open();
            if (!repository.isImported()) {
                this.importButton.setEnabled(true);
                return;
            }
            this.getViewer().refresh(true);
        }
        this.importButton.setEnabled(false);
    }

    @Override
    public void setEnabled(boolean enabled, Composite parent) {
        super.setEnabled(enabled, parent);
        this.setImportButtonEnabled(enabled);
        if (this.addButton != null) {
            this.addButton.setEnabled(enabled);
        }
    }

    private void setImportButtonEnabled(boolean enabled) {
        if (this.importButton != null) {
            if (!enabled) {
                this.importButton.setEnabled(enabled);
            } else {
                Object selectedValue = this.getSelectedValue();
                this.importButton.setEnabled(selectedValue instanceof IIDETernRepository && !((IIDETernRepository)selectedValue).isImported());
            }
        }
    }

    @Override
    protected String getPreferenceValue(Object selectedObject) {
        if (selectedObject instanceof String) {
            return "";
        }
        return ((IIDETernRepository)selectedObject).getName();
    }

    @Override
    protected Object getValueFromPreference(String preferenceValue) {
        if (StringUtils.isEmpty((String)preferenceValue)) {
            return TernUIMessages.TernRepositoryFieldEditor_ternRepository_none;
        }
        return TernCorePlugin.getTernRepositoryManager().getRepository(preferenceValue);
    }

    @Override
    protected void updateComboForValue(String value) {
        super.updateComboForValue(value);
        this.setImportButtonEnabled(true);
    }

    @Override
    public boolean isValid() {
        if (!this.getLabelControl().isEnabled()) {
            return true;
        }
        return super.isValid();
    }

    private static class IDETernRepositoryLabelProvider
    extends LabelProvider {
        public static final ILabelProvider INSTANCE = new IDETernRepositoryLabelProvider();

        private IDETernRepositoryLabelProvider() {
        }

        public String getText(Object element) {
            if (element instanceof IIDETernRepository) {
                IIDETernRepository repository = (IIDETernRepository)element;
                return repository.isImported() ? repository.getName() : String.valueOf(repository.getName()) + TernUIMessages.TernRepositoryFieldEditor_ternRepository_not_imported;
            }
            return super.getText(element);
        }
    }
}

