/*
 * Decompiled with CFR 0.152.
 */
package tern.eclipse.ide.ui.controls;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IElementComparer;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Table;
import tern.eclipse.ide.core.IIDETernProject;
import tern.eclipse.ide.core.TernCorePlugin;
import tern.eclipse.ide.internal.ui.TernUIMessages;
import tern.eclipse.ide.internal.ui.Trace;
import tern.eclipse.ide.internal.ui.controls.DependenciesPanel;
import tern.eclipse.ide.internal.ui.controls.DetailsPanel;
import tern.eclipse.ide.internal.ui.controls.OptionsPanel;
import tern.eclipse.ide.internal.ui.viewers.TernModuleVersionEditingSupport;
import tern.eclipse.ide.ui.TernUIPlugin;
import tern.eclipse.ide.ui.controls.AbstractTableBlock;
import tern.eclipse.ide.ui.viewers.TernModuleLabelProvider;
import tern.metadata.TernModuleMetadata;
import tern.repository.ITernRepository;
import tern.server.ITernModule;
import tern.server.ITernModuleConfigurable;
import tern.utils.StringUtils;
import tern.utils.TernModuleHelper;

public class TernModulesBlock
extends AbstractTableBlock {
    private static final IElementComparer TERN_MODULES_COMPARER = new IElementComparer(){

        public boolean equals(Object a, Object b) {
            return a.equals(b);
        }

        public int hashCode(Object element) {
            return element.hashCode();
        }
    };
    private final String tableLabel;
    private final IProject project;
    private final Map<String, ITernModule> ternModules = new HashMap<String, ITernModule>();
    private CheckboxTableViewer tableViewer;
    private DetailsPanel detailsPanel;
    private DependenciesPanel dependenciesPanel;
    private OptionsPanel optionsPanel;
    private TabItem optionsTabItem;
    private TabFolder tabFolder;
    private TabItem detailsTabItem;
    private Button selectDependenciesCheckbox;
    private Collection<ITernModule> checkedModules;
    private boolean checkUpdating;

    public TernModulesBlock(IProject project, String tableLabel) {
        this.project = project;
        this.tableLabel = tableLabel;
    }

    public Control createControl(Composite ancestor) {
        GridData data;
        Composite parent = new Composite(ancestor, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        parent.setLayout((Layout)layout);
        Font font = ancestor.getFont();
        parent.setFont(font);
        if (this.tableLabel != null) {
            Composite header = new Composite(parent, 0);
            data = new GridData();
            data.horizontalSpan = 2;
            header.setLayoutData((Object)data);
            header.setLayout((Layout)new GridLayout(2, false));
            Label tableLabel = new Label(header, 0);
            tableLabel.setText(this.tableLabel);
            tableLabel.setLayoutData((Object)new GridData(768));
            tableLabel.setFont(font);
            this.selectDependenciesCheckbox = new Button(header, 32);
            this.selectDependenciesCheckbox.setSelection(true);
        }
        SashForm sashForm = new SashForm(parent, 65792);
        data = new GridData(4, 4, true, true);
        sashForm.setLayoutData((Object)data);
        this.createModulesMaster((Composite)sashForm);
        this.createModulesDetails((Composite)sashForm);
        Dialog.applyDialogFont((Control)parent);
        return parent;
    }

    private void createModulesMaster(Composite ancestor) {
        Composite parent = new Composite(ancestor, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        parent.setLayout((Layout)layout);
        Font font = ancestor.getFont();
        parent.setFont(font);
        Table table = new Table(parent, 68128);
        GridData data = new GridData(1808);
        data.widthHint = 350;
        data.heightHint = 400;
        table.setLayoutData((Object)data);
        table.setFont(parent.getFont());
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        this.tableViewer = new CheckboxTableViewer(table);
        TableViewerColumn nameColumn = new TableViewerColumn((TableViewer)this.tableViewer, 0);
        nameColumn.getColumn().setWidth(180);
        nameColumn.getColumn().setResizable(true);
        nameColumn.getColumn().setText(TernUIMessages.TernModulesBlock_moduleName);
        nameColumn.getColumn().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TernModulesBlock.this.sortByName();
            }
        });
        TableViewerColumn versionColumn = new TableViewerColumn((TableViewer)this.tableViewer, 0);
        versionColumn.getColumn().setWidth(100);
        versionColumn.getColumn().setResizable(true);
        versionColumn.getColumn().setText(TernUIMessages.TernModulesBlock_moduleVersion);
        final TernModuleVersionEditingSupport versionEditiongSupport = new TernModuleVersionEditingSupport((ColumnViewer)this.tableViewer);
        versionColumn.setEditingSupport((EditingSupport)versionEditiongSupport);
        this.tableViewer.setComparer(TERN_MODULES_COMPARER);
        this.tableViewer.setLabelProvider((IBaseLabelProvider)TernModuleLabelProvider.getInstance());
        this.tableViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent e) {
                if (TernModulesBlock.this.checkUpdating) {
                    return;
                }
                try {
                    TernModuleMetadata metadata;
                    TernModulesBlock.this.checkUpdating = true;
                    ITernModule module = (ITernModule)e.getElement();
                    TernModulesBlock.this.updateCheckedModules(module, e.getChecked());
                    if (e.getChecked() && TernModulesBlock.this.isSelectDependencies() && (metadata = module.getMetadata()) != null) {
                        ITernModule dependencyModule = null;
                        for (String moduleName : metadata.getDependencies(module.getVersion())) {
                            ITernModuleConfigurable configurable;
                            dependencyModule = (ITernModule)TernModulesBlock.this.ternModules.get(moduleName);
                            if (dependencyModule == null) continue;
                            if (!TernModulesBlock.this.tableViewer.getChecked((Object)dependencyModule)) {
                                TernModulesBlock.this.tableViewer.setChecked((Object)dependencyModule, true);
                            }
                            TernModulesBlock.this.updateCheckedModules(dependencyModule, true);
                            if (!(dependencyModule instanceof ITernModuleConfigurable) || !(configurable = (ITernModuleConfigurable)dependencyModule).hasVersion()) continue;
                            String version = configurable.getModule(moduleName).getVersion();
                            versionEditiongSupport.setValue(dependencyModule, version);
                        }
                    }
                }
                finally {
                    TernModulesBlock.this.checkUpdating = false;
                }
            }
        });
        this.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent e) {
                if (!e.getSelection().isEmpty()) {
                    ITernModule module = (ITernModule)((IStructuredSelection)e.getSelection()).getFirstElement();
                    TernModulesBlock.this.refreshModule(module);
                } else {
                    TernModulesBlock.this.refreshModule(null);
                }
            }
        });
        this.restoreColumnSettings();
    }

    private void createModulesDetails(Composite parent) {
        this.tabFolder = new TabFolder(parent, 0);
        GridData data = new GridData(768);
        data.heightHint = 80;
        this.tabFolder.setLayoutData((Object)data);
        this.detailsPanel = new DetailsPanel((Composite)this.tabFolder, this.project);
        this.detailsTabItem = new TabItem(this.tabFolder, 0);
        this.detailsTabItem.setControl((Control)this.detailsPanel);
        this.detailsTabItem.setText(TernUIMessages.TernModulesBlock_detailsTabLabel);
        this.dependenciesPanel = new DependenciesPanel((Composite)this.tabFolder, this.project);
        TabItem dependenciesTabItem = new TabItem(this.tabFolder, 0);
        dependenciesTabItem.setControl((Control)this.dependenciesPanel);
        dependenciesTabItem.setText(TernUIMessages.TernModulesBlock_dependenciesTabLabel);
        this.optionsPanel = new OptionsPanel((Composite)this.tabFolder, this.project);
    }

    private void refreshModule(ITernModule module) {
        if (TernModuleHelper.hasOptions((ITernModule)module)) {
            if (this.optionsTabItem == null) {
                this.optionsTabItem = new TabItem(this.tabFolder, 0);
                this.optionsTabItem.setControl((Control)this.optionsPanel);
                this.optionsTabItem.setText(TernUIMessages.TernModulesBlock_optionsTabLabel);
            }
            this.optionsPanel.refresh(module);
        } else {
            if (this.optionsTabItem != null) {
                this.optionsTabItem.dispose();
            }
            this.optionsTabItem = null;
        }
        this.detailsPanel.refresh(module);
        this.dependenciesPanel.refresh(module);
        this.tabFolder.setSelection(this.detailsTabItem);
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.tableViewer.addSelectionChangedListener(listener);
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.tableViewer.removeSelectionChangedListener(listener);
    }

    public void addCheckStateListener(ICheckStateListener listener) {
        this.tableViewer.addCheckStateListener(listener);
    }

    public void removeCheckStateListener(ICheckStateListener listener) {
        this.tableViewer.removeCheckStateListener(listener);
    }

    private void sortByName() {
        this.tableViewer.setSorter(new ViewerSorter(){

            public int compare(Viewer viewer, Object e1, Object e2) {
                if (e1 instanceof ITernModule && e2 instanceof ITernModule) {
                    ITernModule left = (ITernModule)e1;
                    ITernModule right = (ITernModule)e2;
                    return this.getNameOrLabel(left).compareToIgnoreCase(this.getNameOrLabel(right));
                }
                return super.compare(viewer, e1, e2);
            }

            private String getNameOrLabel(ITernModule module) {
                TernModuleMetadata metadata = module.getMetadata();
                if (metadata == null) {
                    return module.getName();
                }
                return StringUtils.isEmpty((String)metadata.getLabel()) ? module.getName() : metadata.getLabel();
            }

            public boolean isSorterProperty(Object element, String property) {
                return true;
            }
        });
    }

    public void setTernModules(ITernModule[] modules) {
        this.ternModules.clear();
        ITernModule[] iTernModuleArray = modules;
        int n = modules.length;
        int n2 = 0;
        while (n2 < n) {
            ITernModule module = iTernModuleArray[n2];
            if (module instanceof ITernModuleConfigurable) {
                ITernModuleConfigurable configurable = (ITernModuleConfigurable)module;
                if (!configurable.hasVersion()) {
                    this.ternModules.put(module.getName(), module);
                } else {
                    Collection mods = configurable.getModules();
                    for (ITernModule mod : mods) {
                        this.ternModules.put(mod.getName(), module);
                    }
                }
            } else {
                this.ternModules.put(module.getName(), module);
            }
            ++n2;
        }
        this.tableViewer.setInput((Object)modules);
    }

    public Collection<ITernModule> getCheckedModules() {
        if (this.checkedModules != null) {
            return this.checkedModules;
        }
        return Collections.emptyList();
    }

    public void setCheckedModules(Collection<ITernModule> checkedModules) {
        this.checkedModules = checkedModules;
        this.tableViewer.setCheckedElements(checkedModules.toArray());
    }

    public void setCheckedModule(ITernModule module, boolean selected) {
        this.updateCheckedModules(module, selected);
        this.tableViewer.setChecked((Object)module, selected);
    }

    private void updateCheckedModules(ITernModule module, boolean checked) {
        if (checked) {
            if (!this.checkedModules.contains(module)) {
                this.checkedModules.add(module);
            }
        } else {
            this.checkedModules.remove(module);
        }
    }

    @Override
    protected void setSortColumn(int column) {
        switch (column) {
            case 1: {
                this.sortByName();
            }
        }
        super.setSortColumn(column);
    }

    @Override
    protected Table getTable() {
        return this.tableViewer.getTable();
    }

    @Override
    protected IDialogSettings getDialogSettings() {
        return TernUIPlugin.getDefault().getDialogSettings();
    }

    @Override
    protected String getQualifier() {
        return "tern.eclipse.ide.ui.modules.";
    }

    public void loadModules() {
        try {
            IIDETernProject ternProject = this.getTernProject();
            if (ternProject != null) {
                List allModules = ternProject.getAllModules();
                allModules = TernModuleHelper.groupByType((List)allModules);
                List checkedModules = TernCorePlugin.getTernRepositoryManager().getCheckedModules(ternProject, allModules);
                this.refresh(allModules, checkedModules);
            }
        }
        catch (Throwable e) {
            Trace.trace((byte)3, "Error while loading plugins.", e);
        }
    }

    public void loadModules(ITernRepository repository, String[] checkedModuleNames) {
        try {
            ArrayList<ITernModule> allModules = new ArrayList<ITernModule>(Arrays.asList(repository.getModules()));
            List groupedModules = TernModuleHelper.groupByType(allModules);
            List checkedModules = TernCorePlugin.getTernRepositoryManager().getCheckedModules(checkedModuleNames, allModules, groupedModules);
            this.refresh(groupedModules, checkedModules);
        }
        catch (Throwable e) {
            Trace.trace((byte)3, "Error while loading plugins.", e);
        }
    }

    public void refresh(Collection<ITernModule> allModules, Collection<ITernModule> checkedModules) {
        this.setTernModules(allModules.toArray(ITernModule.EMPTY_MODULE));
        this.setCheckedModules(checkedModules);
    }

    private boolean isSelectDependencies() {
        return this.selectDependenciesCheckbox != null && this.selectDependenciesCheckbox.getSelection();
    }

    public IIDETernProject getTernProject() throws CoreException {
        return this.project != null ? TernCorePlugin.getTernProject((IProject)this.project) : null;
    }

    public IProject getProject() {
        return this.project;
    }

    public void setEnabled(boolean enabled) {
        this.getTable().setEnabled(enabled);
    }

    public boolean isCheckUpdating() {
        return this.checkUpdating;
    }
}

