/*
 * Decompiled with CFR 0.152.
 */
package tern.eclipse.ide.internal.ui.descriptors.options;

import com.eclipsesource.json.JsonObject;
import com.eclipsesource.json.JsonValue;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import tern.eclipse.ide.internal.ui.TernUIMessages;
import tern.eclipse.ide.internal.ui.viewers.FilenameEditingSupport;
import tern.eclipse.ide.internal.ui.viewers.PathEditingSupport;
import tern.eclipse.ide.ui.descriptors.options.ITernModuleOptionFactory;
import tern.eclipse.ide.ui.dialogs.OpenResourceDialog;
import tern.eclipse.ide.ui.viewers.JsonContentProvider;
import tern.eclipse.ide.ui.viewers.JsonLabelProvider;
import tern.eclipse.ide.ui.viewers.MemberWrapper;
import tern.metadata.TernModuleMetadataOption;
import tern.server.protocol.JsonHelper;

public class PathArrayTernModuleOptionFactory
implements ITernModuleOptionFactory {
    @Override
    public void createOption(final Composite ancestor, final IProject project, TernModuleMetadataOption metadata, final JsonObject options) {
        String name = metadata.getName();
        Label title = new Label(ancestor, 0);
        title.setText("fill mappings of filename/path.");
        title.setLayoutData((Object)new GridData(768));
        final JsonObject pathsOption = this.getPathsOption(name, options);
        Composite parent = new Composite(ancestor, 0);
        parent.setLayout((Layout)new GridLayout(2, false));
        GridData data = new GridData(1808);
        data.horizontalSpan = 2;
        parent.setLayoutData((Object)data);
        final TableViewer viewer = new TableViewer(parent, 68354);
        TableViewerColumn filenameColumn = new TableViewerColumn(viewer, 0);
        filenameColumn.getColumn().setWidth(100);
        filenameColumn.getColumn().setResizable(true);
        filenameColumn.getColumn().setText(TernUIMessages.FinderTernModuleOptionFactory_paths_filenameColumn);
        filenameColumn.setEditingSupport((EditingSupport)new FilenameEditingSupport((ColumnViewer)viewer));
        TableViewerColumn pathColumn = new TableViewerColumn(viewer, 0);
        pathColumn.getColumn().setWidth(180);
        pathColumn.getColumn().setResizable(true);
        pathColumn.getColumn().setText(TernUIMessages.TernModuleOptionsPanel_paths_pathColumn);
        pathColumn.setEditingSupport((EditingSupport)new PathEditingSupport((ColumnViewer)viewer));
        viewer.setLabelProvider((IBaseLabelProvider)JsonLabelProvider.getInstance());
        viewer.setContentProvider((IContentProvider)JsonContentProvider.getInstance());
        Table table = viewer.getTable();
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        data = new GridData(1808);
        data.heightHint = 100;
        table.setLayoutData((Object)data);
        viewer.setInput((Object)pathsOption);
        Composite toolbarComposite = new Composite(parent, 0);
        toolbarComposite.setLayout((Layout)new GridLayout());
        toolbarComposite.setLayoutData((Object)new GridData(1808));
        Button addButton = new Button(toolbarComposite, 8);
        addButton.setText(TernUIMessages.Button_add);
        addButton.setLayoutData((Object)new GridData(768));
        addButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                OpenResourceDialog dialog = new OpenResourceDialog(ancestor.getShell(), true, (IContainer)project, 1);
                if (dialog.open() != 0) {
                    return;
                }
                Object[] results = dialog.getResult();
                if (results != null && results.length > 0) {
                    IFile file = (IFile)results[0];
                    String fileName = this.getPath(file.getName());
                    String path = file.getProjectRelativePath().toString();
                    String base = null;
                    JsonValue baseURL = options.get("baseURL");
                    if (baseURL != null && baseURL.isString()) {
                        base = JsonHelper.getString((JsonValue)baseURL);
                    }
                    if (base != null) {
                        path = file.getProjectRelativePath().makeRelativeTo((IPath)new Path(base)).toString();
                    }
                    path = this.getPath(path);
                    pathsOption.set(fileName, path);
                    viewer.refresh();
                }
            }

            private String getPath(String name) {
                int index = name.lastIndexOf(".");
                if (index != -1) {
                    return name.substring(0, index);
                }
                return name;
            }
        });
        final Button removeButton = new Button(toolbarComposite, 8);
        removeButton.setText(TernUIMessages.Button_remove);
        removeButton.setLayoutData((Object)new GridData(768));
        removeButton.setEnabled(false);
        removeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IStructuredSelection selection = (IStructuredSelection)viewer.getSelection();
                if (!selection.isEmpty()) {
                    for (Object element : selection) {
                        pathsOption.remove(((MemberWrapper)element).getName());
                    }
                    viewer.refresh();
                    removeButton.setEnabled(false);
                }
            }
        });
        viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent e) {
                removeButton.setEnabled(true);
            }
        });
    }

    private JsonObject getPathsOption(String name, JsonObject options) {
        JsonValue pathsOption = options.get(name);
        if (pathsOption == null || !(pathsOption instanceof JsonObject)) {
            pathsOption = new JsonObject();
            options.set(name, pathsOption);
        }
        return (JsonObject)pathsOption;
    }
}

