/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.thym.core.engine;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.thym.core.engine.HybridMobileLibraryResolver;
import org.eclipse.thym.core.engine.internal.cordova.CordovaEngineProvider;

public class HybridMobileEngine {
    private String id;
    private String name;
    private String version;
    private IPath location;
    private HybridMobileLibraryResolver resolver;

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public HybridMobileLibraryResolver getResolver() {
        return this.resolver;
    }

    public void setResolver(HybridMobileLibraryResolver resolver) {
        this.resolver = resolver;
    }

    public IPath getLocation() {
        return this.location;
    }

    public void setLocation(IPath location) {
        this.location = location;
    }

    public boolean isManaged() {
        return this.getLocation() == null || CordovaEngineProvider.getLibFolder().isPrefixOf(this.getLocation());
    }

    public IStatus isLibraryConsistent() {
        return this.resolver.isLibraryConsistent();
    }

    public void preCompile(IProgressMonitor monitor) throws CoreException {
        if (this.resolver.needsPreCompilation()) {
            this.resolver.preCompile(monitor);
        }
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof HybridMobileEngine)) {
            return false;
        }
        HybridMobileEngine that = (HybridMobileEngine)obj;
        if (this.getId().equals(that.getId()) && this.getVersion().equals(that.getVersion())) {
            return true;
        }
        return super.equals(obj);
    }

    public int hashCode() {
        if (this.getId() != null && this.getVersion() != null) {
            return this.getId().hashCode() + this.getVersion().hashCode();
        }
        return super.hashCode();
    }

    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + "[ id: " + this.getId() + " version: " + this.getVersion() + " ]";
    }
}

