/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.maven.project.examples.wizard;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.jface.dialogs.DialogSettings;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jst.j2ee.web.project.facet.WebFacetUtils;
import org.eclipse.m2e.core.internal.MavenPluginActivator;
import org.eclipse.m2e.core.ui.internal.M2EUIPluginActivator;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.common.project.facet.core.runtime.RuntimeManager;
import org.eclipse.wst.server.core.IRuntime;
import org.eclipse.wst.server.core.IRuntimeLifecycleListener;
import org.eclipse.wst.server.core.ServerCore;
import org.eclipse.wst.server.core.internal.facets.FacetUtil;
import org.jboss.ide.eclipse.as.core.util.RuntimeUtils;
import org.jboss.jdf.stacks.model.Archetype;
import org.jboss.jdf.stacks.model.ArchetypeVersion;
import org.jboss.jdf.stacks.model.Runtime;
import org.jboss.jdf.stacks.model.Stacks;
import org.jboss.tools.maven.core.MavenCoreActivator;
import org.jboss.tools.maven.core.settings.MavenSettingsChangeListener;
import org.jboss.tools.maven.project.examples.MavenProjectExamplesActivator;
import org.jboss.tools.maven.project.examples.Messages;
import org.jboss.tools.maven.project.examples.internal.stacks.StacksArchetypeUtil;
import org.jboss.tools.maven.project.examples.utils.MavenArtifactHelper;
import org.jboss.tools.maven.project.examples.wizard.MavenExamplesRequirementsPage;
import org.jboss.tools.project.examples.fixes.AbstractRuntimeFix;
import org.jboss.tools.project.examples.fixes.IDownloadRuntimeProvider;
import org.jboss.tools.project.examples.fixes.IProjectExamplesFix;
import org.jboss.tools.project.examples.model.ArchetypeModel;
import org.jboss.tools.project.examples.model.ProjectExampleWorkingCopy;
import org.jboss.tools.runtime.core.RuntimeCoreActivator;
import org.jboss.tools.runtime.core.model.DownloadRuntime;
import org.jboss.tools.stacks.core.model.StacksUtil;

public class NewProjectExamplesStacksRequirementsPage
extends MavenExamplesRequirementsPage {
    private static final String PAGE_NAME = "org.jboss.tools.project.examples.stacksrequirements";
    private static final String TARGET_RUNTIME = "targetRuntime";
    private Map<ArchetypeVersion, IStatus> enterpriseRepoStatusMap = new HashMap<ArchetypeVersion, IStatus>();
    private Archetype stacksArchetype;
    private ArchetypeVersion version;
    private Button useBlankArchetype;
    private Stacks stacks;
    private IRuntimeLifecycleListener listener;
    private Combo serverTargetCombo;
    private Map<String, IRuntime> serverRuntimes;
    private String stacksType;
    private EnterpriseRepoCheckJob job;
    private boolean exampleInitialized;
    protected static final int MAX_HISTORY = 15;
    protected IDialogSettings dialogSettings;
    private Map<String, List<Combo>> fieldsWithHistory = new HashMap<String, List<Combo>>();
    private boolean isHistoryLoaded = false;

    public NewProjectExamplesStacksRequirementsPage() {
        this(null);
    }

    public NewProjectExamplesStacksRequirementsPage(ProjectExampleWorkingCopy projectExample) {
        super(PAGE_NAME, projectExample);
        this.stacks = MavenProjectExamplesActivator.getDefault().getCachedStacks();
        this.initDialogSettings();
    }

    @Override
    public String getProjectExampleType() {
        return "mavenArchetype";
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
    }

    @Override
    public void setProjectExample(ProjectExampleWorkingCopy example) {
        this.exampleInitialized = false;
        if (example != null) {
            this.projectExample = example;
            super.setProjectExample(this.projectExample);
            this.stacksType = this.projectExample.getStacksType();
            if (this.stacksType == null) {
                String stacksId = this.projectExample.getStacksId();
                this.stacksArchetype = StacksUtil.getArchetype((String)stacksId, (Stacks)this.stacks);
            }
            this.setArchetypeVersion();
            this.wizardContext.setProperty("enterprise", (Object)this.isEnterpriseTargetRuntime());
            this.exampleInitialized = true;
            this.validateEnterpriseRepo();
        }
    }

    private void setArchetypeVersion() {
        this.version = null;
        ArchetypeModel mavenArchetype = null;
        StringBuilder description = new StringBuilder();
        StacksArchetypeUtil stacksArchetypeUtil = new StacksArchetypeUtil();
        if (this.useBlankArchetype != null) {
            this.useBlankArchetype.setVisible(false);
        }
        if (this.stacksType == null && this.stacksArchetype == null) {
            description.append(this.projectExample.getDescription());
        } else {
            String exampleDescription;
            boolean useBlank = this.useBlankArchetype != null && !this.useBlankArchetype.isDisposed() && this.useBlankArchetype.getSelection();
            IRuntime wtpRuntime = this.getSelectedRuntime();
            Archetype stArch = null;
            if (this.stacksType != null) {
                this.version = stacksArchetypeUtil.getArchetype(this.stacksType, useBlank, wtpRuntime, this.stacks);
                if (this.version != null) {
                    stArch = this.version.getArchetype();
                }
            }
            if (stArch == null) {
                List compatibleVersions;
                Runtime stacksRuntime;
                String stacksId = this.projectExample.getStacksId();
                this.stacksArchetype = StacksUtil.getArchetype((String)stacksId, (Stacks)this.stacks);
                Archetype archetype = stArch = useBlank && this.stacksArchetype != null && this.stacksArchetype.getBlank() != null ? this.stacksArchetype.getBlank() : this.stacksArchetype;
                if (stArch != null && wtpRuntime != null && wtpRuntime.getRuntimeType() != null && (stacksRuntime = StacksArchetypeUtil.getRuntimeFromWtp(this.stacks, wtpRuntime)) != null && (compatibleVersions = StacksUtil.getCompatibleArchetypeVersions((Archetype)stArch, (Runtime)stacksRuntime)) != null && !compatibleVersions.isEmpty()) {
                    this.version = (ArchetypeVersion)compatibleVersions.get(0);
                }
            }
            if (this.version == null && stArch != null) {
                this.version = StacksUtil.getDefaultArchetypeVersion(stArch, (Stacks)this.stacks);
            }
            if ((exampleDescription = this.projectExample.getDescription()) == null || exampleDescription.trim().isEmpty()) {
                String archetypeDescription;
                String string = archetypeDescription = this.version == null ? null : this.version.getArchetype().getDescription();
                if (archetypeDescription == null || archetypeDescription.trim().isEmpty()) {
                    description.append("No description available");
                } else {
                    description.append(archetypeDescription);
                }
            } else {
                description.append(exampleDescription);
            }
            try {
                if (this.version != null) {
                    mavenArchetype = this.createArchetypeModel(this.projectExample.getArchetypeModel(), this.version);
                    boolean hasBlank = stacksArchetypeUtil.hasBlankArchetype(this.version, wtpRuntime, this.stacks);
                    if (this.useBlankArchetype != null) {
                        this.useBlankArchetype.setVisible(hasBlank);
                    }
                    this.projectExample.setArchetypeModel(mavenArchetype);
                }
            }
            catch (CloneNotSupportedException e) {
                e.printStackTrace();
            }
        }
        if (mavenArchetype == null) {
            mavenArchetype = this.projectExample.getArchetypeModel();
        }
        this.wizardContext.setProperty("archetypeModel", (Object)mavenArchetype);
        if (mavenArchetype != null) {
            description.append("\r\n").append("\r\n").append("Project based on the ").append(mavenArchetype.getGAV()).append(" Maven archetype");
        }
        this.setDescriptionText(description.toString());
    }

    private IRuntime getSelectedRuntime() {
        if (this.serverTargetCombo != null && !this.serverTargetCombo.isDisposed()) {
            String wtpServerId = this.serverTargetCombo.getText();
            return this.serverRuntimes.get(wtpServerId);
        }
        return null;
    }

    private ArchetypeModel createArchetypeModel(ArchetypeModel archetypeModel, ArchetypeVersion archetypeVersion) throws CloneNotSupportedException {
        ArchetypeModel a = (ArchetypeModel)archetypeModel.clone();
        a.setArchetypeArtifactId(archetypeVersion.getArchetype().getArtifactId());
        a.setArchetypeGroupId(archetypeVersion.getArchetype().getGroupId());
        a.setArchetypeVersion(archetypeVersion.getVersion());
        a.setArchetypeRepository(archetypeVersion.getRepositoryURL());
        return a;
    }

    protected void setSelectionArea(Composite composite) {
        this.useBlankArchetype = new Button(composite, 32);
        GridData gd = new GridData(1, 4, true, false, 2, 1);
        gd.verticalAlignment = 128;
        this.useBlankArchetype.setLayoutData((Object)gd);
        this.useBlankArchetype.setText("Create a blank project");
        this.useBlankArchetype.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                NewProjectExamplesStacksRequirementsPage.this.setArchetypeVersion();
                NewProjectExamplesStacksRequirementsPage.this.validateEnterpriseRepo();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        this.listener = new IRuntimeLifecycleListener(){

            public void runtimeRemoved(IRuntime runtime) {
                this.runInUIThread();
            }

            public void runtimeChanged(IRuntime runtime) {
                this.runInUIThread();
            }

            public void runtimeAdded(IRuntime runtime) {
                this.runInUIThread();
            }

            private void runInUIThread() {
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        NewProjectExamplesStacksRequirementsPage.this.configureRuntimeCombo();
                    }
                });
            }
        };
        ServerCore.addRuntimeLifecycleListener((IRuntimeLifecycleListener)this.listener);
        this.createServerTargetComposite(composite);
    }

    public void setVisible(boolean visible) {
        if (visible) {
            if (this.useBlankArchetype != null) {
                this.useBlankArchetype.getParent().layout(true);
            }
            if (!this.isHistoryLoaded) {
                this.loadInputHistory();
                this.isHistoryLoaded = true;
            } else {
                this.saveInputHistory();
            }
            this.wizardContext.setProperty("enterprise", (Object)this.isEnterpriseTargetRuntime());
        }
        super.setVisible(visible);
    }

    protected void createServerTargetComposite(Composite composite) {
        Composite parent = new Composite(composite, 0);
        parent.setLayout((Layout)new GridLayout(2, false));
        parent.setLayoutData((Object)new GridData(4, 128, true, false, 2, 1));
        Label serverTargetLabel = new Label(parent, 0);
        serverTargetLabel.setText(Messages.ArchetypeExamplesWizardFirstPage_Target_Runtime_Label);
        GridData gridData = new GridData(4, 128, true, false, 1, 1);
        this.serverTargetCombo = new Combo(parent, 2056);
        this.serverTargetCombo.setLayoutData((Object)gridData);
        this.serverTargetCombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (NewProjectExamplesStacksRequirementsPage.this.isCurrentPage()) {
                    NewProjectExamplesStacksRequirementsPage.this.setArchetypeVersion();
                    NewProjectExamplesStacksRequirementsPage.this.wizardContext.setProperty("enterprise", (Object)NewProjectExamplesStacksRequirementsPage.this.isEnterpriseTargetRuntime());
                }
                NewProjectExamplesStacksRequirementsPage.this.validateEnterpriseRepo();
            }
        });
        this.configureRuntimeCombo();
    }

    public boolean isEnterpriseTargetRuntime() {
        if (this.serverTargetCombo == null) {
            return false;
        }
        String serverId = this.serverTargetCombo.getText();
        IRuntime runtime = this.serverRuntimes.get(serverId);
        return runtime != null && RuntimeUtils.isEAP((IRuntime)runtime);
    }

    protected void configureRuntimeCombo() {
        if (this.serverTargetCombo == null || this.serverTargetCombo.isDisposed()) {
            return;
        }
        int i = 0;
        int selectedRuntimeIdx = 0;
        String lastUsedRuntime = this.dialogSettings.get(TARGET_RUNTIME);
        this.serverRuntimes = this.getServerRuntimes(WebFacetUtils.WEB_30);
        this.serverTargetCombo.removeAll();
        this.serverTargetCombo.add(Messages.ArchetypeExamplesWizardFirstPage_No_TargetRuntime);
        for (Map.Entry<String, IRuntime> entry : this.serverRuntimes.entrySet()) {
            this.serverTargetCombo.add(entry.getKey());
            ++i;
            IRuntime runtime = entry.getValue();
            if (lastUsedRuntime == null || !lastUsedRuntime.equals(runtime.getId())) continue;
            selectedRuntimeIdx = i;
        }
        if (selectedRuntimeIdx > 0) {
            this.serverTargetCombo.select(selectedRuntimeIdx);
        }
    }

    protected Map<String, IRuntime> getServerRuntimes(IProjectFacetVersion facetVersion) {
        Set runtimesSet = facetVersion == null ? RuntimeManager.getRuntimes() : RuntimeManager.getRuntimes(Collections.singleton(facetVersion));
        LinkedHashMap<String, IRuntime> runtimesMap = new LinkedHashMap<String, IRuntime>();
        for (org.eclipse.wst.common.project.facet.core.runtime.IRuntime r : runtimesSet) {
            IRuntime serverRuntime = FacetUtil.getRuntime((org.eclipse.wst.common.project.facet.core.runtime.IRuntime)r);
            if (serverRuntime == null) continue;
            runtimesMap.put(r.getLocalizedName(), serverRuntime);
        }
        return runtimesMap;
    }

    @Override
    protected void validateEnterpriseRepo() {
        this.stopMavenRepoCheckJob();
        if (this.exampleInitialized && this.warningComponent != null) {
            this.warningComponent.setLinkText("");
            Set<String> reqDeps = StacksArchetypeUtil.getRequiredDependencies(this.version);
            if (reqDeps == null || reqDeps.isEmpty()) {
                return;
            }
            if (!this.isEnterpriseTargetRuntime() && Boolean.TRUE.equals(this.wizardContext.getProperty("hasEnterpriseProperty"))) {
                return;
            }
            this.warningComponent.setLinkText(Messages.NewProjectExamplesStacksRequirementsPage_Checking_Enterprise_Maven_Repo_Availability, false);
            IStatus enterpriseRepoStatus = this.enterpriseRepoStatusMap.get(this.version);
            if (enterpriseRepoStatus != null) {
                this.updateWarningComponent(enterpriseRepoStatus);
                return;
            }
            this.job = new EnterpriseRepoCheckJob();
            this.job.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

                public void done(IJobChangeEvent event) {
                    if (NewProjectExamplesStacksRequirementsPage.this.job.isCancelled()) {
                        return;
                    }
                    NewProjectExamplesStacksRequirementsPage.this.enterpriseRepoStatusMap.put(NewProjectExamplesStacksRequirementsPage.this.version, NewProjectExamplesStacksRequirementsPage.this.job.getCheckResult());
                    final IStatus status = event.getResult().isOK() ? NewProjectExamplesStacksRequirementsPage.this.job.getCheckResult() : event.getResult();
                    Display.getDefault().syncExec(new Runnable(){

                        @Override
                        public void run() {
                            NewProjectExamplesStacksRequirementsPage.this.updateWarningComponent(status);
                        }
                    });
                }
            });
            this.job.schedule();
        }
    }

    private void stopMavenRepoCheckJob() {
        if (this.job != null) {
            this.job.cancel();
        }
    }

    private void updateWarningComponent(IStatus status) {
        if (status == null || status.isOK()) {
            this.warningComponent.setRepositoryUrls(null);
            this.warningComponent.setLinkText("");
        } else {
            this.warningComponent.setRepositoryUrls(StacksArchetypeUtil.getAdditionalRepositories(this.version));
            this.warningComponent.setLinkText(status.getMessage());
        }
        this.wizardContext.setProperty("enterpriseRepoStatus", (Object)status);
    }

    @Override
    public void dispose() {
        IRuntime lastUsedRuntime;
        if (this.dialogSettings != null && this.serverRuntimes != null && this.serverTargetCombo != null && (lastUsedRuntime = this.serverRuntimes.get(this.serverTargetCombo.getText())) != null) {
            this.dialogSettings.put(TARGET_RUNTIME, lastUsedRuntime.getId());
        }
        if (this.listener != null) {
            ServerCore.removeRuntimeLifecycleListener((IRuntimeLifecycleListener)this.listener);
            this.listener = null;
        }
        this.stopMavenRepoCheckJob();
        this.job = null;
        this.enterpriseRepoStatusMap.clear();
        MavenCoreActivator.getDefault().unregisterMavenSettingsChangeListener((MavenSettingsChangeListener)this);
        this.saveInputHistory();
        super.dispose();
    }

    private void initDialogSettings() {
        Object pluginSettings = MavenPluginActivator.getDefault() == null ? new DialogSettings("Workbench") : M2EUIPluginActivator.getDefault().getDialogSettings();
        this.dialogSettings = pluginSettings.getSection(this.getName());
        if (this.dialogSettings == null) {
            this.dialogSettings = pluginSettings.addNewSection(this.getName());
            pluginSettings.addSection(this.dialogSettings);
        }
    }

    private void loadInputHistory() {
        for (Map.Entry<String, List<Combo>> e : this.fieldsWithHistory.entrySet()) {
            String id = e.getKey();
            String[] items = this.dialogSettings.getArray(id);
            if (items == null) continue;
            for (Combo combo : e.getValue()) {
                String text = combo.getText();
                combo.setItems(items);
                if (text.length() <= 0) continue;
                combo.setText(text);
            }
        }
    }

    private void saveInputHistory() {
        for (Map.Entry<String, List<Combo>> e : this.fieldsWithHistory.entrySet()) {
            Combo combo2;
            String id = e.getKey();
            LinkedHashSet<String> history = new LinkedHashSet<String>(15);
            for (Combo combo2 : e.getValue()) {
                String lastValue = combo2.getText();
                if (lastValue == null || lastValue.trim().length() <= 0) continue;
                history.add(lastValue);
            }
            combo2 = e.getValue().iterator().next();
            String[] items = combo2.getItems();
            int j = 0;
            while (j < items.length && history.size() < 15) {
                history.add(items[j]);
                ++j;
            }
            this.dialogSettings.put(id, history.toArray(new String[history.size()]));
        }
    }

    protected void addFieldWithHistory(String id, Combo combo) {
        if (combo != null) {
            List<Combo> combos = this.fieldsWithHistory.get(id);
            if (combos == null) {
                combos = new ArrayList<Combo>();
                this.fieldsWithHistory.put(id, combos);
            }
            combos.add(combo);
        }
    }

    @Override
    public void onSettingsChanged() {
        this.resetRepoValidation();
    }

    public void onWizardContextChange(String key, Object value) {
        if ("hasEnterpriseProperty".equals(key)) {
            this.resetRepoValidation();
        } else {
            super.onWizardContextChange(key, value);
        }
    }

    private void resetRepoValidation() {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                NewProjectExamplesStacksRequirementsPage.this.enterpriseRepoStatusMap.clear();
                NewProjectExamplesStacksRequirementsPage.this.validateEnterpriseRepo();
            }
        });
    }

    protected IProjectExamplesFix getSelectedProjectFix() {
        IProjectExamplesFix fix = super.getSelectedProjectFix();
        if (fix instanceof AbstractRuntimeFix) {
            return new StacksBasedRuntimeFix((AbstractRuntimeFix)fix);
        }
        return fix;
    }

    public class EnterpriseRepoCheckJob
    extends Job {
        private boolean cancelled;
        private IStatus checkResult;

        public EnterpriseRepoCheckJob() {
            super(Messages.NewProjectExamplesStacksRequirementsPage_Check_Maven_Repo_Job);
        }

        protected IStatus run(IProgressMonitor monitor) {
            this.checkResult = MavenArtifactHelper.checkRequirementsAvailable(NewProjectExamplesStacksRequirementsPage.this.version);
            return Status.OK_STATUS;
        }

        protected void canceling() {
            this.cancelled = true;
            super.canceling();
        }

        boolean isCancelled() {
            return this.cancelled;
        }

        IStatus getCheckResult() {
            return this.checkResult;
        }
    }

    private class StacksBasedRuntimeFix
    implements IProjectExamplesFix,
    IDownloadRuntimeProvider {
        private AbstractRuntimeFix delegate;

        StacksBasedRuntimeFix(AbstractRuntimeFix delegate) {
            this.delegate = delegate;
        }

        public boolean isSatisfied() {
            return this.delegate.isSatisfied();
        }

        public boolean fix(IProgressMonitor monitor) {
            return this.delegate.fix(monitor);
        }

        public Collection<DownloadRuntime> getDownloadRuntimes(IProgressMonitor monitor) {
            List stacksRuntimes = StacksUtil.getCompatibleServerRuntimes((Archetype)NewProjectExamplesStacksRequirementsPage.this.stacksArchetype, (Stacks)NewProjectExamplesStacksRequirementsPage.this.stacks);
            if (stacksRuntimes != null && !stacksRuntimes.isEmpty()) {
                ArrayList<DownloadRuntime> downloadableRuntimes = new ArrayList<DownloadRuntime>(stacksRuntimes.size());
                for (Runtime r : stacksRuntimes) {
                    DownloadRuntime dr = RuntimeCoreActivator.getDefault().findDownloadRuntime(r.getId(), monitor);
                    if (dr == null) {
                        String downloadUrl = StacksUtil.isEnterprise((Runtime)r) ? null : r.getUrl();
                        dr = new DownloadRuntime(r.getId(), r.getName(), r.getVersion(), downloadUrl);
                        dr.setDisclaimer(!StacksUtil.isEnterprise((Runtime)r));
                        dr.setHumanUrl(r.getUrl());
                    }
                    downloadableRuntimes.add(dr);
                }
                return downloadableRuntimes;
            }
            return this.delegate.getDownloadRuntimes(monitor);
        }

        public String getType() {
            return this.delegate.getType();
        }

        public String getDescription() {
            return this.delegate.getDescription();
        }

        public String getLabel() {
            return this.delegate.getLabel();
        }

        public boolean isRequired() {
            return this.delegate.isRequired();
        }
    }
}

