/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.runtime.ui.internal.wizard.workflow;

import java.lang.reflect.InvocationTargetException;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.jboss.tools.foundation.ui.credentials.ChooseCredentialComposite;
import org.jboss.tools.foundation.ui.credentials.ICredentialCompositeListener;
import org.jboss.tools.foundation.ui.util.BrowserUtility;
import org.jboss.tools.foundation.ui.util.FormDataUtility;
import org.jboss.tools.foundation.ui.xpl.taskwizard.IWizardHandle;
import org.jboss.tools.foundation.ui.xpl.taskwizard.WizardFragment;
import org.jboss.tools.runtime.core.model.DownloadRuntime;
import org.jboss.tools.runtime.ui.DownloadRuntimeMessages;
import org.jboss.tools.runtime.ui.RuntimeUIActivator;
import org.jboss.tools.runtime.ui.internal.wizard.workflow.DownloadManagerWorkflowUtility;

public class DownloadManagerCredentialsFragment
extends WizardFragment {
    public static final String WORKFLOW_NEXT_STEP_KEY = "WORKFLOW_NEXT_STEP_KEY";
    private String JBOSS_ORG_SIGNUP_URL = "https://community.jboss.org/register.jspa";
    private static final String DOWNLOAD_RUNTIME_SECTION = "downloadRuntimeSection";
    private IDialogSettings downloadRuntimeSection;
    private IWizardHandle handle;
    private int headerResponse = -1;
    private WizardFragment nextWorkflowFragment = null;
    private ChooseCredentialComposite chooseCredentialComposite;

    public DownloadManagerCredentialsFragment() {
        IDialogSettings dialogSettings = RuntimeUIActivator.getDefault().getDialogSettings();
        this.downloadRuntimeSection = dialogSettings.getSection(DOWNLOAD_RUNTIME_SECTION);
        if (this.downloadRuntimeSection == null) {
            this.downloadRuntimeSection = dialogSettings.addNewSection(DOWNLOAD_RUNTIME_SECTION);
        }
    }

    public boolean hasComposite() {
        return true;
    }

    protected void createChildFragments(List<WizardFragment> list) {
        if (this.nextWorkflowFragment != null) {
            list.add(this.nextWorkflowFragment);
        }
    }

    public void enter() {
    }

    public Composite createComposite(Composite parent, IWizardHandle handle) {
        this.handle = handle;
        this.getPage().setTitle(DownloadRuntimeMessages.CredentialsFragmentTitle);
        this.getPage().setDescription(DownloadRuntimeMessages.CredentialsFragmentDescription);
        Composite contents = new Composite(parent, 0);
        GridData gd = new GridData(1808);
        contents.setLayoutData((Object)gd);
        contents.setLayout((Layout)new FormLayout());
        Link l = new Link(contents, 64);
        l.setText(DownloadRuntimeMessages.CredentialsFragmentInstructions);
        l.setLayoutData((Object)FormDataUtility.createFormData2((Object)0, (int)5, null, (int)0, (Object)0, (int)5, (Object)0, (int)400));
        l.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DownloadManagerCredentialsFragment.this.createJBossOrgAccount();
            }
        });
        this.chooseCredentialComposite = this.createCredentialComposite(contents);
        this.chooseCredentialComposite.setLayoutData((Object)FormDataUtility.createFormData2((Object)l, (int)5, null, (int)0, (Object)0, (int)5, (Object)100, (int)-5));
        this.readFromCredentialComposite(true);
        return contents;
    }

    private ChooseCredentialComposite createCredentialComposite(Composite parent) {
        ChooseCredentialComposite comp = new ChooseCredentialComposite(parent, new String[]{"jboss.org"});
        comp.addCredentialListener(new ICredentialCompositeListener(){

            public void credentialsChanged() {
                DownloadManagerCredentialsFragment.this.readFromCredentialComposite(true);
            }
        });
        return comp;
    }

    private void readFromCredentialComposite(boolean validate) {
        this.getTaskModel().putObject("dl.runtime.username", (Object)this.chooseCredentialComposite.getUser());
        this.getTaskModel().putObject("dl.runtime.password", (Object)this.chooseCredentialComposite.getPassword());
        if (validate) {
            this.validateFragment();
        }
    }

    protected void createJBossOrgAccount() {
        new BrowserUtility().checkedCreateExternalBrowser(this.JBOSS_ORG_SIGNUP_URL, "org.jboss.tools.runtime.ui", RuntimeUIActivator.getDefault().getLog());
    }

    protected void validateFragment() {
        String tempName = (String)this.getTaskModel().getObject("dl.runtime.username");
        String tempPass = (String)this.getTaskModel().getObject("dl.runtime.password");
        boolean nameEmpty = tempName == null || tempName.trim().length() == 0;
        boolean passEmpty = tempPass == null || tempPass.trim().length() == 0;
        this.setComplete(!nameEmpty && !passEmpty);
        this.headerResponse = -1;
        this.handle.update();
    }

    private void validationPressed() {
        final String userS = (String)this.getTaskModel().getObject("dl.runtime.username");
        final String passS = (String)this.getTaskModel().getObject("dl.runtime.password");
        final String[] error = new String[1];
        try {
            this.handle.run(true, false, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    monitor.beginTask(DownloadRuntimeMessages.ValidatingCredentials, 100);
                    monitor.worked(10);
                    error[0] = DownloadManagerCredentialsFragment.this.validateCredentials(userS, passS);
                    monitor.done();
                }
            });
            if (error[0] != null) {
                this.handle.setMessage(error[0], 3);
            } else {
                this.handle.setMessage(null, 0);
            }
            this.handle.update();
        }
        catch (InterruptedException ie) {
            RuntimeUIActivator.pluginLog().logError((Throwable)ie);
        }
        catch (InvocationTargetException ite) {
            RuntimeUIActivator.pluginLog().logError((Throwable)ite);
        }
    }

    private String validateCredentials(String userS, String passS) {
        int response;
        block6: {
            try {
                response = DownloadManagerWorkflowUtility.getWorkflowStatus(this.getDownloadRuntimeFromTaskModel(), userS, passS);
                if (response == 2) {
                    return DownloadRuntimeMessages.CredentialsIncorrect;
                }
                if (response != 3) break block6;
                String responseContent = DownloadManagerWorkflowUtility.getWorkflowResponseContent(this.getDownloadRuntimeFromTaskModel(), userS, passS);
                this.getTaskModel().putObject(WORKFLOW_NEXT_STEP_KEY, (Object)responseContent);
                this.nextWorkflowFragment = DownloadManagerWorkflowUtility.getNextWorkflowFragment(responseContent);
                if (this.nextWorkflowFragment == null) {
                    return NLS.bind((String)DownloadRuntimeMessages.CredentialWorkflowFailed, (Object)this.getDownloadRuntimeFromTaskModel().getUrl());
                }
                return null;
            }
            catch (Exception e) {
                RuntimeUIActivator.pluginLog().logError((Throwable)e);
                return NLS.bind((String)DownloadRuntimeMessages.CredentialError, (Object)e.getClass().getName(), (Object)e.getMessage());
            }
        }
        if (response == 1) {
            this.nextWorkflowFragment = null;
            return null;
        }
        return null;
    }

    private DownloadRuntime getDownloadRuntimeFromTaskModel() {
        return (DownloadRuntime)this.getTaskModel().getObject("dl.runtime.prop");
    }

    protected boolean hasActionOnNextPressed() {
        return true;
    }

    protected boolean performNextPressedAction() {
        this.validationPressed();
        String msg = this.handle.getMessage();
        if (msg != null) {
            this.setComplete(false);
            this.handle.update();
        }
        return msg == null;
    }
}

