/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.runtime.ui.internal.wizard;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.fieldassist.FieldDecoration;
import org.eclipse.jface.fieldassist.FieldDecorationRegistry;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.browser.IWorkbenchBrowserSupport;
import org.jboss.tools.foundation.core.jobs.DelegatingProgressMonitor;
import org.jboss.tools.foundation.ui.xpl.taskwizard.IWizardHandle;
import org.jboss.tools.foundation.ui.xpl.taskwizard.WizardFragment;
import org.jboss.tools.runtime.core.extract.IOverwrite;
import org.jboss.tools.runtime.core.internal.RuntimeExtensionManager;
import org.jboss.tools.runtime.core.model.DownloadRuntime;
import org.jboss.tools.runtime.core.model.IRuntimeInstaller;
import org.jboss.tools.runtime.ui.RuntimeUIActivator;
import org.jboss.tools.runtime.ui.internal.Messages;
import org.jboss.tools.runtime.ui.internal.wizard.DownloadRuntimeOperationUIUtility;

public class FinalizeRuntimeDownloadFragment
extends WizardFragment {
    private static final String DELETE_ON_EXIT = "deleteOnExit";
    private static final String JAVA_IO_TMPDIR = "java.io.tmpdir";
    private static final String USER_HOME = "user.home";
    private static final String DEFAULT_DIALOG_PATH = "defaultDialogPath";
    private static final String DEFAULT_DESTINATION_PATH = "defaultDestinationPath";
    private DownloadRuntime dlrt;
    private IDialogSettings dialogSettings = RuntimeUIActivator.getDefault().getDialogSettings();
    private Button deleteOnExit;
    private Text destinationPathText;
    private Text pathText;
    private String delete;
    private ControlDecoration decPathError_dne;
    private ControlDecoration decPathError_writable;
    private ControlDecoration decPathReq;
    private ControlDecoration destinationPathError_dne;
    private ControlDecoration destinationPathError_writable;
    private ControlDecoration destinationPathReq;
    private Link urlText;
    private Group warningComposite;
    private Label warningLabel;
    private Link warningLink;
    private Composite contents;
    private Composite pathComposite;
    private Shell shell;
    private IWizardHandle handle;

    public boolean hasComposite() {
        return true;
    }

    public void enter() {
        DownloadRuntime tmp = this.getDownloadRuntimeFromTaskModel();
        if (tmp != null && !tmp.equals((Object)this.dlrt)) {
            this.dlrt = tmp;
            this.setDownloadRuntime(this.dlrt);
        }
    }

    private DownloadRuntime getDownloadRuntimeFromTaskModel() {
        return (DownloadRuntime)this.getTaskModel().getObject("dl.runtime.prop");
    }

    private boolean shouldSuppressCreation() {
        Object suppress = this.getTaskModel().getObject("dl.runtime.suppressCreation");
        if (suppress instanceof Boolean) {
            return (Boolean)suppress;
        }
        return false;
    }

    private void setDescription() {
        if (this.getPage() == null) {
            return;
        }
        this.getPage().setTitle(Messages.DownloadRuntimesSecondPage_Download_Runtime);
        if (this.getDownloadRuntimeFromTaskModel() != null) {
            this.getPage().setDescription("Download Runtime '" + this.getDownloadRuntimeFromTaskModel().getName() + "'");
        } else {
            this.getPage().setDescription("Download Runtime");
        }
    }

    public Composite createComposite(Composite parent, IWizardHandle handle) {
        this.handle = handle;
        this.shell = parent.getShell();
        this.contents = new Composite(parent, 0);
        GridData gd = new GridData(4, 4, true, true);
        this.contents.setLayoutData((Object)gd);
        this.contents.setLayout((Layout)new GridLayout(1, false));
        this.pathComposite = this.createAndFillPathComposite(this.contents);
        this.setDownloadRuntime((DownloadRuntime)this.getTaskModel().getObject("dl.runtime.prop"));
        this.setDescription();
        this.refresh();
        return this.contents;
    }

    private Composite createAndFillPathComposite(Composite parent) {
        Composite pathComposite = new Composite(parent, 0);
        GridData gd = new GridData(4, 4, true, false);
        pathComposite.setLayoutData((Object)gd);
        pathComposite.setLayout((Layout)new GridLayout(3, false));
        Label urlLabel = new Label(pathComposite, 0);
        urlLabel.setText(Messages.DownloadRuntimesSecondPage_URL);
        this.urlText = new Link(pathComposite, 0);
        gd = new GridData(4, 4, true, false);
        gd.horizontalSpan = 2;
        this.urlText.setLayoutData((Object)gd);
        this.urlText.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String t = e.text;
                String humanUrl = FinalizeRuntimeDownloadFragment.this.getDownloadRuntimeFromTaskModel().getHumanUrl();
                if (humanUrl != null && t.contains(humanUrl)) {
                    IWorkbenchBrowserSupport support = PlatformUI.getWorkbench().getBrowserSupport();
                    try {
                        URL url = new URL(humanUrl);
                        support.getExternalBrowser().openURL(url);
                    }
                    catch (Exception e1) {
                        RuntimeUIActivator.pluginLog().logError((Throwable)e1);
                        final String message = e1.getMessage();
                        Display.getDefault().syncExec(new Runnable(){

                            @Override
                            public void run() {
                                MessageDialog.openError((Shell)FinalizeRuntimeDownloadFragment.this.getActiveShell(), (String)"Error", (String)message);
                            }
                        });
                    }
                }
            }
        });
        if (this.requiresManualDownload()) {
            return pathComposite;
        }
        Label pathLabel = new Label(pathComposite, 0);
        pathLabel.setText(Messages.DownloadRuntimesSecondPage_Install_folder);
        this.pathText = new Text(pathComposite, 2048);
        gd = new GridData(4, 4, true, false);
        this.pathText.setLayoutData((Object)gd);
        String defaultPath = this.getDefaultPath();
        this.pathText.setText(defaultPath);
        this.decPathError_dne = this.addDecoration((Control)this.pathText, "DEC_WARNING", Messages.DownloadRuntimesSecondPage_This_folder_does_not_exist);
        this.decPathError_writable = this.addDecoration((Control)this.pathText, "DEC_ERROR", Messages.DownloadRuntimesSecondPage_This_folder_not_writable);
        this.decPathReq = this.addDecoration((Control)this.pathText, "DEC_REQUIRED", Messages.DownloadRuntimesSecondPage_This_folder_is_required);
        this.pathText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                FinalizeRuntimeDownloadFragment.this.validate();
            }
        });
        Button browseButton = new Button(pathComposite, 0);
        browseButton.setText(Messages.DownloadRuntimesSecondPage_Browse);
        browseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DirectoryDialog dialog = new DirectoryDialog(FinalizeRuntimeDownloadFragment.this.shell);
                dialog.setMessage(Messages.DownloadRuntimesSecondPage_Select_install_folder);
                dialog.setFilterPath(FinalizeRuntimeDownloadFragment.this.pathText.getText());
                String path = dialog.open();
                if (path == null) {
                    return;
                }
                FinalizeRuntimeDownloadFragment.this.pathText.setText(path);
            }
        });
        Label destinationLabel = new Label(pathComposite, 0);
        destinationLabel.setText(Messages.DownloadRuntimesSecondPage_Download_folder);
        this.destinationPathText = new Text(pathComposite, 2048);
        gd = new GridData(4, 4, true, false);
        this.destinationPathText.setLayoutData((Object)gd);
        String destinationPath = this.dialogSettings.get(DEFAULT_DESTINATION_PATH);
        this.destinationPathError_dne = this.addDecoration((Control)this.destinationPathText, "DEC_WARNING", Messages.DownloadRuntimesSecondPage_This_folder_does_not_exist);
        this.destinationPathError_writable = this.addDecoration((Control)this.destinationPathText, "DEC_ERROR", Messages.DownloadRuntimesSecondPage_This_folder_not_writable);
        this.destinationPathReq = this.addDecoration((Control)this.destinationPathText, "DEC_REQUIRED", Messages.DownloadRuntimesSecondPage_This_folder_is_required);
        if (destinationPath == null || destinationPath.isEmpty()) {
            destinationPath = System.getProperty(JAVA_IO_TMPDIR);
        }
        this.destinationPathText.setText(destinationPath);
        Button browseDestinationButton = new Button(pathComposite, 0);
        browseDestinationButton.setText(Messages.DownloadRuntimesSecondPage_Browse);
        browseDestinationButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DirectoryDialog dialog = new DirectoryDialog(FinalizeRuntimeDownloadFragment.this.shell);
                dialog.setMessage(Messages.DownloadRuntimesSecondPage_Select_ownload_folder);
                dialog.setFilterPath(FinalizeRuntimeDownloadFragment.this.destinationPathText.getText());
                String path = dialog.open();
                if (path == null) {
                    return;
                }
                FinalizeRuntimeDownloadFragment.this.destinationPathText.setText(path);
            }
        });
        this.destinationPathText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                FinalizeRuntimeDownloadFragment.this.validate();
            }
        });
        this.deleteOnExit = new Button(pathComposite, 32);
        gd = new GridData(4, 4, true, false);
        gd.horizontalSpan = 3;
        this.deleteOnExit.setLayoutData((Object)gd);
        this.deleteOnExit.setText(Messages.DownloadRuntimesSecondPage_Delete_archive_after_installing);
        this.delete = this.dialogSettings.get(DELETE_ON_EXIT);
        if (this.delete == null) {
            this.delete = Boolean.TRUE.toString();
        }
        this.deleteOnExit.setSelection(new Boolean(this.delete).booleanValue());
        this.deleteOnExit.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FinalizeRuntimeDownloadFragment.this.delete = new Boolean(FinalizeRuntimeDownloadFragment.this.deleteOnExit.getSelection()).toString();
            }
        });
        return pathComposite;
    }

    private Group createWarningComposite(Composite parent) {
        this.warningComposite = new Group(parent, 0);
        GridData gd = new GridData(4, 4, true, false);
        this.warningComposite.setLayoutData((Object)gd);
        this.warningComposite.setLayout((Layout)new GridLayout(1, false));
        this.warningComposite.setText(Messages.DownloadRuntimesSecondPage_Warning);
        this.warningLabel = new Label((Composite)this.warningComposite, 0);
        gd = new GridData(4, 4, true, false);
        this.warningLabel.setLayoutData((Object)gd);
        this.warningLink = new Link((Composite)this.warningComposite, 0);
        gd = new GridData(4, 4, true, false);
        this.warningLink.setLayoutData((Object)gd);
        this.warningLink.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String text = e.text;
                String humanUrl = FinalizeRuntimeDownloadFragment.this.getDownloadRuntimeFromTaskModel() == null ? null : FinalizeRuntimeDownloadFragment.this.getDownloadRuntimeFromTaskModel().getHumanUrl();
                String linkUrl = null;
                if (humanUrl != null && "link".equals(text)) {
                    linkUrl = humanUrl;
                } else if ("Show Details".equals(text)) {
                    linkUrl = "http://www.redhat.com/jboss/";
                }
                if (linkUrl != null) {
                    IWorkbenchBrowserSupport support = PlatformUI.getWorkbench().getBrowserSupport();
                    try {
                        URL url = new URL(linkUrl);
                        support.getExternalBrowser().openURL(url);
                    }
                    catch (Exception e1) {
                        RuntimeUIActivator.pluginLog().logError((Throwable)e1);
                        final String message = e1.getMessage();
                        Display.getDefault().syncExec(new Runnable(){

                            @Override
                            public void run() {
                                MessageDialog.openError((Shell)FinalizeRuntimeDownloadFragment.this.getActiveShell(), (String)"Error", (String)message);
                            }
                        });
                    }
                }
            }
        });
        return this.warningComposite;
    }

    private String getDefaultPath() {
        String defaultPath = this.dialogSettings.get(DEFAULT_DIALOG_PATH);
        if (defaultPath == null || defaultPath.isEmpty()) {
            defaultPath = System.getProperty(USER_HOME);
        }
        return defaultPath;
    }

    private void showDecorations() {
        if (this.requiresManualDownload()) {
            return;
        }
        String path = this.pathText == null || this.pathText.isDisposed() ? "" : this.pathText.getText();
        String destination = this.destinationPathText == null || this.destinationPathText.isDisposed() ? "" : this.destinationPathText.getText();
        this.decPathError_dne.hide();
        this.decPathError_writable.hide();
        this.decPathReq.hide();
        this.destinationPathError_dne.hide();
        this.destinationPathError_writable.hide();
        this.destinationPathReq.hide();
        ArrayList<Status> all = new ArrayList<Status>();
        if (path.isEmpty()) {
            this.decPathReq.show();
            all.add(new Status(4, "org.jboss.tools.runtime.ui", Messages.DownloadRuntimesSecondPage_Install_folder_is_required));
        }
        if (destination.isEmpty()) {
            this.destinationPathReq.show();
            all.add(new Status(4, "org.jboss.tools.runtime.ui", Messages.DownloadRuntimesSecondPage_Download_folder_is_required));
        }
        boolean pathExists = this.checkPathExists(path);
        boolean pathWritable = this.checkPathWritable(path);
        boolean destExists = this.checkPathExists(destination);
        boolean destWritable = this.checkPathWritable(destination);
        if (pathExists && !pathWritable) {
            this.decPathError_writable.show();
            this.decPathError_writable.setShowHover(true);
            all.add(new Status(4, "org.jboss.tools.runtime.ui", Messages.DownloadRuntimesSecondPage_Install_folder_not_writable));
        }
        if (destExists && !destWritable) {
            this.destinationPathError_writable.show();
            this.destinationPathError_writable.setShowHover(true);
            all.add(new Status(4, "org.jboss.tools.runtime.ui", Messages.DownloadRuntimesSecondPage_Download_folder_not_writable));
        }
        if (!pathExists) {
            this.decPathError_dne.show();
            this.decPathError_dne.setShowHover(true);
            all.add(new Status(1, "org.jboss.tools.runtime.ui", Messages.DownloadRuntimesSecondPage_Install_folder_does_not_exist));
        }
        if (!destExists) {
            this.destinationPathError_dne.show();
            this.destinationPathError_dne.setShowHover(true);
            all.add(new Status(1, "org.jboss.tools.runtime.ui", Messages.DownloadRuntimesSecondPage_Download_folder_does_not_exist));
        }
        Object var8_8 = null;
        IStatus worstStatus = null;
        for (IStatus iStatus : all) {
            if (worstStatus != null && iStatus.getSeverity() <= worstStatus.getSeverity()) continue;
            worstStatus = iStatus;
        }
        int messageType = 0;
        if (worstStatus != null) {
            switch (worstStatus.getSeverity()) {
                case 0: {
                    messageType = 0;
                    break;
                }
                case 1: {
                    messageType = 1;
                    break;
                }
                case 2: {
                    messageType = 2;
                    break;
                }
                case 4: {
                    messageType = 3;
                }
            }
        }
        this.handle.setMessage(worstStatus == null ? "" : worstStatus.getMessage(), messageType);
        this.setComplete(messageType != 3);
        this.handle.update();
    }

    private boolean checkPathExists(String path) {
        if (path.isEmpty()) {
            return true;
        }
        return new File(path).exists();
    }

    private boolean checkPathWritable(String path) {
        if (path.isEmpty()) {
            return true;
        }
        try {
            File file = File.createTempFile("temp", "txt", new File(path));
            file.deleteOnExit();
            file.delete();
        }
        catch (IOException iOException) {
            return false;
        }
        return true;
    }

    protected ControlDecoration addDecoration(Control control, String id, String description) {
        ControlDecoration decPath = new ControlDecoration(control, 16512);
        FieldDecorationRegistry registry = FieldDecorationRegistry.getDefault();
        FieldDecoration fd = registry.getFieldDecoration(id);
        decPath.setImage(fd.getImage());
        fd.setDescription(description);
        decPath.setImage(FieldDecorationRegistry.getDefault().getFieldDecoration(id).getImage());
        decPath.setShowOnlyOnFocus(false);
        decPath.setShowHover(true);
        decPath.setDescriptionText(description);
        decPath.hide();
        return decPath;
    }

    protected void validate() {
        this.handle.setMessage(null, 0);
        this.showDecorations();
    }

    private void refresh() {
        DownloadRuntime downloadRuntime;
        if (this.contents != null && !this.contents.isDisposed()) {
            if (this.pathComposite != null) {
                this.pathComposite.dispose();
                this.pathComposite = null;
            }
            if (this.warningComposite != null) {
                this.warningComposite.dispose();
                this.warningComposite = null;
            }
            this.contents.layout(true, true);
            this.contents.pack();
        }
        if ((downloadRuntime = this.getDownloadRuntimeFromTaskModel()) != null) {
            boolean showWarning;
            boolean requireManualDownload = this.requiresManualDownload();
            this.pathComposite = this.createAndFillPathComposite(this.contents);
            if (this.getDownloadUrl() != null) {
                this.urlText.setText(this.getDownloadUrl());
            } else if (downloadRuntime.getHumanUrl() != null) {
                this.urlText.setText("<a>" + downloadRuntime.getHumanUrl().trim() + "</a>");
            } else {
                this.urlText.setText("");
            }
            boolean isDisclaimer = downloadRuntime.isDisclaimer();
            boolean bl = showWarning = isDisclaimer || requireManualDownload;
            if (showWarning) {
                this.warningComposite = this.createWarningComposite(this.contents);
                if (isDisclaimer) {
                    this.warningLabel.setText("This is a community project and, as such is not supported with an SLA.");
                    this.warningLink.setText("If you're looking for fully supported, certified, enterprise middleware try JBoss Enterprise Middleware products. <a>Show Details</a>");
                } else if (requireManualDownload) {
                    this.warningLabel.setText("This runtime is only available as manual download.");
                    this.warningLink.setText("Please click on the download <a>link</a>.");
                }
            }
        }
        this.contents.getParent().layout(true, true);
        this.validate();
        this.updateWidgetEnablementForDownloadRuntime();
    }

    public void setDownloadRuntime(DownloadRuntime selectedRuntime) {
        this.setDescription();
        if (this.contents != null && !this.contents.isDisposed()) {
            this.refresh();
            if (selectedRuntime != null) {
                this.setComplete(true);
            } else {
                this.setComplete(true);
            }
        } else {
            this.setComplete(false);
        }
        this.handle.update();
    }

    private void updateWidgetEnablementForDownloadRuntime() {
        DownloadRuntime downloadRuntime = this.getDownloadRuntimeFromTaskModel();
        if (downloadRuntime == null) {
            return;
        }
        if (!this.requiresManualDownload()) {
            boolean enabled = this.getDownloadUrl() != null;
            this.deleteOnExit.setEnabled(enabled);
            this.destinationPathText.setEnabled(enabled);
            this.pathText.setEnabled(enabled);
        }
    }

    private boolean requiresManualDownload() {
        DownloadRuntime downloadRuntime = this.getDownloadRuntimeFromTaskModel();
        if (downloadRuntime != null) {
            String fromTaskModel;
            boolean hasNoDlUrl;
            boolean bl = hasNoDlUrl = downloadRuntime.getUrl() == null && downloadRuntime.getHumanUrl() != null;
            if (hasNoDlUrl && (fromTaskModel = (String)this.getTaskModel().getObject("dl.runtime.url")) == null) {
                return true;
            }
        }
        return false;
    }

    private String getDownloadUrl() {
        DownloadRuntime downloadRuntime = this.getDownloadRuntimeFromTaskModel();
        if (downloadRuntime != null) {
            String dlUrl = downloadRuntime.getUrl();
            if (dlUrl == null) {
                return (String)this.getTaskModel().getObject("dl.runtime.url");
            }
            return dlUrl;
        }
        return null;
    }

    public void performFinish(final IProgressMonitor monitor) {
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                FinalizeRuntimeDownloadFragment.this.finishPage(monitor);
            }
        });
    }

    public boolean finishPage(IProgressMonitor monitor) {
        if (this.requiresManualDownload()) {
            return true;
        }
        String selectedDirectory = this.pathText.getText();
        String destinationDirectory = this.destinationPathText.getText();
        boolean del = this.deleteOnExit.getSelection();
        return this.downloadRuntime(selectedDirectory, destinationDirectory, del, monitor);
    }

    private void saveDialogSettings() {
        String systemTempDir = System.getProperty(JAVA_IO_TMPDIR);
        if (systemTempDir.equals(this.destinationPathText.getText())) {
            this.dialogSettings.put(DEFAULT_DESTINATION_PATH, null);
        } else {
            this.dialogSettings.put(DEFAULT_DESTINATION_PATH, this.destinationPathText.getText());
        }
        this.dialogSettings.put(DEFAULT_DIALOG_PATH, this.pathText.getText());
        this.dialogSettings.put(DELETE_ON_EXIT, this.delete);
    }

    private boolean downloadRuntime(final String unzipDirectory, final String downloadDirectory, final boolean deleteOnExit, IProgressMonitor monitor) {
        this.saveDialogSettings();
        final DownloadRuntime downloadRuntime = this.getDownloadRuntimeFromTaskModel();
        final boolean suppressCreation = this.shouldSuppressCreation();
        final DelegatingProgressMonitor delegatingMonitor = new DelegatingProgressMonitor();
        this.getTaskModel().putObject("dl.runtime.progress.monitor", (Object)delegatingMonitor);
        Job downloadJob = new Job("Download '" + downloadRuntime.getName()){

            public IStatus run(IProgressMonitor jobMonitor) {
                delegatingMonitor.add(jobMonitor);
                String installationMethod = downloadRuntime.getInstallationMethod();
                IRuntimeInstaller installer = this.getInstaller(installationMethod);
                if (installer == null) {
                    return new Status(4, "org.jboss.tools.runtime.ui", "Unable to find an installer with id " + installationMethod);
                }
                delegatingMonitor.beginTask("Downloading and Installing Runtime", 100);
                IOverwrite ow = DownloadRuntimeOperationUIUtility.createOverwriteFileQuery();
                FinalizeRuntimeDownloadFragment.this.getTaskModel().putObject("dl.runtime.overwrite", (Object)ow);
                int firstStep = suppressCreation ? 99 : 95;
                Object ret = installer.installRuntime(downloadRuntime, unzipDirectory, downloadDirectory, deleteOnExit, FinalizeRuntimeDownloadFragment.this.getTaskModel(), (IProgressMonitor)new SubProgressMonitor((IProgressMonitor)delegatingMonitor, firstStep));
                if (!suppressCreation && ret.isOK()) {
                    String updatedRuntimeRoot = (String)FinalizeRuntimeDownloadFragment.this.getTaskModel().getObject("dl.runtime.unzipped.home.dir");
                    if (updatedRuntimeRoot == null || !new File(updatedRuntimeRoot).exists()) {
                        updatedRuntimeRoot = unzipDirectory;
                    }
                    ret = updatedRuntimeRoot == null || !new File(updatedRuntimeRoot).exists() ? new Status(4, "org.jboss.tools.runtime.ui", "No runtime found at path " + updatedRuntimeRoot) : DownloadRuntimeOperationUIUtility.createRuntimes(updatedRuntimeRoot, (IProgressMonitor)new SubProgressMonitor((IProgressMonitor)delegatingMonitor, 4));
                }
                if (delegatingMonitor.isCanceled()) {
                    return Status.CANCEL_STATUS;
                }
                if (!ret.isOK() && ret.getSeverity() != 8) {
                    FinalizeRuntimeDownloadFragment.openErrorMessage(ret.getMessage(), true);
                }
                return Status.OK_STATUS;
            }

            private IRuntimeInstaller getInstaller(String installerId) {
                return RuntimeExtensionManager.getDefault().getRuntimeInstaller(installerId);
            }
        };
        downloadJob.setUser(false);
        downloadJob.schedule(1000L);
        this.getTaskModel().putObject("dl.runtime.downloadJob", (Object)downloadJob);
        return true;
    }

    private Shell getActiveShell() {
        Display display = Display.getDefault();
        if (display != null && this.shell == null) {
            return PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
        }
        return this.shell;
    }

    private static void openErrorMessage(String msg, boolean log) {
        FinalizeRuntimeDownloadFragment.openErrorMessage("Error", msg, log);
    }

    private static void openErrorMessage(String msg) {
        FinalizeRuntimeDownloadFragment.openErrorMessage(msg, false);
    }

    private static void openWarningMessage(final String title, final String msg) {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                MessageDialog.openWarning((Shell)Display.getDefault().getActiveShell(), (String)title, (String)msg);
            }
        });
    }

    private static void openErrorMessage(String title, String msg, boolean log) {
        if (log) {
            RuntimeUIActivator.pluginLog().logError(msg);
        }
        FinalizeRuntimeDownloadFragment.openErrorMessage("Error", msg);
    }

    private static void openErrorMessage(final String title, final String msg) {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)title, (String)msg);
            }
        });
    }
}

