/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.runtime.ui;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.jboss.tools.foundation.ui.xpl.taskwizard.WizardFragment;
import org.jboss.tools.runtime.core.model.DownloadRuntime;
import org.jboss.tools.runtime.ui.RuntimeUIActivator;
import org.jboss.tools.runtime.ui.wizard.IWorkflowProvider;

public class RuntimeUIExtensionManager {
    private static HashMap<String, IWorkflowProvider> providerMap = null;

    public static WizardFragment[] createFragmentsForRuntime(DownloadRuntime dr) {
        RuntimeUIExtensionManager.ensureLoaded();
        ArrayList<WizardFragment> toReturn = new ArrayList<WizardFragment>();
        Set<String> keys = providerMap.keySet();
        Iterator<String> keyIt = keys.iterator();
        while (keyIt.hasNext()) {
            WizardFragment[] fragList;
            IWorkflowProvider p = providerMap.get(keyIt.next());
            if (!p.canProvideWorkflow(dr) || (fragList = p.createFragmentsForRuntime(dr)) == null) continue;
            toReturn.addAll(Arrays.asList(fragList));
        }
        return toReturn.toArray(new WizardFragment[toReturn.size()]);
    }

    private static void ensureLoaded() {
        if (providerMap != null) {
            return;
        }
        providerMap = new HashMap();
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IConfigurationElement[] cf = registry.getConfigurationElementsFor("org.jboss.tools.runtime.ui", "workflowProvider");
        int i = 0;
        while (i < cf.length) {
            try {
                String id = cf[i].getAttribute("id");
                Object o = cf[i].createExecutableExtension("class");
                providerMap.put(id, (IWorkflowProvider)o);
            }
            catch (CoreException ce) {
                RuntimeUIActivator.getDefault().getLog().log(ce.getStatus());
            }
            ++i;
        }
    }
}

