/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.core.internal.resource;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.core.expressions.ExpressionConverter;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.RegistryFactory;
import org.eclipse.jpt.common.core.JptCommonCoreMessages;
import org.eclipse.jpt.common.core.internal.InternalJptWorkspace;
import org.eclipse.jpt.common.core.internal.plugin.JptCommonCorePlugin;
import org.eclipse.jpt.common.core.internal.resource.ResourceLocatorConfig;
import org.eclipse.jpt.common.core.internal.utility.ExtensionPointTools;
import org.eclipse.jpt.common.core.resource.ResourceLocator;
import org.eclipse.jpt.common.core.resource.ResourceLocatorManager;
import org.eclipse.jpt.common.utility.internal.ObjectTools;
import org.eclipse.jpt.common.utility.internal.StringTools;
import org.eclipse.jpt.common.utility.internal.iterable.IterableTools;
import org.eclipse.jpt.common.utility.internal.iterable.TransformationIterable;
import org.eclipse.jpt.common.utility.predicate.Predicate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InternalResourceLocatorManager
implements ResourceLocatorManager {
    private final InternalJptWorkspace jptWorkspace;
    private final ArrayList<ResourceLocatorConfig> resourceLocatorConfigs = new ArrayList();
    private static final String SIMPLE_EXTENSION_POINT_NAME = "resourceLocators";
    private static final String RESOURCE_LOCATOR_ELEMENT = "resourceLocator";
    private static final String ID_ATTRIBUTE = "id";
    private static final String CLASS_ATTRIBUTE = "class";
    private static final String PRIORITY_ATTRIBUTE = "priority";
    private static final String ENABLEMENT_ELEMENT = "enablement";

    public InternalResourceLocatorManager(InternalJptWorkspace jptWorkspace) {
        this.jptWorkspace = jptWorkspace;
        this.initialize();
    }

    private void initialize() {
        IExtensionPoint extensionPoint = this.getExtensionPoint();
        if (extensionPoint == null) {
            throw new IllegalStateException("missing extension point: " + this.getExtensionPointName());
        }
        IExtension[] iExtensionArray = extensionPoint.getExtensions();
        int n = iExtensionArray.length;
        int n2 = 0;
        while (n2 < n) {
            IExtension extension = iExtensionArray[n2];
            IConfigurationElement[] iConfigurationElementArray = extension.getConfigurationElements();
            int n3 = iConfigurationElementArray.length;
            int n4 = 0;
            while (n4 < n3) {
                ResourceLocatorConfig config;
                IConfigurationElement element = iConfigurationElementArray[n4];
                String elementName = element.getName();
                if (elementName.equals(RESOURCE_LOCATOR_ELEMENT) && (config = this.buildResourceLocatorConfig(element)) != null) {
                    this.resourceLocatorConfigs.add(config);
                }
                ++n4;
            }
            ++n2;
        }
    }

    private ResourceLocatorConfig buildResourceLocatorConfig(IConfigurationElement element) {
        String contributor = element.getContributor().getName();
        String id = element.getAttribute(ID_ATTRIBUTE);
        if (StringTools.isBlank((String)id)) {
            this.logMissingAttribute(element, ID_ATTRIBUTE);
            return null;
        }
        if (this.containsResourceLocatorConfig(id)) {
            this.logError(JptCommonCoreMessages.REGISTRY_DUPLICATE, this.getExtensionPointName(), contributor, ID_ATTRIBUTE, id);
            return null;
        }
        String className = element.getAttribute(CLASS_ATTRIBUTE);
        if (className == null) {
            this.logMissingAttribute(element, CLASS_ATTRIBUTE);
            return null;
        }
        String priorityString = element.getAttribute(PRIORITY_ATTRIBUTE).trim();
        ResourceLocatorConfig.Priority priority = ResourceLocatorConfig.Priority.get(priorityString);
        if (priority == null) {
            this.logInvalidPriority(element, priorityString);
            return null;
        }
        ResourceLocatorConfig config = new ResourceLocatorConfig(this, id, className, priority);
        IConfigurationElement[] iConfigurationElementArray = element.getChildren();
        int n = iConfigurationElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement child = iConfigurationElementArray[n2];
            if (child.getName().equals(ENABLEMENT_ELEMENT)) {
                if (config.getEnablementExpression() != null) {
                    this.logMultipleEnablements(element);
                    return null;
                }
                try {
                    config.setEnablementExpression(ExpressionConverter.getDefault().perform(child));
                }
                catch (CoreException ex) {
                    JptCommonCorePlugin.instance().logError(ex);
                    return null;
                }
            }
            ++n2;
        }
        config.setPluginID(contributor);
        return config;
    }

    @Override
    public Iterable<ResourceLocator> getResourceLocators() {
        return IterableTools.removeNulls(this.getResourceLocators_());
    }

    private Iterable<ResourceLocator> getResourceLocators_() {
        return new TransformationIterable(this.resourceLocatorConfigs, ResourceLocatorConfig.RESOURCE_LOCATOR_TRANSFORMER);
    }

    @Override
    public ResourceLocator getResourceLocator(IProject project) {
        Iterator<ResourceLocator> stream = this.getResourceLocators(project).iterator();
        return stream.hasNext() ? stream.next() : null;
    }

    @Override
    public Iterable<ResourceLocator> getResourceLocators(IProject project) {
        return IterableTools.removeNulls(this.getResourceLocators_(project));
    }

    private Iterable<ResourceLocator> getResourceLocators_(IProject project) {
        return new TransformationIterable(this.getSortedResourceLocatorConfigs(project), ResourceLocatorConfig.RESOURCE_LOCATOR_TRANSFORMER);
    }

    private Iterable<ResourceLocatorConfig> getSortedResourceLocatorConfigs(IProject project) {
        return IterableTools.sort(this.getResourceLocatorConfigs(project));
    }

    private Iterable<ResourceLocatorConfig> getResourceLocatorConfigs(IProject project) {
        return IterableTools.filter(this.resourceLocatorConfigs, (Predicate)new ResourceLocatorConfig.IsEnabled(project));
    }

    private boolean containsResourceLocatorConfig(String id) {
        return this.getResourceLocatorConfig(id) != null;
    }

    private ResourceLocatorConfig getResourceLocatorConfig(String id) {
        for (ResourceLocatorConfig config : this.resourceLocatorConfigs) {
            if (!config.getID().equals(id)) continue;
            return config;
        }
        return null;
    }

    private void logError(String msg, Object ... args) {
        this.getPlugin().logError(msg, args);
    }

    private void logMissingAttribute(IConfigurationElement element, String attributeName) {
        this.getPlugin().logError(ExtensionPointTools.buildMissingAttributeMessage(element, attributeName));
    }

    private void logInvalidPriority(IConfigurationElement element, String priority) {
        this.getPlugin().logError(JptCommonCoreMessages.INVALID_RESOURCE_LOCATOR_PRIORITY, priority, element.getDeclaringExtension().getExtensionPointUniqueIdentifier(), element.getContributor().getName());
    }

    private void logMultipleEnablements(IConfigurationElement element) {
        this.getPlugin().logError(JptCommonCoreMessages.MULTIPLE_RESOURCE_LOCATOR_ENABLEMENTS, element.getDeclaringExtension().getExtensionPointUniqueIdentifier(), element.getContributor().getName());
    }

    @Override
    public InternalJptWorkspace getJptWorkspace() {
        return this.jptWorkspace;
    }

    String getExtensionPointName() {
        return String.valueOf(this.getPluginID()) + '.' + SIMPLE_EXTENSION_POINT_NAME;
    }

    private IExtensionPoint getExtensionPoint() {
        return this.getExtensionRegistry().getExtensionPoint(this.getPluginID(), SIMPLE_EXTENSION_POINT_NAME);
    }

    private IExtensionRegistry getExtensionRegistry() {
        return RegistryFactory.getRegistry();
    }

    private String getPluginID() {
        return this.getPlugin().getPluginID();
    }

    private JptCommonCorePlugin getPlugin() {
        return JptCommonCorePlugin.instance();
    }

    public String toString() {
        return ObjectTools.toString((Object)this, this.resourceLocatorConfigs);
    }
}

