/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.maven.core.repositories;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.LinkedHashSet;
import java.util.Set;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.WorkbenchException;
import org.eclipse.ui.XMLMemento;
import org.jboss.tools.maven.core.MavenCoreActivator;
import org.jboss.tools.maven.core.repositories.NexusRepository;

public class RemoteRepositoryManager {
    private static final String NEXUS_REPOSITORIES = "nexusRepositories";
    private static final String NEXUS_REPOSITORY = "nexusRepository";
    private static final String NAME = "name";
    private static final String URL = "url";
    private static final String ENABLED = "enabled";
    private Set<NexusRepository> nexusRepositories;

    public Set<NexusRepository> getNexusRepositories() {
        if (this.nexusRepositories == null) {
            try {
                this.nexusRepositories = this.loadNexusRepositoriesFromPreferences();
            }
            catch (WorkbenchException e) {
                MavenCoreActivator.log(e);
            }
            if (this.nexusRepositories == null) {
                this.getDefaultRepositories();
            }
        }
        return this.nexusRepositories;
    }

    public Set<NexusRepository> loadNexusRepositoriesFromPreferences() throws WorkbenchException {
        IMemento[] nodes;
        String repositories = RemoteRepositoryManager.getPreferences().get(NEXUS_REPOSITORIES, null);
        if (repositories == null || repositories.isEmpty()) {
            return null;
        }
        StringReader reader = new StringReader(repositories);
        XMLMemento memento = XMLMemento.createReadRoot((Reader)reader);
        IMemento[] iMementoArray = nodes = memento.getChildren(NEXUS_REPOSITORY);
        int n = nodes.length;
        int n2 = 0;
        while (n2 < n) {
            IMemento node = iMementoArray[n2];
            if (this.nexusRepositories == null) {
                this.nexusRepositories = new LinkedHashSet<NexusRepository>();
            }
            String name = node.getString(NAME);
            String url = node.getString(URL);
            boolean enabled = node.getBoolean(ENABLED);
            NexusRepository repository = new NexusRepository(name, url, enabled);
            this.nexusRepositories.add(repository);
            ++n2;
        }
        return this.nexusRepositories;
    }

    public Set<NexusRepository> getDefaultRepositories() {
        this.nexusRepositories = new LinkedHashSet<NexusRepository>();
        this.addRepository("JBoss Nexus Repository", "https://repository.jboss.org/nexus", true);
        this.addRepository("Sonatype Nexus Repository", "http://repository.sonatype.org", false);
        this.addRepository("Apache Nexus Repository", "https://repository.apache.org", false);
        this.addRepository("Sonatype OSS Repository", "http://oss.sonatype.org", false);
        this.addRepository("Java.net Repository", "https://maven.java.net", false);
        return this.nexusRepositories;
    }

    private void addRepository(String name, String url, boolean enabled) {
        NexusRepository repository = new NexusRepository(name, url, enabled);
        this.nexusRepositories.add(repository);
    }

    public void setNexusRepositories(Set<NexusRepository> nexusRepositories) {
        this.nexusRepositories = nexusRepositories;
    }

    public void saveNexusRepositories() {
        block16: {
            if (this.nexusRepositories == null || this.nexusRepositories.size() == 0) {
                return;
            }
            XMLMemento memento = XMLMemento.createWriteRoot((String)NEXUS_REPOSITORIES);
            Writer writer = null;
            try {
                try {
                    for (NexusRepository repository : this.nexusRepositories) {
                        IMemento repositoryNode = memento.createChild(NEXUS_REPOSITORY);
                        repositoryNode.putString(NAME, repository.getName());
                        repositoryNode.putString(URL, repository.getUrl());
                        repositoryNode.putBoolean(ENABLED, repository.isEnabled());
                    }
                    writer = new StringWriter();
                    memento.save(writer);
                    writer.flush();
                    String repositories = writer.toString();
                    RemoteRepositoryManager.getPreferences().put(NEXUS_REPOSITORIES, repositories);
                    RemoteRepositoryManager.getPreferences().flush();
                }
                catch (Exception e) {
                    MavenCoreActivator.log(e);
                    if (writer != null) {
                        try {
                            writer.close();
                        }
                        catch (IOException iOException) {}
                    }
                    break block16;
                }
            }
            catch (Throwable throwable) {
                if (writer != null) {
                    try {
                        writer.close();
                    }
                    catch (IOException iOException) {}
                }
                throw throwable;
            }
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public static IEclipsePreferences getPreferences() {
        IEclipsePreferences prefs = InstanceScope.INSTANCE.getNode("org.jboss.tools.maven.core");
        return prefs;
    }
}

