/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.archives.ui.providers;

import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.Display;
import org.jboss.ide.eclipse.archives.core.build.RegisterArchivesJob;
import org.jboss.ide.eclipse.archives.core.model.ArchivesModel;
import org.jboss.ide.eclipse.archives.core.model.IArchiveModelListener;
import org.jboss.ide.eclipse.archives.core.model.IArchiveModelRootNode;
import org.jboss.ide.eclipse.archives.core.model.IArchiveNode;
import org.jboss.ide.eclipse.archives.core.model.IArchiveNodeDelta;
import org.jboss.ide.eclipse.archives.ui.PrefsInitializer;
import org.jboss.ide.eclipse.archives.ui.providers.ArchivesRootContentProvider;
import org.jboss.ide.eclipse.archives.ui.views.ProjectArchivesCommonView;

public class ArchivesContentProviderDelegate
implements ITreeContentProvider,
IArchiveModelListener {
    private int type;
    private IResourceChangeListener workspaceListener;
    protected Viewer viewerInUse;
    protected ArrayList<IProject> loadingProjects = new ArrayList();
    private ArrayList<IProject> failedLoads = new ArrayList();

    public ArchivesContentProviderDelegate(int type) {
        this.type = type;
        ArchivesModel.instance().addModelListener((IArchiveModelListener)this);
        this.addWorkspaceListener();
    }

    public ArchivesContentProviderDelegate(boolean addListener) {
        this.type = 1;
        if (addListener) {
            ArchivesModel.instance().addModelListener((IArchiveModelListener)this);
        }
        this.addWorkspaceListener();
    }

    private void addWorkspaceListener() {
        this.workspaceListener = new IResourceChangeListener(){

            public void resourceChanged(IResourceChangeEvent event) {
                IResource r = event.getResource();
                int t = event.getType();
                boolean shouldClear = t == 2 || t == 4 || t == 32;
                IProject[] toClear = new IProject[]{};
                if (r instanceof IProject && shouldClear) {
                    toClear = new IProject[]{(IProject)r};
                } else if (r == null) {
                    toClear = ArchivesContentProviderDelegate.this.discoverChangedProjects(event);
                }
                int i = 0;
                while (i < toClear.length) {
                    if (toClear[i] != null && ArchivesContentProviderDelegate.this.failedLoads.contains(toClear[i])) {
                        ArchivesContentProviderDelegate.this.failedLoads.remove(toClear[i]);
                        ArchivesContentProviderDelegate.this.safeRefreshViewer(toClear[i]);
                    }
                    ++i;
                }
            }
        };
        ResourcesPlugin.getWorkspace().addResourceChangeListener(this.workspaceListener);
    }

    private IProject[] discoverChangedProjects(IResourceChangeEvent event) {
        final ArrayList toClear = new ArrayList();
        IResourceDelta delta = event.getDelta();
        try {
            delta.accept(new IResourceDeltaVisitor(){

                public boolean visit(IResourceDelta delta) throws CoreException {
                    IPath projectRel = delta.getResource().getProjectRelativePath();
                    if (projectRel != null && projectRel.segmentCount() == 1 && projectRel.lastSegment().equals(".packages")) {
                        toClear.add(delta.getResource().getProject());
                    }
                    return delta.getResource() instanceof IWorkspaceRoot || delta.getResource() instanceof IProject;
                }
            });
        }
        catch (CoreException coreException) {}
        return toClear.toArray(new IProject[toClear.size()]);
    }

    private void removeWorkspaceListener() {
        ResourcesPlugin.getWorkspace().removeResourceChangeListener(this.workspaceListener);
    }

    public Object[] getChildren(Object parentElement) {
        if (parentElement instanceof WrappedProject) {
            WrappedProject wp = (WrappedProject)parentElement;
            IProject p = ((WrappedProject)parentElement).getElement();
            if (this.loadingProjects.contains(p)) {
                return new Object[]{new DelayProxy(wp)};
            }
            if (this.failedLoads.contains(p)) {
                return new Object[]{"Error parsing project archives descriptor."};
            }
            if (!p.isOpen()) {
                return new Object[0];
            }
            if (ArchivesModel.instance().isProjectRegistered(p.getLocation())) {
                return ArchivesModel.instance().getRoot(p.getLocation()).getAllChildren();
            }
            if (ArchivesModel.instance().canReregister(p.getLocation())) {
                this.loadingProjects.add(p);
                DelayProxy dp = new DelayProxy(wp);
                this.launchRegistrationThread(dp);
                return new Object[]{dp};
            }
        }
        if (parentElement instanceof IArchiveNode) {
            return ((IArchiveNode)parentElement).getAllChildren();
        }
        return new Object[0];
    }

    protected void launchRegistrationThread(final DelayProxy dp) {
        RegisterArchivesJob.RegistrationCallback callback = new RegisterArchivesJob.RegistrationCallback(){

            public void run() {
                Display.getDefault().asyncExec(new Runnable(){

                    public void run() {
                        (this).ArchivesContentProviderDelegate.this.loadingProjects.remove(dp.project);
                        ArchivesContentProviderDelegate.this.refreshViewer(dp.wProject);
                    }
                });
            }

            public void registrationFailed() {
                Display.getDefault().asyncExec(new Runnable(){

                    public void run() {
                        if (!ArchivesContentProviderDelegate.this.failedLoads.contains(dp.project)) {
                            ArchivesContentProviderDelegate.this.failedLoads.add(dp.project);
                        }
                        (this).ArchivesContentProviderDelegate.this.loadingProjects.remove(dp.project);
                        ArchivesContentProviderDelegate.this.refreshViewer(dp.wProject);
                    }
                });
            }
        };
        RegisterArchivesJob job = new RegisterArchivesJob(new IProject[]{dp.project}, (Runnable)callback);
        job.schedule();
    }

    protected boolean shouldRefreshProject() {
        return ProjectArchivesCommonView.getInstance() != null && this.viewerInUse == ProjectArchivesCommonView.getInstance().getCommonViewer() && !PrefsInitializer.getBoolean("showProjectRoot");
    }

    public Object getParent(Object element) {
        return null;
    }

    public boolean hasChildren(Object element) {
        if (element instanceof IArchiveNode) {
            return this.getChildren(element).length > 0;
        }
        if (element instanceof IResource) {
            return ((IResource)element).getProject().isOpen() && ArchivesModel.instance().canReregister(((IResource)element).getLocation());
        }
        if (element == ArchivesRootContentProvider.NO_PROJECT) {
            return false;
        }
        return !(element instanceof DelayProxy);
    }

    public Object[] getElements(Object inputElement) {
        return this.getChildren(inputElement);
    }

    public void dispose() {
        ArchivesModel.instance().removeModelListener((IArchiveModelListener)this);
        this.removeWorkspaceListener();
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        this.viewerInUse = viewer;
    }

    public void modelChanged(IArchiveNodeDelta delta) {
        Object topChanges;
        if (delta.getKind() == 1024) {
            topChanges = this.getChanges(delta);
        } else {
            if (delta.getKind() == 0) {
                return;
            }
            topChanges = delta.getPostNode() == null ? null : new IArchiveNode[]{delta.getPostNode()};
        }
        Display.getDefault().asyncExec(new Runnable((IArchiveNode[])topChanges){
            private final /* synthetic */ IArchiveNode[] val$topChanges;
            {
                this.val$topChanges = iArchiveNodeArray;
            }

            public void run() {
                if (this.val$topChanges == null) {
                    ArchivesContentProviderDelegate.this.refreshViewer(null);
                    return;
                }
                int i = 0;
                while (i < this.val$topChanges.length) {
                    ArchivesContentProviderDelegate.this.refreshViewer(this.val$topChanges[i]);
                    ++i;
                }
            }
        });
    }

    protected void safeRefreshViewer(final Object o) {
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                ArchivesContentProviderDelegate.this.refreshViewer(o);
            }
        });
    }

    protected void refreshViewer(Object o) {
        if (o instanceof IArchiveModelRootNode) {
            String projName = ((IArchiveModelRootNode)o).getProjectName();
            if (projName == null) {
                return;
            }
            IProject p = ResourcesPlugin.getWorkspace().getRoot().getProject(projName);
            if (p != null) {
                o = new WrappedProject(p, this.type);
            }
        }
        if (o instanceof WrappedProject && this.shouldRefreshProject()) {
            o = ((WrappedProject)o).element;
        }
        if (!this.viewerInUse.getControl().isDisposed()) {
            if (this.viewerInUse instanceof StructuredViewer) {
                if (o == null) {
                    ((StructuredViewer)this.viewerInUse).refresh();
                } else {
                    ((StructuredViewer)this.viewerInUse).refresh(o);
                    if (this.viewerInUse instanceof TreeViewer) {
                        ((TreeViewer)this.viewerInUse).expandToLevel(o, 1);
                    }
                }
            } else {
                this.viewerInUse.refresh();
            }
        }
    }

    protected IArchiveNode[] getChanges(IArchiveNodeDelta delta) {
        IArchiveNodeDelta[] children = delta.getAllAffectedChildren();
        ArrayList<IArchiveNode> list = new ArrayList<IArchiveNode>();
        int i = 0;
        while (i < children.length) {
            if (children[i].getKind() == 1024) {
                list.addAll(Arrays.asList(this.getChanges(children[i])));
            } else {
                list.add(children[i].getPostNode());
            }
            ++i;
        }
        return list.toArray(new IArchiveNode[list.size()]);
    }

    public static class DelayProxy {
        public WrappedProject wProject;
        public IProject project;

        public DelayProxy(WrappedProject wp) {
            this.wProject = wp;
            this.project = this.wProject.element;
        }

        public boolean equals(Object otherObject) {
            return otherObject instanceof DelayProxy && this.wProject.equals(((DelayProxy)otherObject).wProject);
        }

        public int hashCode() {
            return this.wProject.hashCode() + 15;
        }

        public String toString() {
            return this.wProject.toString();
        }
    }

    public static class WrappedProject {
        public static final int NAME = 1;
        public static final int CATEGORY = 2;
        private IProject element;
        private int type;

        public WrappedProject(IProject element, int type) {
            this.element = element;
            this.type = type;
        }

        public IProject getElement() {
            return this.element;
        }

        public int getType() {
            return this.type;
        }

        public boolean equals(Object otherObject) {
            return otherObject instanceof WrappedProject && this.element.equals((Object)((WrappedProject)otherObject).element);
        }

        public String toString() {
            return String.valueOf(this.element.toString()) + "," + this.type;
        }

        public int hashCode() {
            return this.element.hashCode() + this.type;
        }
    }
}

