/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.wizards.datatransfer;

import java.io.File;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.ui.internal.wizards.datatransfer.Activator;
import org.eclipse.ui.wizards.datatransfer.ProjectConfigurator;

public class EclipseProjectConfigurator
implements ProjectConfigurator {
    @Override
    public Set<File> findConfigurableLocations(File root, IProgressMonitor monitor) {
        HashSet<File> res = new HashSet<File>();
        this.collectProjectDirectories(res, root, monitor);
        return res;
    }

    private void collectProjectDirectories(HashSet<File> res, File root, IProgressMonitor monitor) {
        if (new File(root, ".project").isFile()) {
            res.add(root);
        }
        if (!monitor.isCanceled()) {
            File[] fileArray = root.listFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File child = fileArray[n2];
                if (child.isDirectory()) {
                    this.collectProjectDirectories(res, child, monitor);
                }
                ++n2;
            }
        }
    }

    @Override
    public boolean shouldBeAnEclipseProject(IContainer container, IProgressMonitor monitor) {
        return container.getFile((IPath)new Path(".project")).exists();
    }

    @Override
    public Set<IFolder> getDirectoriesToIgnore(IProject project, IProgressMonitor monitor) {
        return null;
    }

    @Override
    public boolean canConfigure(IProject project, Set<IPath> ignoredPaths, IProgressMonitor monitor) {
        return true;
    }

    @Override
    public IWizard getConfigurationWizard() {
        return null;
    }

    @Override
    public void configure(IProject project, Set<IPath> excludedDirectories, IProgressMonitor monitor) {
        try {
            project.refreshLocal(2, monitor);
        }
        catch (CoreException ex) {
            Activator.getDefault().getLog().log((IStatus)new Status(4, Activator.getDefault().getBundle().getSymbolicName(), ex.getMessage(), (Throwable)ex));
        }
    }
}

